/*
 *   Written by Bradley Broom (2002).
 *
 *   Copyright (c) 2002 Bradley Broom
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <math.h>
#include <unistd.h>
#include <string.h>

#include "MRI.h"
#include "MRW_Loader.h"
#include "options.h"

char	*progname;

void
Usage()
{
	fprintf (stderr, "Usage: %s [ dx [ dy [ x y width height ] ] ] < mrwfile > pnmfile\n", progname);
	fprintf (stderr, "Command line options:\n");
	PrintOptions (stderr);
	exit (1);
}

int
main (int argc, char *argv[])
{
	MRI *mri;
	struct link *head;
	char		*errmsg;
	int	dx, dy;

	progname = argv[0];
	dx = dy = 1;

	if (argc > 1) {
		dx = dy = atoi (argv[1]);
		if (dx < 1)
			Usage();
		if (argc > 2) {
			dy = atoi (argv[2]);
			if (dy < 1)
				Usage();
		}
	}
	if ((dx > 1 || dy > 1) && ((dx & 1) || (dy & 1))) {
		fprintf (stderr, "%s: scale factors must be even.\n", progname);
	}
	mri = MRW_Loader (stdin, &errmsg);
	if (mri == (MRI *)0) {
		fprintf (stderr, "%s: cannot read image from standard input (%s).\n", progname, errmsg);
		Usage ();
	}

	fprintf (stderr, "%s: Info: Raw image from camera %s\n", progname, MRI_GetCameraName (mri));
	fprintf (stderr, "%s: Info: CCD size = %dx%d\n", progname, MRI_GetHeight(mri), MRI_GetWidth(mri));

	/* Create output filter sequence starting from the rear.
	 * The last link in the pipeline outputs scanlines to the output device.
	 */
	head = MRI_GenPPMWriter (8, 0, stdout);
	if (dx > 1 || dy > 1)
		head = MRI_GenSubsampler (dx, dy, head);
        MRI_ProcessImage (head, mri, 0);
        MRI_FlushPipeline (head);

	exit (0);
}
