/***************************************************************************
 *
 * $Id: safe.c 93 2009-08-24 20:57:31Z Michael.McTernan $
 *
 * This file is part of timgen, a timing diagram renderer.
 * Copyright (C) 2005 Michael C McTernan, Michael.McTernan.2001@cs.bris.ac.uk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 **************************************************************************/

#define FILE_NAME SAFE

/*****************************************************************************
 * Header Files
 *****************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

/*****************************************************************************
 * Preprocessor Macros & Constants
 *****************************************************************************/

/*****************************************************************************
 * Typedefs
 *****************************************************************************/

/*****************************************************************************
 * Local Variable Definitions
 *****************************************************************************/

/*****************************************************************************
 * Global Variable Definitions
 *****************************************************************************/

/*****************************************************************************
 * Local Function Definitions
 *****************************************************************************/

static void checkNotNull(void *p, const char *message)
{
    if(!p)
    {
        fprintf(stderr, "Fatal error: %s\n", message);
        exit(EXIT_FAILURE);
    }
}

/*****************************************************************************
 * Global Function Definitions
 *****************************************************************************/

void *malloc_s(size_t size)
{
    void *r = malloc(size);

    checkNotNull(r, "malloc() failed");

    return r;
}

void *zalloc_s(size_t size)
{
    void *r = malloc(size);

    checkNotNull(r, "malloc() failed");
    memset(r, 0, size);

    return r;
}

char *strdup_s(const char *s)
{
    char *r = strdup(s);

    checkNotNull(r, "strdup() failed");

    return r;
}

/*****************************************************************************
 * Unit Test Support
 *****************************************************************************/


/* END OF FILE */
