struct ymdinfo {
  short y; /* Indices of year, month, and day in date */
  short m;
  short d;
  wchar_t sep1;
  wchar_t sep2;
};


/* Entry in the map table, for mapping sequences to codes */

struct mapentry{
  wchar_t *str;
  wchar_t code;
  size_t len;			/* Length of str */
};

/* Entry in the substitution list */

struct subentry{
  regex_t cregexp;	/* Compiled regexp */
  wchar_t *se;		/* String to substitute */
  size_t len;		/* Length of se */
  struct subentry *next;
};

#define MONTHNAMES 24

/*
 * Each key is represented by one keyinfo structure.
 */

struct keyinfo{
  int SelectType;		/* How to select key field */
  regex_t cregexp;		/* Compiled tag regexp */ 
  short Number;		 	/* Which field to sort on if numbered */
  short Last;			/* The last field to sort on in a range */
  wchar_t *RankTable;
  int ExclusionSpec;		/* Have exclusions been specified on command line or in file? */
  struct mapentry **MapTable;
  int MapTableEntries;
  struct subentry *SubList;	/* The substitution list */
  int SubListEntries;
  wchar_t NextCode;		/* Next code available in rank table */
  wchar_t MaxMGCode;		/* The highest codepoint available for multigraphs */
  long TotalCodes;
  int RangeFirst;		/* First character in range */
  int RangeLast;		/* Last  character in range */
  int FirstOffset;
  int LastOffset;
  short OptionalP;		/* Is this key optional? */
  short MissingKeyComparison;	/* How missing keys compare to keys that are present */
  short ReverseP;		/* Reverse field? */
  short FoldCaseP;		/* Fold case? */
  short TurkicFoldCaseP;	/* Also do Turkic case-folding? */
  wchar_t *Tag;		        /* Tag of field to sort on if tagged */
  wchar_t *WhiteSpace;		/* The characters to treat as separators in the sort order file */
  struct ymdinfo ymd;		/* Date format */
  unsigned short CompType;	/* Type of comparison to use */
  int ExclusionEntries;
  wchar_t *ExclusionTable;
  short StripDiacriticsP;
  short ConvertEnclosedP;
  short ConvertStylisticP;
  short LocaleP;		/* Use glibc locale-based comparison? */
  char *Locale;			/* Locale for this key */
  wchar_t * MonthNames[MONTHNAMES];
};
