/* $Id: ignore.c,v 1.9 2000/03/18 12:55:41 zap Exp $
 * -------------------------------------------------------
 * Copyright (c) 1998-2000 Sebastian Kienzl <zap@riot.org>
 * -------------------------------------------------------
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "muh.h"
#include "ignore.h"
#include "table.h"

typedef struct {
    char *hostname;
    int ttl;
    int type;
} ignore_type;

typedef struct {
    ignore_type **data;
    int amount;
} ignores_type;

ignores_type ignores;

void add_ignore( char *hostname, int ttl, int type )
{
    int i, index;
    
    if( !hostname ) return;
    for( i = 0; i < ignores.amount; i++ )
        if( ignores.data[ i ] &&
            ( strcmp( ignores.data[ i ]->hostname, hostname ) == 0 ) &&
            ( ignores.data[ i ]->type == type ) ) return;
    /* already in table? */
    
    ignores.data = ( ignore_type ** )add_item( ( void ** )ignores.data, sizeof( ignore_type ), &ignores.amount, &index );
    ignores.data[ index ]->hostname = strdup( hostname );
    ignores.data[ index ]->ttl = ttl;
    ignores.data[ index ]->type = type;
}

void del_ignore( char *hostname )
{
    int i;
    for( i = 0; i < ignores.amount; i++ )
        if( ignores.data[ i ] && ( strcmp( ignores.data[ i ]->hostname, hostname ) == 0 ) ) {
            free( ignores.data[ i ]->hostname );
            ignores.data = ( ignore_type ** )rem_item( ( void ** )ignores.data, i, &ignores.amount );
        }
}

void del_ignorebynumber( int i )
{
    if( i < ignores.amount && ignores.data[ i ] ) {
        free( ignores.data[ i ]->hostname );
        ignores.data = ( ignore_type ** )rem_item( ( void ** )ignores.data, i, &ignores.amount );
    }
}


void process_ignores()
{
    int i;
    for( i = 0; i < ignores.amount; i++ ) {
        if( ignores.data[ i ] ) {
            if( ignores.data[ i ]->ttl ) ignores.data[ i ]->ttl--;
            else del_ignorebynumber( i );
        }
    }
}

int is_ignore( char *hostname, int type )
{
    int i;
    for( i = 0; i < ignores.amount; i++ )
        if( ignores.data[ i ] &&
            ( strcmp( ignores.data[ i ]->hostname, hostname ) == 0 ) &&
            ( ignores.data[ i ]->type == type ) ) return 1;
    return 0;
}
