/* These are the number of static items of button bar menu: change this if you
   change the menu */

#include "mgt.h"


extern char * trunc_string (char * s, int len);

extern void
terminal_config_free (struct terminal_config *cfg);
extern void
on_add_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data);

extern void
on_remove_button_clicked               (GtkButton       *button,
                                        gpointer         user_data);

extern void on_del_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data);
extern void on_chg_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data);


extern void
on_cancel_button_clicked               (GtkButton       *button,
                                        gpointer         user_data);
extern struct terminal_config *
terminal_config_dup (struct terminal_config *cfg);
extern void
title_changed(ZvtTerm *term, VTTITLE_TYPE type, char *newtitle);
extern void
gnome_term_set_font (ZvtTerm *term, char *font_name, const int use_bold);
extern void
terminal_kill (GtkWidget *widget, void *data);
void
term_change_pos(GtkWidget *widget);
extern int
button_press (GtkWidget *widget, GdkEventButton *event, ZvtTerm *term);
extern void
get_shell_name (char **shell, char **name, gboolean isLogin);
extern void
show_pty_error_dialog (int errcode);
extern void
set_hints (GtkWidget *widget);
extern void
configure_term_dnd (ZvtTerm *term);

extern GnomeUIInfo custom_submenu_void [];

extern void
set_color_scheme (ZvtTerm *term, struct terminal_config *color_cfg);
ZvtTerm* current_term(GSList** p_term_list);

/*
extern GtkWidget*
xzvt_term_new_with_size (int cols, int rows);

#include "xzvt.h"
extern int
xzvt_term_forkpty (xZvtTerm *x_term, int do_uwtmp_log);
*/

extern char **env;
extern char **environ;

extern char **env_copy;
extern int winid_pos;
extern int term_pos;


/* A list of all the open terminals */
extern GList *terminals;
/* This is the terminal associated with the initial command, or NULL
   if there isn't one.  */
extern GtkWidget *initial_term;
extern gboolean zvt_pixmap_support;

void free_str_array(char** ptr);
extern GnomeUIInfo gnome_terminal_toolbar[];
void set_tab_label(GtkNotebook* nb, ZvtTerm* term, GSList** ptl, int state);
void set_all_undefined(GSList** ptl);

#ifdef MGT_DEBUG
#define _dbg_(a,b,c) printf(a,b,c)
#else
#define _dbg_(a,b,c) 
#endif

int check_changed_buffers(gpointer data)
{
  /* check all terminal state:
     this a simply state machine */
  GtkWidget *curt, *app, *te;
  GSList* wins, **ptl =NULL, *tl;
  int n, *isres;
  GtkNotebook* nb = NULL;
  int *new_out, *p_cur_state;


  wins = *((GSList**) data);
  app = NULL;
  
  while (wins)
    {
      app = GTK_WIDGET(wins->data);
      nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");      
      ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
      tl = *ptl;
      while (tl)
	{
	  te = GTK_WIDGET(tl->data);
	  if (GTK_WIDGET_HAS_FOCUS(te))
	    {
	      break;
	    }
	  tl = tl->next;
	}
      wins = wins->next;
    }

  isres = gtk_object_get_data(GTK_OBJECT(app), "is_a_resize");
  if (*isres)
    {
      set_all_undefined(ptl);
      *isres = FALSE;
      return 1;
    }

  n= 0;
  tl = *ptl;
  curt = GTK_WIDGET(current_term(ptl));
  while (tl)
    {
      te = GTK_WIDGET(tl->data);
      /*p_old_state = gtk_object_get_data(GTK_OBJECT(te), "old_state");*/
      p_cur_state = gtk_object_get_data(GTK_OBJECT(te), "term_state");
      if (te == curt)
	{
	  if (*p_cur_state == CHANGING || *p_cur_state == CHANGED)
	    {
	      _dbg_("te: %d curstate: %d -> VISIBLE\n", n, *p_cur_state);
	      *p_cur_state = VISIBLE;
	      set_tab_label(nb, ZVT_TERM(te), ptl, UNCHANGED);     
	      
	    }
	  n++;
    	  tl = tl->next;
	  continue;
	}
      new_out = gtk_object_get_data(GTK_OBJECT(te), "new_out");
      if (*new_out == TRUE)
	{
	  if (*p_cur_state != CHANGING && *p_cur_state != UNDEFINED && 
	      *p_cur_state != VISIBLE)
	    { 
	      /* If terminal is not still changing or terminal and is not just opened
		 and terminal is not just switched then 
		 don't rewrite tab label */
	      set_tab_label(nb, ZVT_TERM(te), ptl, CHANGING);
	      _dbg_("te: %d cur_state: %d -> CHANGING!\n", n, *p_cur_state);
	      *p_cur_state = CHANGING;
	    }
	  else if (*p_cur_state == UNDEFINED)
	    {
	      _dbg_("te: %d cur_state: %d -> UNCHANGED\n", n, *p_cur_state);
	      *p_cur_state = UNCHANGED;
	    }
	  else if (*p_cur_state == VISIBLE)
	    {
	      /* If here the terminal was visible but actually not so
		 put it in UNCHANGED state */
	      _dbg_("te: %d cur_state:%d -> UNCHANGED\n", n, *p_cur_state);
	      *p_cur_state = UNCHANGED;
	    }
  	  *new_out = FALSE;
	}
      else
	{
	  if (*p_cur_state == CHANGING)
	    {
	      set_tab_label(nb, ZVT_TERM(te), ptl, CHANGED);
	      _dbg_("te: %d curstate:%d -> CHANGED\n", n, *p_cur_state);
	      *p_cur_state = CHANGED;
	    }
	  else if ((*p_cur_state != CHANGED) && (*p_cur_state != UNCHANGED) )
	    {
	      _dbg_("te: %d NOOUTPUT state:%d -> UNCHANGED\n", n, *p_cur_state);
	      *p_cur_state = UNCHANGED;
	    }
	}
      n++;
      tl = tl->next;
    }
  return 1;
}

GtkStyle* tab_style[UNDEFINED+1];

GdkColor colors[] = {
        {0, 0xcf3c, 0xcf3c, 0xcf3c}, /* 0  white */
        {0, 0x0000, 0x0000, 0x0000}, /* 1  black */
        {0, 0x0000, 0x0000, 0xcccc}, /* 2  blue */
        {0, 0x0000, 0xcccc, 0x0000}, /* 3  green */
        {0, 0xdddd, 0x0000, 0x0000}, /* 4  red */
        {0, 0xaaaa, 0x0000, 0x0000}, /* 5  light red */
        {0, 0xbbbb, 0x0000, 0xbbbb}, /* 6  purple */
        {0, 0xffff, 0xaaaa, 0x0000}, /* 7  orange */
        {0, 0xeeee, 0xdddd, 0x2222}, /* 8  yellow */
        {0, 0x3333, 0xdede, 0x5555}, /* 9  green */
        {0, 0x0000, 0xcccc, 0xcccc}, /* 10 aqua */
        {0, 0x3333, 0xdddd, 0xeeee}, /* 11 light aqua */
        {0, 0x0000, 0x0000, 0xffff}, /* 12 blue */
        {0, 0xeeee, 0x2222, 0xeeee}, /* 13 light purple */
        {0, 0x7777, 0x7777, 0x7777}, /* 14 grey */
        {0, 0x9999, 0x9999, 0x9999}, /* 15 light grey */
        {0, 0xbe00, 0xbe00, 0xbe00}, /* 16 marktext Back (white) */
        {0, 0x0000, 0x0000, 0x0000}, /* 17 marktext Fore (black) */
        {0, 0xcf3c, 0xcf3c, 0xcf3c}, /* 18 foreground (white) */
        {0, 0x0000, 0x0000, 0x0000}, /* 19 background (black) */
};

void init_styles(GtkStyle* style, struct terminal_config* cfg)
{
  int i;
  GdkColor c;
  for (i = 0; i < UNDEFINED + 1; i++)
    {
#ifdef DEFAULT_GTK_STYLE
      tab_style[i] = gtk_style_new();
      gdk_font_unref(tab_style[i]->font);
#else
      tab_style[i] = gtk_style_copy(style);
#endif
      if (i == CHANGING)
	{
	  c.pixel = 0;
	  c.red = cfg->palette[18].red;
	  c.green = cfg->palette[18].green;
	  c.blue = cfg->palette[18].blue; 
	  tab_style[i]->fg[0] = c;/*black as default for all states!*/
	}
      else if (i == CHANGED)
	{
	   c.pixel = 0;
	   c.red = cfg->palette[19].red;
	   c.green = cfg->palette[19].green;
	   c.blue = cfg->palette[19].blue; 
	   tab_style[i]->fg[0] = c;
	}
#ifdef DEFAULT_GTK_STYLE
      else
	tab_style[i]->fg[0] = style->fg[0];	
      tab_style[i]->font = style->font; 
      gdk_font_ref(tab_style[i]->font);
#endif
    }
  
}

void set_styles(struct terminal_config* cfg)
{
  GdkColor c;
  c.pixel = 0;
  c.red = cfg->palette[18].red;
  c.green = cfg->palette[18].green;
  c.blue = cfg->palette[18].blue; 
  tab_style[CHANGING]->fg[0] = c;/*black as default for all states!*/
  c.pixel = 0;
  c.red = cfg->palette[19].red;
  c.green = cfg->palette[19].green;
  c.blue = cfg->palette[19].blue; 
  tab_style[CHANGED]->fg[0] = c;
}
#if 0
void
set_tab_color (GSList** ptl)
{
  GtkWidget* app, *label;
  GtkWidget* te, *page;
  GSList* tmp;
  GtkNotebook* nb;
  int *p_state, n, state;
  
  tmp = *ptl;
  te = GTK_WIDGET(tmp->data);
  app = gtk_widget_get_toplevel(te);
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  n = 0;
  while (tmp) 
    { 
      te = GTK_WIDGET(tmp->data);
      p_state = gtk_object_get_data(GTK_OBJECT(te), "term_state");
      page = gtk_notebook_get_nth_page(nb, n);
      label = gtk_notebook_get_tab_label(nb,page);
      printf("nb: %p label: %p *p_state: %d tab_style[*p_state].red:%d \n", 
	     nb, label, *p_state,
	     tab_style[*p_state]->fg[0].red);
      state = *p_state;
      gtk_widget_set_style(label, tab_style[state]);
      n++;
      tmp = tmp->next;
    }
}
#endif

void
set_tab_color (GtkWidget* term, struct terminal_config* cfg)
{
  GtkWidget* app, *label;
  GtkWidget* te, *page;
  GSList** ptl;
  GSList* tmp;
  GtkNotebook* nb;
  int *p_state, n, which_term = -1, state;
  
  app = gtk_widget_get_toplevel(term);
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  p_state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
  
  tmp = *ptl;
  n = 0;
  while(tmp)
    {
      te = GTK_WIDGET(tmp->data);
      if (te == term)
	{
	  which_term = n;
	  break;
	}
      tmp = tmp->next;
      n++;
    } 
  if (which_term == -1)
    {
      return;
    }
  
  page = gtk_notebook_get_nth_page(nb, which_term);
  label = gtk_notebook_get_tab_label(nb,page);
  state = *p_state;
  /* need to go through normal style to switch to new color */
  gtk_widget_set_style(label, tab_style[UNCHANGED]);
  gtk_widget_set_style(label, tab_style[state]);
}

void set_tab_label(GtkNotebook* nb, ZvtTerm* term, GSList** ptl, int state )
{
  GSList* tmp;
  int n, which_term = -1;
  ZvtTerm* te;
  GtkWidget* page, *label;
  char* tname;

  tname = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
  tmp = *ptl;

  n = 0;

  while(tmp)
    {
      te = ZVT_TERM(tmp->data);
      if (te == term)
	{
	  which_term = n;
	  break;
	}
      tmp = tmp->next;
      n++;
    } 

  page = gtk_notebook_get_nth_page(nb, which_term);
  label = gtk_notebook_get_tab_label(nb,page);
 
  gtk_widget_set_style(GTK_WIDGET(label),tab_style[state]);
  te = current_term(ptl);
  gtk_widget_grab_focus(GTK_WIDGET(te));
}

/* callback for new output on terminals */
void new_output(ZvtTerm* term)
{
  GtkWidget* app, *nb;
  GSList** ptl;
  int *p_state, *new_out;
  p_state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
  new_out = gtk_object_get_data(GTK_OBJECT(term), "new_out");
  
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  nb = (GtkWidget*)gtk_object_get_data(GTK_OBJECT(app), "notebook");
  ptl = (GSList**) gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  
  if (term == current_term(ptl))
    return;
  if (*p_state != CHANGING)
    {
      /*set_tab_label(GTK_NOTEBOOK(nb), term, ptl, CHANGING);*/
    }

  *new_out = TRUE;
}

void ok_close_app(GtkWidget* app)
{
  preferences_t *prefs;
  GSList** p_term_list;
  GSList *tmp;
  GtkWidget* term;
  char* termname, *termtitle;
  struct terminal_config* cfg;
  char **cmds, **cmds_names;
  GnomeUIInfo* sm;
  GtkItemFactoryEntry* cm;
  int x, *state, *new_out, *isres;
  terminals = g_list_remove (terminals, app);
  /* FIXME: this should free the config info for the window */
  
  if (app == initial_term)
    initial_term = NULL;
 
  /* WARNING:
     Here must free all memory allocated for the current window(GnomeApp) */
  
  p_term_list = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  /* get prefs from first terminal if p_term_list */
  prefs =  gtk_object_get_data((GtkObject*)(*p_term_list)->data,"prefs");
  
  /* remove array containing custom commands and their (menu) names */
  cmds = (char**) gtk_object_get_data(GTK_OBJECT(app), "cmds_list");
  free_str_array(cmds);
  cmds_names = (char**) gtk_object_get_data(GTK_OBJECT(app), "cmds_names");
  free_str_array(cmds_names);
  isres = gtk_object_get_data(GTK_OBJECT(app), "is_a_resize");
  g_free(isres);
  /* remove submenu */
  sm = (GnomeUIInfo*) gtk_object_get_data(GTK_OBJECT(app), "custom_submenu");
  if (sm)
    {
      x = 0;
      while (sm[x].type != GNOME_APP_UI_ENDOFINFO)
	{
	  free(sm[x].user_data);
	  x++; 
	}	
      free(sm);
    }

  cm = gtk_object_get_data(GTK_OBJECT(app), "buttonbar_menu");
  if (cm) 
    {
      x = DEFAULT_BUTTONBAR_ITEMS;
      
      while(cm[x].path)
	{
	  free(cm[x].path);
	  x++;
	}
    
      free(cm);
    }

  /* remove all resources related to terminals */
  tmp= *p_term_list;
 
  while(tmp)
    {
      term = GTK_WIDGET(tmp->data); 
      cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
      /* free copied resources  CHECK THIS !!!-> MIGUEL*/
      terminal_config_free(cfg);
      termname = gtk_object_get_data(GTK_OBJECT(term), "mtermname"); 
      termtitle = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
      new_out = gtk_object_get_data(GTK_OBJECT(term), "new_out");
      state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
      /*zvt_term_killchild(ZVT_TERM(term), SIGKILL);
	zvt_term_closepty(ZVT_TERM(term));*/
      g_free(state);
      g_free(new_out);
      g_free(termname);
      g_free(termtitle);
      tmp = tmp->next;
    }

  if (prefs)
    gtk_object_destroy(GTK_OBJECT(prefs->prop_win));

  g_slist_free(*p_term_list);
  
  gtk_widget_destroy (app);

  if (terminals == NULL)
    gtk_exit(0); /*gtk_main_quit ();*/
  
}

/* ask for a confirm */
void cb_conf_close_app(gint reply, gpointer app)
{
  GSList** ptl;
  GtkWidget* term;
  if (!reply)
    {
      ok_close_app(GTK_WIDGET(app));   
    }
  else
    {
      ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
      term = GTK_WIDGET(current_term(ptl));
      gtk_widget_grab_focus(GTK_WIDGET(term));
    }
}

static void
grab_focus (GtkWidget* app)
{
  GtkWidget* term;
  GSList** l;
  l = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  term = GTK_WIDGET(current_term(l));
  gtk_widget_grab_focus(term);
}

static void
close_app (GtkWidget *app)
{
  GtkWidget *conf_win, *te;
  GSList** ptl;
  struct terminal_config* cfg;
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  
  te = GTK_WIDGET((*ptl)->data);
  cfg = gtk_object_get_data(GTK_OBJECT(te), "config");
  if (!cfg->close_confirm)
    {
      ok_close_app(GTK_WIDGET(app));
      return;
    }
  conf_win = gnome_ok_cancel_dialog_modal
    ("Close window and all its terminals?", cb_conf_close_app, 
     (gpointer) app);
}


void
close_terminal_cmd (void *unused, GSList **p_term_list)

{
        GtkWidget *term;
	GtkWidget *top;
       	
	term = GTK_WIDGET((*p_term_list)->data);
	top = gtk_widget_get_toplevel (GTK_WIDGET (term));
        /* cancella la lista con tutti i terminali creati */
	close_app(top);
	/*g_slist_free(*p_term_list);*/

}

	 
void save_commands(GtkWidget* app, struct terminal_config* cfg)
{
  int n;
  char **cmds, **cmds_names;
  /*char *prefix = g_strdup_printf ("/Terminal/%s/", cfg->class);*/
  char *prefix = g_strdup_printf ("/MultiTerminal/Common/");
  gnome_config_push_prefix (prefix);
  g_free (prefix);
  cmds = gtk_object_get_data(GTK_OBJECT(app), "cmds_list");
  cmds_names = gtk_object_get_data(GTK_OBJECT(app), "cmds_names");
  /*for (n = 0; cmds_names[n]; ++n);*/
  n = 0;
  while(cmds_names[n])
    n++;
  gnome_config_set_vector("cmds", n, (const char* const*) cmds);
  gnome_config_set_vector("cmds_names", n, (const char* const*) cmds_names);
  gnome_config_sync ();
  gnome_config_pop_prefix ();
}

/* ====================== >>> current_term <<< ================================= */
ZvtTerm* current_term(GSList** p_term_list)
{
  GtkWidget *term, *app, *notebook;
  GSList *next;
  int curpage, i;
  term = GTK_WIDGET((*p_term_list)->data);
  app = gtk_widget_get_toplevel (term);
  notebook= gtk_object_get_data(GTK_OBJECT(app), "notebook"); 
  curpage = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
  i = 0;
  next = *p_term_list;
  while(next)
    {
      if (i == curpage)
	{
	  term = GTK_WIDGET(next->data);
	  break;
	}
      i++;
      next =  next->next;
    }
  return ZVT_TERM(term);
  
}

void new_term_in_window(char** cmd, struct terminal_config *cfg_in, const gchar *geometry, int termid, GSList** p_term_list, char* nome_term);
void new_shell(GSList** ptl, guint action);
void new_root(GSList** ptl, guint action);
void new_mc(GSList** ptl, guint action);
void cb_conf_win(gint reply, gpointer data);

void tb_remove_book(GtkWidget *w, GSList** ptl)
{
  GtkNotebook* nb;
  GtkWidget *app, *term;
  GtkWidget *conf_win;

  term = GTK_WIDGET((*ptl)->data);
  app = gtk_widget_get_toplevel(term);
  nb = GTK_NOTEBOOK(gtk_object_get_data(GTK_OBJECT(app), "notebook"));
  if (g_slist_length(*ptl)==1)
    {
      close_app(app);
      return;
    }
  term = GTK_WIDGET(current_term(ptl)); 
  conf_win = gnome_ok_cancel_dialog_modal_parented
    ("Remove current term?", cb_conf_win, 
     (gpointer) term, GTK_WINDOW(app));
}

void button_next_page(GtkWidget* w);
void button_prev_page(GtkWidget* w);

void move_tab_right(GtkNotebook* nb)
{
  GtkWidget *label, *term, *curterm, *rightterm, *child, *curchild, *app;
  GSList** ptl, *tmp;	  
  char* tname, txt[300];
  int n,curpg, l, newpg;
  struct terminal_config* cfg;
  app = gtk_widget_get_toplevel(GTK_WIDGET(nb));
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  curpg  = gtk_notebook_get_current_page(nb);
  curchild = gtk_notebook_get_nth_page(nb, curpg);
  l = g_slist_length(*ptl);
  if (curpg+1>=l)
    newpg = 0;
  else
    newpg = curpg+1;
  /*rightchild = gtk_notebook_get_nth_page(nb, newpg);*/

  curterm = GTK_WIDGET(g_slist_nth(*ptl, curpg)->data);
  rightterm = GTK_WIDGET(g_slist_nth(*ptl,newpg)->data);
   /* and now change also the term list *ptl!*/
  *ptl = g_slist_remove(*ptl, curterm);
  *ptl = g_slist_insert(*ptl, curterm, newpg); 
  gtk_notebook_reorder_child(nb, curchild, newpg);
  tmp = *ptl;
  n = 0;
  while (tmp)
    {
      term = GTK_WIDGET(tmp->data);
      cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
      if (cfg->titled_tabs)
	{
	  tname = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
	}
      else
	tname = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
      sprintf(txt, "%d-%s", n, tname);
      if (cfg->titled_tabs)
	trunc_string(txt, cfg->maxch);
            
      child = gtk_notebook_get_nth_page(nb, n);
      label = gtk_notebook_get_tab_label(nb, child);
      gtk_label_set_text(GTK_LABEL(label),txt);
      label = gtk_notebook_get_menu_label(nb, child);
      gtk_label_set_text(GTK_LABEL(label), txt);
      n++;
      tmp = tmp->next;
    }
  gtk_widget_grab_focus(GTK_WIDGET(curterm));

}

void move_tab_left(GtkNotebook* nb)
{
  GtkWidget *label, *term, *curterm, *leftterm, *child, *curchild, *app;
  GSList** ptl, *tmp;	  
  int n, curpg, l, newpg;
  char *tname, txt[300];
  struct terminal_config* cfg;

  app = gtk_widget_get_toplevel(GTK_WIDGET(nb));
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  curpg  = gtk_notebook_get_current_page(nb);
  curchild = gtk_notebook_get_nth_page(nb, curpg);
  l = g_slist_length(*ptl);
  if (curpg-1<0)
    newpg = l-1;
  else
    newpg = curpg-1;
  curterm = GTK_WIDGET(g_slist_nth(*ptl, curpg)->data);
  leftterm = GTK_WIDGET(g_slist_nth(*ptl,newpg)->data);
   /* and now change also the term list *ptl!*/
  *ptl = g_slist_remove(*ptl, curterm);
  *ptl = g_slist_insert(*ptl, curterm, newpg); 
  gtk_notebook_reorder_child(nb, curchild, newpg);
  tmp = *ptl;
  n = 0;
  while (tmp)
    {
      term = GTK_WIDGET(tmp->data);
      cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
      if (cfg->titled_tabs)
	{
	  tname = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
	}
      else
	tname = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
      sprintf(txt, "%d-%s", n, tname);

      if (cfg->titled_tabs)
	trunc_string(txt, cfg->maxch);

      child = gtk_notebook_get_nth_page(nb, n);
      label = gtk_notebook_get_tab_label(nb, child);
      gtk_label_set_text(GTK_LABEL(label),txt);
      label = gtk_notebook_get_menu_label(nb, child);
      gtk_label_set_text(GTK_LABEL(label), txt);
      n++;
      tmp = tmp->next;
    }
  gtk_widget_grab_focus(GTK_WIDGET(curterm));
}
void butcb_move_left(GtkWidget* w, gpointer data)
{
  move_tab_left(GTK_NOTEBOOK(data));
}

void butcb_move_right(GtkWidget* w, gpointer data)
{
  move_tab_right(GTK_NOTEBOOK(data));
}


void tb_tab_left(GtkWidget* w, GSList** ptl)
{ 
  GtkNotebook* nb;
  GtkWidget *app, *term;

  term = GTK_WIDGET((*ptl)->data);
  app = gtk_widget_get_toplevel(term);
  nb = GTK_NOTEBOOK(gtk_object_get_data(GTK_OBJECT(app), "notebook"));

  move_tab_left(GTK_NOTEBOOK(nb));

}

void tb_tab_right(GtkWidget* w, GSList** ptl)
{ 
  GtkNotebook* nb;
  GtkWidget *app, *term;

  term = GTK_WIDGET((*ptl)->data);
  app = gtk_widget_get_toplevel(term);
  nb = GTK_NOTEBOOK(gtk_object_get_data(GTK_OBJECT(app), "notebook"));
  move_tab_right(GTK_NOTEBOOK(nb));
}

void change_title(GtkWidget* w, gpointer data);

void tb_change_title(GtkWidget* w, GSList** ptl)
{ 
  gpointer nb;
  GtkWidget* app, *term;

  term = GTK_WIDGET((*ptl)->data);
  app = gtk_widget_get_toplevel(term);
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  change_title(w, nb); 
}

void tb_new_shell(GtkWidget* w, GSList** ptl)
{
  new_shell(ptl, 0);
}

void tb_new_mc(GtkWidget* w, GSList** ptl)
{
  new_mc(ptl, 0);
}

void tb_new_root(GtkWidget* w, GSList** ptl)
{
  new_root(ptl, 0);
}


extern GnomeUIInfo gnome_terminal_terminal_menu [];
extern GnomeUIInfo gnome_terminal_menu[];
extern GnomeUIInfo gnome_terminal_edit[];
extern GnomeUIInfo gnome_terminal_help_menu[];
extern GnomeUIInfo gnome_terminal_settings_menu[];


#define COMMANDS_INDEX 5

void free_str_array(char** ptr)
{
  int x = 0;
  /* free both strings arrays */
  if (ptr == NULL)
    return;
  while(ptr[x])
    {
      free(ptr[x]);
      x++;
    }
  free(ptr);
}

struct menu_datas_struct {
  GtkWidget* app;
  char* name;
};

void new_shell_with_command(GtkWidget* w, gpointer data)
{
  /* data is the name of the command to be executed in the new terminal */
  /* deve creare una nuova shell con il comando contenuto in data */
  GtkWidget* app;
  GtkWidget* term;
  char **cmds, **cmds_names, *buf;
  /* the command string is not longer than 128 bytes so this value(256) is enough! */
  char* cmd[256];
  struct terminal_config* cfg;
  int i, x;
  struct menu_datas_struct* md;
  GSList** ptl;
  
  md = (struct menu_datas_struct*) data;
  
  app = md->app;

  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");

  term = GTK_WIDGET((*ptl)->data);
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");

  cmds = gtk_object_get_data(GTK_OBJECT(app), "cmds_list");
  cmds_names = gtk_object_get_data(GTK_OBJECT(app), "cmds_names");

  x = 0;
  while(cmds_names[x])
    {
      if (!strcmp(cmds_names[x], md->name))
	break;
      x++;
    }

  buf = malloc((strlen(cmds[x])+1)*sizeof(char));
  strcpy(buf, cmds[x]);

  cmd[0] =  strtok(buf, " ");
  i = 1;
  while ((cmd[i] = strtok(NULL, " ")))
    i++;

  new_term_in_window(cmd, cfg, NULL, 1, ptl, cmds_names[x]);
  free(buf);

}

void set_menu_user_data(GnomeUIInfo* m, GSList** ptl)
{
  int x = 0;
  while(m[x].type != GNOME_APP_UI_ENDOFINFO)
    {  
      if (m[x].type == GNOME_APP_UI_ITEM || 
	  m[x].type == GNOME_APP_UI_TOGGLEITEM)
	m[x].user_data = ptl;
      x++;
    }      
}

void set_all_menu_user_data(GSList** ptl)
{
  /* If you change menus change this !!! */
  set_menu_user_data(gnome_terminal_terminal_menu, ptl);
  set_menu_user_data(gnome_terminal_edit, ptl);
  set_menu_user_data(gnome_terminal_settings_menu, ptl);
  set_menu_user_data(gnome_terminal_help_menu, ptl);
}

void rebuild_buttonbar_menu( GtkWidget  *window);
void destroy_toolbar(GnomeApp* app);


/* change this if you change the button bar menu */
GtkItemFactoryEntry menu_items2[] = {
    { "/MAIN",            NULL,  NULL, 0, "<Branch>" },
    { "/MAIN/New Shell",    "", new_shell, 0, NULL },
    { "/MAIN/Root Shell",    "", new_root, 0, NULL },
    { "/MAIN/mc",    "", new_mc, 0, NULL },
    { "/MAIN/Separator", NULL, NULL, 0, "<Separator>" }
};

static gchar* attach_data_key = "gtk-menu-attach-data";
void new_shell_with_command_bb(GSList** ptl, gint action);

void rebuild_menubar_from_arrays(GnomeApp* app)
{
  /* commands and commands names arrays */
  GtkCheckMenuItem *toggle_item;
  char **cmds_names, **cmds;
  GSList** ptl;
  struct menu_datas_struct *menu_datas;
  /* custom submenu with commands names */
  GnomeUIInfo* sm;
  int x, num_items, nmenu_items, i; 
  GnomeUIInfo end_menu = { GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,(GnomeUIPixmapType) 0, NULL, 0,(GdkModifierType) 0, NULL };
  GtkWidget *submenu, *mainmenu, *term;
  struct terminal_config* cfg;
  GtkItemFactory *item_factory;
  GtkItemFactoryEntry* cm;
  char str[64];
  GtkAccelGroup* accel_group;

  if (!app->menubar)
    return;
 
  cmds = (char**) gtk_object_get_data(GTK_OBJECT(app), "cmds_list");
  
  cmds_names = (char**) gtk_object_get_data(GTK_OBJECT(app), "cmds_names");
 
  x = 0;
  while(cmds_names[x])
    {
      x++;
    }
  num_items = x + 1;
  
  /* remove all menus first in app menubar */
  gnome_app_remove_menus  (GNOME_APP(app), N_("File"), 5);

  sm = (GnomeUIInfo*) gtk_object_get_data(GTK_OBJECT(app), "custom_submenu");
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");

  if (sm)
    {
      x = 0;
      while (sm[x].type != GNOME_APP_UI_ENDOFINFO)
	{
	  free(sm[x].user_data);
	  x++; 
	}	
      free(sm);
    }
  sm = (GnomeUIInfo*) malloc(sizeof(GnomeUIInfo));

  gtk_object_set_data(GTK_OBJECT(app), "custom_submenu", sm); 
  set_all_menu_user_data(ptl);
  memcpy(sm, &end_menu, sizeof(GnomeUIInfo));
  
  /* attach the new custom menu */
  gnome_terminal_menu[1].moreinfo = sm;
  /* insert the menu */
  gnome_app_insert_menus(GNOME_APP(app), "/", gnome_terminal_menu);
  /* sm[0].widget is created by gtk_menu_item_new() */
  mainmenu = gtk_object_get_data(GTK_OBJECT(app), "menubar_factory_widget"); 
  cm =       gtk_object_get_data(GTK_OBJECT(app), "menubar_factory");
  if (mainmenu)
    {
      x = 0;
      while(cmds[x])
	x++;
      /* 4 are the default items */
      nmenu_items = x + DEFAULT_BUTTONBAR_ITEMS;
      item_factory = gtk_item_factory_from_widget(mainmenu);
      
      x = 0;
      while(cm[x].path)
	x++;
      gtk_item_factory_delete_entries(item_factory, x, cm);
  
      if (cm)
	{
	  x = DEFAULT_BUTTONBAR_ITEMS;
	  
	  while(cm[x].path)
	    {
	      free(cm[x].path);
	      x++;
	    }
	  free(cm);
	}
    }
  else
   {
     accel_group = gtk_accel_group_new ();
     x = 0;
     while(cmds[x])
       x++;
     nmenu_items = x + DEFAULT_BUTTONBAR_ITEMS;
     item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
				       accel_group);
   }
  
  cm = malloc(sizeof(GtkItemFactoryEntry)*(nmenu_items+1));
  gtk_object_set_data(GTK_OBJECT(app), "menubar_factory", cm);
  
  memcpy(cm, menu_items2, sizeof(GtkItemFactoryEntry)*DEFAULT_BUTTONBAR_ITEMS);
 
  /* and now we build the custom part */
  x = 0;
  while (cmds[x])
    {
      i = x + DEFAULT_BUTTONBAR_ITEMS;
      strcpy(str,"/MAIN/");
      strcat(str,cmds_names[x]);
      cm[i].path = malloc((strlen(str)+1)*sizeof(char));
      strcpy(cm[i].path, str);
      cm[i].accelerator = NULL;
      cm[i].callback = new_shell_with_command_bb;
      cm[i].callback_action = x;
      cm[i].item_type = NULL;
      x++;
    }

  cm[x+DEFAULT_BUTTONBAR_ITEMS].path = NULL; 
  
  gtk_item_factory_create_items (item_factory, nmenu_items, cm, ptl);
  submenu = gtk_item_factory_get_widget (item_factory, "/MAIN");
  mainmenu =gtk_item_factory_get_widget (item_factory, "<main>");
  gtk_object_set_data(GTK_OBJECT(app), "menubar_factory_widget", mainmenu);  
  /* this is a trick to avoi a warning due to the fact that 
     the submenu is already attached to gtkmenu created by factory widget
   */
  gtk_object_remove_data (GTK_OBJECT (submenu), attach_data_key);

  gtk_menu_item_set_submenu(GTK_MENU_ITEM(gnome_terminal_menu[1].widget), 
					  submenu); 
  term = GTK_WIDGET((*ptl)->data);
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  if (cfg)
    {
      toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_MENUBAR].widget);
      toggle_item->active = !cfg->menubar_hidden;
      toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_TOOLBAR].widget);
      toggle_item->active = !cfg->toolbar_hidden;
      toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_BUTTONBAR].widget);
      toggle_item->active = !cfg->buttonbar_hidden;
    }
}

int nr;

void get_menus_arrays(GtkWidget* app, GtkCList* l)
{
  char *name, *cmd;
  int r;
  char **cmds_names, **cmds;

  /* cmds e cmds_names must initialized at window (app) creation */
  cmds_names = (char**) gtk_object_get_data(GTK_OBJECT(app), "cmds_names");
  cmds = (char**) gtk_object_get_data(GTK_OBJECT(app), "cmds");
  /* remove old arrays */ 
  free_str_array(cmds_names);
  free_str_array(cmds);

  /* Get the number of rows in the clist object */
  r = 0;
  while(gtk_clist_get_text(l, r, 0, &name))
    {
      r++;
    }

  nr = r + 1;
  cmds_names = malloc(sizeof(char*)*nr);
  cmds = malloc(sizeof(char*)*nr);  
  gtk_object_set_data(GTK_OBJECT(app), "cmds_names", cmds_names);
  gtk_object_set_data(GTK_OBJECT(app), "cmds_list", cmds);

  /* Set arrays using clist datas */  
  r = 0;
  while(gtk_clist_get_text(l, r, 0, &name))
    {
      gtk_clist_get_text(l, r, 1, &cmd);
      cmds_names[r] = (char *) malloc((strlen(name)+1)*sizeof(char));
      cmds[r] = (char *) malloc((strlen(cmd)+1)*sizeof(char));
      strcpy(cmds_names[r], name);
      strcpy(cmds[r], cmd);
      r++;
    }
  cmds_names[r] = NULL;
  cmds[r] = NULL;

}

void
on_ok_button_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win, *term;
  int *cr;
  GtkCList* l;
  GSList** ptl;
  struct terminal_config* cfg;

  l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_cmd"));
  win = gtk_widget_get_toplevel(GTK_WIDGET(button));
  
  get_menus_arrays(GTK_WIDGET(user_data), l);
  
  rebuild_menubar_from_arrays(GNOME_APP(user_data));
  rebuild_buttonbar_menu(GTK_WIDGET(user_data));

  cr = gtk_object_get_data(GTK_OBJECT(l), "current_row");
  free(cr);

  ptl = gtk_object_get_data(GTK_OBJECT(user_data), "ptermlist");
  term = GTK_WIDGET((*ptl)->data);
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  save_commands(GTK_WIDGET(user_data), cfg);

  gtk_widget_destroy(win);
}


void
on_apply_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* l;
  l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_cmd"));
  get_menus_arrays(GTK_WIDGET(user_data), l);
  rebuild_menubar_from_arrays(GNOME_APP(user_data));
  rebuild_buttonbar_menu(GTK_WIDGET(user_data));
}


void edit_commands(GtkWidget* w, gpointer data)
{
  int *current_row, x;
  gchar *glade_file;
  GtkWidget *app;
  GladeXML *gui;
  GtkWidget* win, *txt_name, *txt_command, *lista_cmd, *add_button, *remove_button;
  GtkWidget *chg_button, *del_button, *apply_button, *cancel_button, *ok_button;
  char** cmds, **cmds_names;
  char *riga[2];

  glade_file = GNOME_TERMINAL_GLADEDIR "/edit_cmd.glade";
  app = gtk_widget_get_toplevel( GTK_WIDGET((*((GSList**) data))->data) );
  cmds = gtk_object_get_data(GTK_OBJECT(app), "cmds_list");  
  cmds_names = gtk_object_get_data(GTK_OBJECT(app), "cmds_names");

  gui = glade_xml_new(glade_file, "edit_cmd");
  if (!gui) {
    g_warning ("Error loading `%s'", glade_file);
    return;
  }

  glade_xml_signal_autoconnect(gui);
  win = glade_xml_get_widget(gui, "edit_cmd");
  gtk_widget_set_usize(win, 500, 400);
  gtk_window_set_modal(GTK_WINDOW(win), TRUE);
  txt_name = glade_xml_get_widget(gui, "txt_name");
  
  add_button = glade_xml_get_widget(gui, "add_button");
  remove_button = glade_xml_get_widget(gui, "remove_button");
  del_button = glade_xml_get_widget(gui, "del_button");
  chg_button = glade_xml_get_widget(gui, "chg_button");
  ok_button = glade_xml_get_widget(gui, "ok_button");
  cancel_button = glade_xml_get_widget(gui, "cancel_button");
  apply_button = glade_xml_get_widget(gui, "apply_button");

  txt_command = glade_xml_get_widget(gui, "txt_command");
  lista_cmd = glade_xml_get_widget(gui, "lista_cmd");
 
  x = 0;
  while (cmds[x])
    {  
      riga[0] = cmds_names[x];
      riga[1] = cmds[x]; 
      gtk_clist_append(GTK_CLIST(lista_cmd), riga);
      x++;
    }
  gtk_clist_set_selection_mode(GTK_CLIST(lista_cmd), GTK_SELECTION_SINGLE);

  gtk_signal_connect (GTK_OBJECT(add_button), "clicked", 
	 	      (GtkSignalFunc) on_add_button_clicked, NULL);
  gtk_signal_connect (GTK_OBJECT(remove_button), "clicked",
	 	      (GtkSignalFunc)on_remove_button_clicked, NULL);
  gtk_signal_connect (GTK_OBJECT(del_button), "clicked",
  		      (GtkSignalFunc) on_del_button_clicked, (gpointer)lista_cmd);
  gtk_signal_connect (GTK_OBJECT(chg_button), "clicked",
		      (GtkSignalFunc) on_chg_button_clicked, (gpointer)lista_cmd);
  gtk_signal_connect (GTK_OBJECT(ok_button), "clicked",
		      (GtkSignalFunc) on_ok_button_clicked, app);
  gtk_signal_connect (GTK_OBJECT(apply_button), "clicked",
		      (GtkSignalFunc) on_apply_button_clicked, app);
  gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked",
		     (GtkSignalFunc) on_cancel_button_clicked, NULL);

  gtk_object_set_data(GTK_OBJECT(add_button),"txt_command", (gpointer) txt_command);
  gtk_object_set_data(GTK_OBJECT(add_button),"txt_name", (gpointer) txt_name);
  gtk_object_set_data(GTK_OBJECT(add_button),"lista_cmd", (gpointer) lista_cmd);
  gtk_object_set_data(GTK_OBJECT(remove_button), "lista_cmd", (gpointer) lista_cmd);  
  gtk_object_set_data(GTK_OBJECT(del_button), "txt_command", (gpointer) txt_command);
  gtk_object_set_data(GTK_OBJECT(del_button), "txt_name", (gpointer) txt_name);
  gtk_object_set_data(GTK_OBJECT(chg_button), "txt_command", (gpointer) txt_command);
  gtk_object_set_data(GTK_OBJECT(chg_button), "txt_name", (gpointer) txt_name);
  gtk_object_set_data(GTK_OBJECT(ok_button), "lista_cmd", (gpointer) lista_cmd);
  gtk_object_set_data(GTK_OBJECT(apply_button), "lista_cmd", (gpointer) lista_cmd);
  current_row = malloc(sizeof(int));
  gtk_object_set_data(GTK_OBJECT(lista_cmd), "current_row", (gpointer) current_row);
  
  
  gtk_object_unref(GTK_OBJECT(gui));
}


void remove_term(GtkWidget* term)
{
  /* remove a certain term from the notebook */
  GSList **ptl, *tmp; 
  GtkWidget *nb, *app, *te, *curterm, *curchild, *label;
  int wt, n, *new_out, *state;
  char *ttit, *nt, lbltxt[300];
  struct terminal_config* cfg;

  curterm = term;
  app = gtk_widget_get_toplevel(term);
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  if (g_slist_length(*ptl) == 1)
    {
      close_app(app);
      return;
    }
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  tmp = *ptl;
  wt = -1;
  n = 0;
  while (tmp)
    {
      te = GTK_WIDGET(tmp->data);
      if (te == term)
	{
	  wt = n;
	  curterm = te;
	}
      if (n > wt && wt != -1)
	{
	  /* update term numbers */
	  cfg = gtk_object_get_data(GTK_OBJECT(te), "config");
	  if (cfg->titled_tabs)
	    {
	      nt = (char *) gtk_object_get_data(GTK_OBJECT(te), "termtitle");
	    }
	  else
	    nt = (char *) gtk_object_get_data(GTK_OBJECT(te), "mtermname");
	  curchild = gtk_notebook_get_nth_page(GTK_NOTEBOOK(nb), n);
 	  sprintf(lbltxt, "%d-%s", n-1, nt);
	  if (cfg->titled_tabs)
	    trunc_string(lbltxt, cfg->maxch);
	  label = gtk_notebook_get_tab_label(GTK_NOTEBOOK(nb),curchild);
	  gtk_label_set_text(GTK_LABEL(label),lbltxt);
	  label = gtk_notebook_get_menu_label(GTK_NOTEBOOK(nb), curchild);
    	  gtk_label_set_text(GTK_LABEL(label), lbltxt);
	}
      n++;
      tmp = tmp->next;
    }
  if (wt == -1)
    {
      return;
    }
  te = curterm;
  cfg = gtk_object_get_data(GTK_OBJECT(te), "config");
 
  terminal_config_free(cfg);
 
 *ptl = g_slist_remove(*ptl, (gpointer) te);
  
  set_hints(GTK_WIDGET((*ptl)->data));

  /* Free bytes allocated for termname */
  nt = (char *) gtk_object_get_data(GTK_OBJECT(te), "mtermname");
  state = gtk_object_get_data(GTK_OBJECT(te), "term_state");
  new_out = gtk_object_get_data(GTK_OBJECT(te), "new_out");
  ttit = gtk_object_get_data(GTK_OBJECT(te), "termtitle");
  g_free(new_out);
  g_free(state);
  g_free(ttit);
  free(nt);

  gtk_notebook_remove_page (GTK_NOTEBOOK(nb), wt);

}
#if 0
void ok_remove_book(GtkNotebook* notebook)
{
  gint page, i;
  GtkWidget *app, *label;
  GtkWidget *term, *curterm, *curchild;
  GSList *tmp, **p_term_list, *start;
  char lbltxt[32];
  char* nt;
  struct terminal_config *cfg;
  int *new_out, *state;
  app = gtk_widget_get_toplevel(GTK_WIDGET(notebook));
    
  p_term_list = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  /* NOTE: 
     if there is only one terminal to close this means that we need to close the windows
   */  
  if (g_slist_length(*p_term_list) == 1)
    {
      close_app(app);
      return;
    }

  page = gtk_notebook_get_current_page(notebook);
  start = *p_term_list;
  tmp = *p_term_list;

  i = 0;
  term = NULL;
  curterm = NULL;
  while (tmp)
    {
      term = GTK_WIDGET(tmp->data);
      if (i == page)
	{
	  curterm = term;
	}
      if (i > page)
	{
	  /* update term numbers */
	  nt = (char *) gtk_object_get_data(GTK_OBJECT(term), "mtermname");
	  curchild = gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), i);
	  sprintf(lbltxt, "%d-%s", i-1, nt);
	  label = gtk_notebook_get_tab_label(GTK_NOTEBOOK(notebook),curchild);
	  gtk_label_set_text(GTK_LABEL(label),lbltxt);
	}
      i++;
      tmp = tmp->next;
    }

  term = curterm;
  
  /* Free bytes allocated for termname */
  nt = (char *) gtk_object_get_data(GTK_OBJECT(term), "mtermname");
  state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
  new_out = gtk_object_get_data(GTK_OBJECT(term), "new_out");
  g_free(new_out);
  g_free(state);
  free(nt);

  if (!term)
    printf("che ..zzo sta succedendo?!?\n");

  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  terminal_config_free(cfg);
 


  *p_term_list = g_slist_remove(start, (gpointer) term);

  gtk_notebook_remove_page (notebook, page);
  /* Need to refresh the widget -- 
     This forces the widget to redraw itself. */
  gtk_widget_draw(GTK_WIDGET(notebook), NULL);
 }
#endif

void cb_conf_win(gint reply, gpointer data)
{
  GtkWidget* term;
  GtkWidget *app;
  GSList **p_term_list;
  app = gtk_widget_get_toplevel(GTK_WIDGET(data));
    
  p_term_list = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  if (reply)
    {
      gtk_widget_grab_focus(GTK_WIDGET(data));
      return;
    }
  else
    {
      remove_term(GTK_WIDGET(data));
      term = GTK_WIDGET(current_term(p_term_list)); 
      gtk_widget_grab_focus(GTK_WIDGET(term));
    }
}

/* Remove a term from the notebook */
void remove_book( GtkButton   *button,
                  gpointer *data )
{
    GtkWidget *app, *ct;
    GtkWidget *conf_win;
    GtkNotebook* notebook;
    GSList** ptl;

    notebook = GTK_NOTEBOOK(data);
    app = gtk_widget_get_toplevel(GTK_WIDGET(notebook));
    
    ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
    if (g_slist_length(*ptl)==1)
      {
       	close_app(app);
	return;
      }
    ct = GTK_WIDGET(current_term(ptl));
    /* NOTE: Only if the button is calling this function then ask for a confirmation */
    if (button) 
     conf_win = gnome_ok_cancel_dialog_modal_parented
       ("Remove current term?", cb_conf_win, 
	(gpointer) ct, GTK_WINDOW(app));
    else
      remove_term(ct);

}
 
void new_shell(GSList** p_term_list, guint action)
{
  /* WARNING;
     This prototype works but it's different from one in the gtk docs...bah! */
  struct terminal_config *cfg;
  ZvtTerm* term;
  GSList* last;
  last = g_slist_last(*p_term_list);
  term = ZVT_TERM(last->data);
   
  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  new_term_in_window(NULL , cfg, NULL, 1, p_term_list, "Shell");
}
void new_root(GSList** p_term_list, guint action)
{
  struct terminal_config *cfg;
  ZvtTerm* term;
  GSList* last;
  char* cmd[3] = {"su", "-", NULL};

  last = g_slist_last(*p_term_list);
  term = ZVT_TERM(last->data);
   
  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");

  if (!cfg->invoke_as_login_shell)
    cmd[1]=NULL;

  new_term_in_window(cmd , cfg, NULL, 1, p_term_list, "Root");
}

#define MC_WRAPAROUND
/* NOTE:
   if one starts mc and changes page going back then to mc, mouse doesn't work,
   so defining MC_WRAPAOUND some lines of codes solve this problem */
void new_mc(GSList** p_term_list, guint action)
{
  struct terminal_config *cfg;
  ZvtTerm* term;
#ifdef MC_WRAPAROUND
  GtkWidget* app, *nb;
  int cp, lp;
#endif
  GSList* last;
  char* cmd[3] = {"mc", "-x", NULL};
  last = g_slist_last(*p_term_list);
  term = ZVT_TERM(last->data);
   
  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  
  new_term_in_window(cmd , cfg, NULL, 1, p_term_list, "mc");
  
#ifdef MC_WRAPAROUND
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  nb = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(app),"notebook"));
 
  cp = gtk_notebook_get_current_page(GTK_NOTEBOOK(nb));
  lp = g_slist_length(*p_term_list) - 1;
  
  if (cp == 0)
   gtk_notebook_set_page(GTK_NOTEBOOK(nb), lp);
  else 
   gtk_notebook_prev_page(GTK_NOTEBOOK(nb));

  term = ZVT_TERM(current_term(p_term_list));
 
  gtk_notebook_set_page(GTK_NOTEBOOK(nb), cp);

  /*zvt_term_feed(term, buf, strlen(buf));*/
#endif  
}

/* change this if you change the button bar menu */
GtkItemFactoryEntry menu_items[] = {
    { "/    New Tab    ",            NULL,  NULL, 0, "<Branch>" },
    { "/    New Tab    /New Shell",    "", new_shell, 0, NULL },
    { "/    New Tab    /Root Shell",    "", new_root, 0, NULL },
    { "/    New Tab    /mc",    "", new_mc, 0, NULL },
    { "/    New Tab    /Separator", NULL, NULL, 0, "<Separator>" }
};

void new_shell_with_command_bb(GSList** ptl, gint action)
{
  GtkWidget* app;
  GtkWidget* term;
  char **cmds, **cmds_names, *buf;
  /* the command string is not longer than 128 bytes so this value(256) is enough! */
  char* cmd[256], *item;
  struct terminal_config* cfg;
  int i;

  term = GTK_WIDGET((*ptl)->data);
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");

  app = gtk_widget_get_toplevel(term);
  cmds = gtk_object_get_data(GTK_OBJECT(app), "cmds_list");
  cmds_names = gtk_object_get_data(GTK_OBJECT(app), "cmds_names");

  buf = malloc((strlen(cmds[action])+1)*sizeof(char));
  strcpy(buf, cmds[action]);

  cmd[0] =  strtok(buf, " ");
  i = 1;
  while ((cmd[i] = strtok(NULL, " ")))
    i++;

  if (!parse_path(cmds_names[action], &item))
    item = g_strdup(cmds_names[action]);
  new_term_in_window(cmd, cfg, NULL, 1, ptl, item);
  g_free(item);
  free(buf);
}

void get_main_menu( GtkWidget  *window,
		    GtkWidget **menubar, GSList** p_term_list )

{
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  GtkItemFactoryEntry* cm;

  gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
  
  accel_group = gtk_accel_group_new ();

  cm = malloc(sizeof(GtkItemFactoryEntry)*(nmenu_items+1));
  gtk_object_set_data(GTK_OBJECT(window), "buttonbar_menu", cm);
  memcpy(cm, menu_items, sizeof(GtkItemFactoryEntry)*DEFAULT_BUTTONBAR_ITEMS);
  cm[DEFAULT_BUTTONBAR_ITEMS].path = NULL;
  
  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
				       accel_group);
  gtk_item_factory_create_items (item_factory, nmenu_items, cm, p_term_list);
  
  /* Attach the new accelerator group to the window. */
  gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);
  
  if (menubar)
    /* Finally, return the actual menu bar created by the item factory. */ 
    *menubar = gtk_item_factory_get_widget (item_factory, "<main>");
}


void rebuild_buttonbar_menu( GtkWidget  *window)
{
  GtkItemFactory *item_factory;
  GtkItemFactoryEntry* cm;
  GtkWidget* mbw, *butbar, *term;
  GSList** p_term_list;
  char** cmds, **cmds_names;
  int x, i;  
  gint nmenu_items;
  char str[64];
  butbar = gtk_object_get_data(GTK_OBJECT(window), "buttonbar");
  if (butbar == NULL)
    return;
  cmds = gtk_object_get_data(GTK_OBJECT(window), "cmds_list");
  cmds_names = gtk_object_get_data(GTK_OBJECT(window), "cmds_names");
  p_term_list = gtk_object_get_data(GTK_OBJECT(window), "ptermlist");
  /*item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
  				       accel_group);
  */
  /* This function generates the menu items. Pass the item factory,
     the number of items in the array, the array itself, and any
     callback data for the the menu items. */
  x = 0;
  while(cmds[x])
    x++;
  /* 4 are the default items */
  nmenu_items = x + DEFAULT_BUTTONBAR_ITEMS;
  cm = gtk_object_get_data(GTK_OBJECT(window), "buttonbar_menu");
  mbw = gtk_object_get_data(GTK_OBJECT(window), "butmenu_widget");
  item_factory = gtk_item_factory_from_widget(mbw);

  x = 0;
  while(cm[x].path)
    x++;
  gtk_item_factory_delete_entries(item_factory, x, cm);
  
  if (cm)
    {
      x = DEFAULT_BUTTONBAR_ITEMS;

      while(cm[x].path)
	{
	  free(cm[x].path);
	  x++;
	}
      free(cm);
    }
  
  cm = malloc(sizeof(GtkItemFactoryEntry)*(nmenu_items+1));
  gtk_object_set_data(GTK_OBJECT(window), "buttonbar_menu", cm);

  memcpy(cm, menu_items, sizeof(GtkItemFactoryEntry)*DEFAULT_BUTTONBAR_ITEMS);
 
  /* and now we build the custom part */
  x = 0;
  while (cmds[x])
    {
      i = x + DEFAULT_BUTTONBAR_ITEMS;
      strcpy(str,"/    New Tab    /");
      strcat(str,cmds_names[x]);
      cm[i].path = malloc((strlen(str)+1)*sizeof(char));
      strcpy(cm[i].path, str);
      cm[i].accelerator = NULL;
      cm[i].callback = new_shell_with_command_bb;
      cm[i].callback_action = x;
      cm[i].item_type = NULL;
      x++;
    }

  cm[x+DEFAULT_BUTTONBAR_ITEMS].path = NULL; 
  
  gtk_item_factory_create_items (item_factory, nmenu_items, cm, p_term_list);

}

GtkWidget* add_dir_tree(GtkWidget* widget, GtkWidget* app);

#define MAX_OPEN_TERMS 500

#define PADDING 2
void term_alloc_size(ZvtTerm* term, GtkAllocation* alloc, gpointer data)
{
  int tw, th, gw, gh;
  /* when resizing fieald grid_width and grid_height aren't
     set so this is an hack to do it 
     and to resolve geometry problems */

  tw = alloc->width - (2 * GTK_WIDGET(term)->style->klass->xthickness) - PADDING;
  th = alloc->height - (2 * GTK_WIDGET(term)->style->klass->ythickness);

  gw = MAX(tw / term->charwidth, 1);
  gh = MAX(th / term->charheight, 1);
  /*
  term->grid_width = term->vx->vt.width;
  term->grid_height= term->vx->vt.height ; */
}

void
new_term_in_window(char** cmd, struct terminal_config *cfg_in, const gchar *geometry, int termid, GSList** p_term_list, char* nome_term)
{
  int nopg, i, cmdindex, scrollbacklines, login_shell;
  char txt[128], tmp1[256];
  char buffer[60];
  GtkWidget *lblmenu, *frame, *tt, *app, *term, *hbox, *scrollbar, *label;
  GtkNotebook *notebook;
  preferences_t* prefs;
  struct terminal_config *cfg;
  int width, height;
  int *pts;
  char *tetitle, *shell, *name, *noterm;
#ifdef SHADING
  GdkImlibColorModifier mod, rmod, gmod, bmod;
#endif
  login_shell = 0;
  cmdindex = 0;
  scrollbacklines = 50;
  /* set up terminal environment */
  env = environ;
  
  cfg = terminal_config_dup (cfg_in); 
  cfg->terminal_id = termid; 
  
  if (!env_copy){
    char **p;

    for (p = env; *p; p++)
      ;
    i = p - env;
    env_copy = (char **) g_malloc (sizeof (char *) * (i + 1 + EXTRA));
    for (i = 0, p = env; *p; p++){
      if ((strncmp (*p, "COLUMNS=", 8) == 0)
	  || (strncmp (*p, "LINES=", 6) == 0)
	  || (strncmp(*p, "WINDOWID=", 9) == 0)
	  || (strncmp (*p, "TERM=", 5) == 0)
	  || (strncmp (*p, "GNOME_DESKTOP_ICON=", 19) == 0)) {
	/* nothing: do not copy those */
      } else
	env_copy [i++] = *p;
    }
    term_pos = i++;
    env_copy [term_pos] = "";
    env_copy [i++] = "COLORTERM=gnome-terminal";
    winid_pos = i++;
    env_copy [winid_pos] = "TEST";
    env_copy [i] = NULL;
  }
  
  /* create hbox */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_set_spacing (GTK_BOX (hbox), 2);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 0);
  gtk_widget_show (hbox);
  
  width = ZVT_TERM((*p_term_list)->data)->vx->vt.width;/*grid_width;*/
  height = ZVT_TERM((*p_term_list)->data)->vx->vt.height;/*grid_height;*/
  /* create terminal */
  term = GTK_WIDGET(ZVT_TERM(zvt_term_new_with_size(width, height)));
  /*term = GTK_WIDGET(ZVT_TERM(zvt_term_new()));*/

  gnome_term_set_font (ZVT_TERM(term), cfg->font, cfg->use_bold);
  gtk_signal_connect(GTK_OBJECT(term), "new_output", new_output, NULL);
  pts = malloc(sizeof(int));
  *pts = UNDEFINED;
  gtk_object_set_data(GTK_OBJECT(term), "term_state", pts);
  pts = malloc(sizeof(int));
  *pts = FALSE;
  gtk_object_set_data(GTK_OBJECT(term), "new_out", pts);

  app = gtk_widget_get_toplevel(GTK_WIDGET((*p_term_list)->data));
  notebook = GTK_NOTEBOOK(gtk_object_get_data(GTK_OBJECT(app), "notebook"));
  
  tt = GTK_WIDGET((*p_term_list)->data);
  prefs = gtk_object_get_data(GTK_OBJECT(tt), "prefs");
  gtk_object_set_data(GTK_OBJECT(term), "prefs", prefs);

  *p_term_list = g_slist_append(*p_term_list, (gpointer) term); 

  zvt_term_set_scrollback (ZVT_TERM(term), cfg->scrollback);

  zvt_term_set_wordclass  (ZVT_TERM(term), (guchar *)cfg->wordclass);
  
  zvt_term_set_bell  (ZVT_TERM(term), !cfg->bell);
  zvt_term_set_blink (ZVT_TERM(term), cfg->blink);
  zvt_term_set_scroll_on_keystroke (ZVT_TERM(term), cfg->scroll_key);
  zvt_term_set_scroll_on_output (ZVT_TERM(term), cfg->scroll_out);
  zvt_term_set_del_key_swap (ZVT_TERM(term), cfg->swap_keys);
#ifdef HAVE_ZVT_DEL_IS_DEL
  zvt_term_set_del_is_del (ZVT_TERM(term), cfg->del_is_del);
#endif
  gtk_signal_connect (GTK_OBJECT (term), "child_died",
		      GTK_SIGNAL_FUNC (terminal_kill), term);

  gtk_signal_connect (GTK_OBJECT (term), "title_changed",
		      GTK_SIGNAL_FUNC(title_changed), term);

  /*gtk_signal_connect (GTK_OBJECT (app), "delete_event",
  		      GTK_SIGNAL_FUNC (close_app), term);
   */
  gtk_signal_connect (GTK_OBJECT (term), "button_press_event",
		      GTK_SIGNAL_FUNC (button_press), term);
/*
  gtk_signal_connect_after (GTK_OBJECT (term), "realize",
			    GTK_SIGNAL_FUNC (cb_term_realize), term);
*/ 
#ifdef ZVT_TERM_MATCH_SUPPORT
  zvt_term_match_add( ZVT_TERM(term), "(((news|telnet|nttp|file|http|ftp|https)://)|(www|ftp))[-A-Za-z0-9\\.]+(:[0-9]*)?", VTATTR_UNDERLINE, "host only url");
  zvt_term_match_add( ZVT_TERM(term), "(((news|telnet|nttp|file|http|ftp|https)://)|(www|ftp))[-A-Za-z0-9\\.]+(:[0-9]*)?/[-A-Za-z0-9_\\$\\.\\+\\!\\*\\(\\),;:@&=\\?/~\\#\\%]*[^]'\\.}>\\) ,\\\"]", VTATTR_UNDERLINE, "full url");
#endif

 
  gtk_object_set_data(GTK_OBJECT(term), "env_copy", env_copy);
  gtk_widget_grab_focus(GTK_WIDGET(term));

  gtk_widget_show (term);

  configure_term_dnd (ZVT_TERM(term));
#ifdef SHADING
  ZVT_TERM(term)->tintback = cfg->tintback;
  mod.contrast = mod.gamma = 256;
  mod.brightness = cfg->shading;
  rmod.contrast = rmod.gamma = 256;
  gmod.contrast = gmod.gamma = 256;
  bmod.contrast = bmod.gamma = 256;
  rmod.brightness = cfg->rtint;
  gmod.brightness = cfg->gtint;
  bmod.brightness = cfg->btint;
  zvt_term_set_image_mode(ZVT_TERM(term), cfg->image_mode);
	
  zvt_term_set_shading(ZVT_TERM(term), mod, rmod, gmod, bmod);

#endif

  if (zvt_pixmap_support && cfg->background_pixmap) {
    int flags;
#ifdef ZVT_BACKGROUND_SCROLL
    flags = cfg->shaded?ZVT_BACKGROUND_SHADED:0;
    flags |= cfg->scroll_background?ZVT_BACKGROUND_SCROLL:0;
#else
    flags = cfg->shaded;
#endif
    zvt_term_set_background (ZVT_TERM(term),
			     cfg->pixmap_file,
			     cfg->transparent, flags);
  } else if (zvt_pixmap_support && cfg->transparent)
    zvt_term_set_background (ZVT_TERM(term), NULL,
			     cfg->transparent, cfg->shaded);
  else
    zvt_term_set_background (ZVT_TERM(term), NULL, 0, 0);

  get_shell_name (&shell, &name, cfg->invoke_as_login_shell);

  scrollbar = gtk_vscrollbar_new (GTK_ADJUSTMENT (ZVT_TERM(term)->adjustment));
  gtk_object_set_data (GTK_OBJECT (term), "scrollbar", scrollbar);
  gtk_object_set_data (GTK_OBJECT (term), "config", cfg);
  gtk_object_set_data (GTK_OBJECT (term), "geometry", g_strdup(geometry));
  
  GTK_WIDGET_UNSET_FLAGS (scrollbar, GTK_CAN_FOCUS);

#ifdef GT_DIR_TREE
  /* <<<<< BETA CODE >>>>> : directory tree */	
  /*add_dir_tree(hbox, app);*/
#endif
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  
  if (cfg->scrollbar_position == SCROLLBAR_LEFT)
    {
      gtk_box_pack_start (GTK_BOX (hbox), scrollbar, 0, 1, 0);
    }
  else
    {
      gtk_box_pack_end (GTK_BOX (hbox), scrollbar, FALSE, TRUE, 0);
    }

  gtk_box_pack_start (GTK_BOX (hbox), term, 1, 1, 0);

  gtk_container_add(GTK_CONTAINER(frame), hbox);
  gtk_widget_show(frame);

  if (cfg->scrollbar_position != SCROLLBAR_HIDDEN)
    gtk_widget_show (scrollbar);

  /* scrollbar */
  
  nopg = g_slist_length(*p_term_list);
  sprintf(txt, "%d-%s", nopg-1, nome_term); 
  label = gtk_label_new (txt);
 
  lblmenu = gtk_label_new(txt);
  noterm = malloc(sizeof(char)*33);/* max 32 chars for termname!!!*/
  
  strcpy(noterm, nome_term);
  gtk_object_set_data(GTK_OBJECT(term), "mtermname", noterm);
  tetitle = malloc(sizeof(char)*260);
  strcpy(tetitle, noterm);
  sprintf(tmp1, "%s - [ %d-%s ]", cfg->window_title, nopg, noterm); 
  gtk_window_set_title(GTK_WINDOW(app), tmp1);

  gtk_object_set_data(GTK_OBJECT(term), "termtitle", tetitle);
  
  /* hbox -> frame now the hbox is sourrounded by a frame! */
  gtk_notebook_append_page_menu (GTK_NOTEBOOK (notebook), frame, label, lblmenu);
  
  nopg = g_slist_length(*p_term_list);
  gtk_notebook_set_page(GTK_NOTEBOOK(notebook), nopg-1);

  set_color_scheme (ZVT_TERM(term), cfg);

  XSync(GDK_DISPLAY(), False);
  gtk_signal_connect(GTK_OBJECT(term), "size-allocate",
  		     term_alloc_size, term);
  errno = 0;
  /* Create a bunch of buttons */
  /* fork the shell/program */
  switch (zvt_term_forkpty(ZVT_TERM (term), ZVT_TERM_DO_UTMP_LOG |  ZVT_TERM_DO_WTMP_LOG))
    {
    case -1:
      show_pty_error_dialog(errno);
      g_free (shell);
      g_free (name);
      printf("allora qui?\n");
      /* should we exit maybe? */
      return ;
      
    case 0: {
	      int open_max = sysconf (_SC_OPEN_MAX);
	     
	      for (i = 3; i < open_max; i++)
		fcntl (i, F_SETFD, 1);
	      
    	      /* set delayed env variables */
	      /* 22/02/2002 NOTE
		 maybe WINDOWID should be the same for all terminals 
		 and this causes the accent problem some people complained of */
	      g_snprintf (buffer, sizeof (buffer),
		     	  "WINDOWID=%d",
			  (int) GDK_WINDOW_XWINDOW(GTK_WIDGET(term)->window));
	      
    	      env_copy [winid_pos] = buffer;
	      
    	      if (cfg->termname && cfg->termname [0])
		env_copy [term_pos] = cfg->termname;
	      else
		env_copy [term_pos] = "TERM=xterm";

	      if (cmd){
		environ = env_copy;
		execvp (cmd[0], cmd);
	      } else
		execle (shell, name, NULL, env_copy);
		  perror ("Could not exec\n");
		  _exit (127);
		  
	    }
	  
    default:
	  break;
    }
   g_free (shell);
   g_free (name);
}
#undef GT_DIR_TREE

#ifdef GT_DIR_TREE
#include <dirent.h>
#include <sys/types.h>


void gtk_myctree_class_init (GtkCTreeClass *klass);

static void
gtk_myctree_init (GtkCTree *ctree)
{
  
  GtkCList *clist;
#if 0
  GTK_CLIST_SET_FLAG (ctree, CLIST_DRAW_DRAG_RECT);
  GTK_CLIST_SET_FLAG (ctree, CLIST_DRAW_DRAG_LINE);

  clist = GTK_CLIST (ctree);

  ctree->tree_indent    = 20;
  ctree->tree_spacing   = 5;
  ctree->tree_column    = 0;
  ctree->line_style     = GTK_CTREE_LINES_SOLID;
  ctree->expander_style = GTK_CTREE_EXPANDER_SQUARE;
  ctree->drag_compare   = NULL;
  ctree->show_stub      = TRUE;

  clist->button_actions[0] |= GTK_BUTTON_EXPANDS;
#endif
  clist = GTK_CLIST(ctree);
  clist->button_actions[0] |= GTK_BUTTON_EXPANDS;
  clist->button_actions[1] = GTK_BUTTON_IGNORED;
  clist->button_actions[2] = GTK_BUTTON_SELECTS;
  /*  clist->button_actions[3] = GTK_BUTTON_SELECTS;
      clist->button_actions[4] = GTK_BUTTON_SELECTS;*/
}


GtkType gtk_myctree_get_type (void)
{
  static GtkType myctree_type = 0;

  if (!myctree_type)
    {
      static const GtkTypeInfo myctree_info =
      {
        "GtkMyCTree",
        sizeof (GtkCTree),
        sizeof (GtkCTreeClass),
        (GtkClassInitFunc) gtk_myctree_class_init,
        (GtkObjectInitFunc) gtk_myctree_init,
        /* reserved_1 */ NULL,
        /* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      myctree_type = gtk_type_unique (GTK_TYPE_CTREE, &myctree_info);
    }

  return myctree_type;
}

static GtkCListClass *parent_class = NULL;
/*static GtkContainerClass *container_class = NULL;*/

/*static guint myctree_signals[LAST_SIGNAL] = {0};*/*/

static gboolean
ctree_is_hot_spot (GtkCTree     *ctree,
                   GtkCTreeNode *node,
                   gint          row,
                   gint          x,
                   gint          y)
{
  GtkCTreeRow *tree_row;
  GtkCList *clist;
  GtkCellPixText *cell;
  gint xl;
  gint yu;

  g_return_val_if_fail (ctree != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_CTREE (ctree), FALSE);
  g_return_val_if_fail (node != NULL, FALSE);

  clist = GTK_CLIST (ctree);

  if (!clist->column[ctree->tree_column].visible ||
      ctree->expander_style == GTK_CTREE_EXPANDER_NONE)
    return FALSE;


  tree_row = GTK_CTREE_ROW (node);

  cell = GTK_CELL_PIXTEXT(tree_row->row.cell[ctree->tree_column]);

  yu = (ROW_TOP_YPIXEL (clist, row) + (clist->row_height - PM_SIZE) / 2 -
        (clist->row_height - 1) % 2);

  if (clist->column[ctree->tree_column].justification == GTK_JUSTIFY_RIGHT)
    xl = (clist->column[ctree->tree_column].area.x +
          clist->column[ctree->tree_column].area.width - 1 + clist->hoffset -
          (tree_row->level - 1) * ctree->tree_indent - PM_SIZE -
          (ctree->line_style == GTK_CTREE_LINES_TABBED) * 3);
  else
    xl = (clist->column[ctree->tree_column].area.x + clist->hoffset +
          (tree_row->level - 1) * ctree->tree_indent +
          (ctree->line_style == GTK_CTREE_LINES_TABBED) * 3);

  return (x >= xl && x <= xl + PM_SIZE && y >= yu && y <= yu + PM_SIZE);
}
void cb_select_row(GtkCTree* ctree, GtkCTreeNode* node, gint column,  gpointer app);

static gint
gtk_myctree_button_press (GtkWidget      *widget,
                        GdkEventButton *event)
{
  GtkCTree *ctree;
  GtkCList *clist;
  gint button_actions;
  GtkWidget* app;
  g_return_val_if_fail (widget != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_CTREE (widget), FALSE);
  g_return_val_if_fail (event != NULL, FALSE);

  ctree = GTK_CTREE (widget);
  clist = GTK_CLIST (widget);

  button_actions = clist->button_actions[event->button - 1];

  
  if (button_actions == GTK_BUTTON_IGNORED)
    return FALSE;

  if (event->window == clist->clist_window)
    {
      GtkCTreeNode *work;
      gint x;
      gint y;

      gint row;
      gint column;

      x = event->x;
      y = event->y;

      if (!gtk_clist_get_selection_info (clist, x, y, &row, &column))
        return FALSE;

      printf("event->button: %d\n", event->button);
      work = GTK_CTREE_NODE (g_list_nth (clist->row_list, row));
      if (event->type == GDK_BUTTON_PRESS && event->button == 3)
	{
	  app = gtk_widget_get_toplevel(widget);
	  cb_select_row(ctree, work, 0, app);	  

	  printf("beccato!\n");
	  return GTK_WIDGET_CLASS (parent_class)->button_press_event (widget, event);

	}

      if (button_actions & GTK_BUTTON_EXPANDS &&
          (GTK_CTREE_ROW (work)->children && !GTK_CTREE_ROW (work)->is_leaf  &&
           (event->type == GDK_2BUTTON_PRESS  ||
	    ctree_is_hot_spot (ctree, work, row, x, y))))
        {
	     if (GTK_CTREE_ROW (work)->expanded)
	       gtk_ctree_collapse (ctree, work);
	     else
	       gtk_ctree_expand (ctree, work);
          return FALSE;
        }
    }
  return GTK_WIDGET_CLASS (parent_class)->button_press_event (widget, event);
}

static void
gtk_myctree_class_init (GtkCTreeClass *klass)
{
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkCListClass *clist_class;
  
  object_class = (GtkObjectClass *) klass;
  widget_class = (GtkWidgetClass *) klass;
  clist_class = (GtkCListClass *) klass;

  parent_class = gtk_type_class (GTK_TYPE_CTREE);

  widget_class->button_press_event = gtk_myctree_button_press;
}

GtkWidget *
gtk_myctree_new_with_titles (gint         columns,
                           gint         tree_column,
                           gchar       *titles[])
{
  GtkWidget *widget;

  g_return_val_if_fail (columns > 0, NULL);
  g_return_val_if_fail (tree_column >= 0 && tree_column < columns, NULL);

  widget = gtk_type_new (GTK_TYPE_MYCTREE);
  gtk_ctree_construct (GTK_CTREE (widget), columns, tree_column, titles);

  return widget;
}

GtkWidget *
gtk_myctree_new (gint columns,
               gint tree_column)
{
  return gtk_myctree_new_with_titles (columns, tree_column, NULL);
}


#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
/* PRE-ALPHA CODE: building directory tree */
int is_a_dir(char* p, char* sp)
{
  int ret;
  struct stat sbuf;
  
  if (!strcmp(sp, ".") || !strcmp(sp, ".."))
    return 1;
  
  ret = stat(p, &sbuf);
  if (S_ISDIR(sbuf.st_mode))
    {
      return 1;
    }
  else if (S_ISREG(sbuf.st_mode))
    {
      return 0;
    }
  else
    {
      return 0;
    }
}

void my_ctree_node_get_text(GtkCTree* ctree, GtkCTreeNode* node, int column, char** text)
{
  *text = GTK_CELL_TEXT (GTK_CTREE_ROW (node)->row.cell[column])->text;
}

int there_are_subdirs(char* path)
{
  DIR* dir;
  struct dirent* d;
  int ret = 0;
  dir = opendir(path);
  if (dir==NULL)
    {
      return 0;
    }
  d = readdir(dir);
  if (d)
    ret = 1;
  closedir(dir);
  return ret;
}

void insert_dirs(char* path, GtkCTree* ctree, GtkCTreeNode* node, GnomePixmap* pixmap_open, GnomePixmap* pixmap_close)
{
  struct dirent *pod;  
  DIR* pdir;
  int whis;
  char subdir_path[1024];
  char* cols_text[1];
  GtkCTreeNode* cnode, *sn;
  gboolean is_a_leaf;
  char *text;
  char node_name[32];
  char pnt[] = ".";
  pdir = opendir(path);
  if (pdir == NULL)
    {
      return;
    }

  gtk_clist_freeze(GTK_CLIST(ctree));
  gtk_clist_set_column_auto_resize (GTK_CLIST(ctree), 0, FALSE);
  while ( (pod = readdir(pdir)) )
    {
      strcpy(subdir_path, path);
      strcat(subdir_path, pod->d_name);
      /*cols_text[0] = malloc(sizeof(char)*256);
	strcpy(cols_text[0],pod->d_name);*/
      strcpy(node_name, pod->d_name);     
      cols_text[0] = node_name;
      /*printf("dir_path:%s\n", subdir_path);*/
  
      if ((whis = is_a_dir(subdir_path, pod->d_name)))
      
	{
	  /*if (there_are_subdirs(subdir_path))
	    is_a_leaf = FALSE;
	    else
	    is_a_leaf = TRUE; */
	  if (whis==1)
  	    is_a_leaf=FALSE;
	  else
	    is_a_leaf=TRUE;
	  if (whis == 1)
  	    cnode = gtk_ctree_insert_node(ctree, node, NULL, cols_text, 2, 
  					  pixmap_open->pixmap, pixmap_open->mask, 
  					  pixmap_close->pixmap, pixmap_close->mask,
  					  is_a_leaf, FALSE);
	  else 
	    cnode = gtk_ctree_insert_node(ctree, node, NULL, cols_text, 2, 
					  NULL, NULL, 
					  NULL, NULL,
  					  is_a_leaf, FALSE);
	
	    gtk_ctree_node_get_text(ctree, cnode, 0, &text);
	  
	   
	  if ((is_a_leaf == FALSE) && strcmp(node_name,".") && strcmp(node_name, ".."))
	    {
	      cols_text[0] = pnt;
	
    	      sn =gtk_ctree_insert_node(ctree, cnode, NULL, cols_text, 2, 
					pixmap_open->pixmap,
    					pixmap_open->mask, pixmap_close->pixmap, 
    					pixmap_close->mask, TRUE, FALSE);
	      my_ctree_node_get_text(ctree, sn, 0, &text);
	      
	    }
	    
	}
    }
  gtk_clist_set_column_auto_resize (GTK_CLIST(ctree), 0, TRUE);
  gtk_clist_thaw(GTK_CLIST(ctree));
  closedir(pdir);
}


GnomePixmap* pixmap_open, *pixmap_close;

void build_tree(GtkCTree* ctree)
{ 
 GtkCTreeNode* node;
  char* cols_text[1];
  char text[2];
  int cw;
  /* insert root node */

  strcpy(text, "/"); 
  cols_text[0] = text;
  
  if (pixmap_close == NULL)  
    pixmap_close = pixmap_open = GNOME_PIXMAP(gnome_pixmap_new_from_file_at_size 
					      (GNOME_ICONDIR "/mgt/panel-folder.png",22,22));
  
  node = gtk_ctree_insert_node(ctree, NULL, NULL, cols_text, 2, pixmap_open->pixmap, pixmap_open->mask, pixmap_close->pixmap, pixmap_close->mask, 
			       FALSE, TRUE);
  
  insert_dirs("/", ctree, node, pixmap_open, pixmap_close);

  cw = gtk_clist_optimal_column_width(GTK_CLIST(ctree), 0);
  gtk_clist_set_column_width(GTK_CLIST(ctree),0, cw);

}


void build_path(GtkCTree* ctree, GtkCTreeNode* node, char** path)
{
  GtkCTreeRow* row;
  GtkCTreeNode* n;
  gchar* entry;
  char path_tmp[1024];
  int cc;
  n = node; 
  row = GTK_CTREE_ROW(n);
  my_ctree_node_get_text(ctree, n, 0, &entry);
  printf("entry: %s\n", entry); 
  strcpy(*path, entry);
  strcat(*path, "/");
  cc = 0;
  while ( (n = GTK_CTREE_ROW(n)->parent) )
    {
      my_ctree_node_get_text(ctree, n, 0, &entry);
      strcpy(path_tmp, entry);
      if (strcmp(entry, "/"))
	strcat(path_tmp, "/");
      strcat(path_tmp, *path);
      strcpy(*path, path_tmp);
      cc++;
    }
  /*strcpy(path_tmp, "/");
    strcat(path_tmp, *path);
    strcpy(*path, path_tmp);*/
}

void cb_collapse_branch(GtkCTree* ctree, GtkCTreeNode* node, gpointer data)
{
  char *text, string[256];
  GtkCTreeNode *sn, *n, *to_remove;
  int cw;
  /*GnomePixmap* pixmap_close, *pixmap_open;*/

  sn = GTK_CTREE_ROW(node)->children;
  if (sn==NULL)
    return;
  n = GTK_CTREE_ROW(sn)->sibling;
  if (n==NULL)
    return;
  /*gtk_ctree_remove_node(ctree, p);*/
  my_ctree_node_get_text(ctree, n, 0, &text);
  /*gtk_signal_emit_stop_by_name(GTK_OBJECT(ctree), "tree_select_row");*/
  gtk_clist_freeze(GTK_CLIST(ctree));
  while(n)
    {
      to_remove = n;
      n = GTK_CTREE_ROW(n)->sibling;
      gtk_ctree_remove_node(ctree, to_remove);
    }
  gtk_clist_thaw(GTK_CLIST(ctree));
  return;
#if 0
  printf("QUI!\n");
  text = malloc(256*sizeof(char));
  if (!sn)
    {
      printf("BOH!\n");
      return;
    }
  my_ctree_node_get_text(ctree, sn, 0, &text);
  if (strcmp(text, "."))
    {
      if (GTK_CTREE_NODE_NEXT(sn)==NULL)
	return;
      else
	gtk_ctree_remove_node(ctree, sn);
    }
  while ((sn = GTK_CTREE_NODE_NEXT(sn)))  
    {
      my_ctree_node_get_text(ctree, sn, 0, &text);
      if (strcmp(text, "."))
	gtk_ctree_remove_node(ctree, sn);
    }
  free(text);
#endif
}

void cb_build_branch(GtkCTree* ctree, GtkCTreeNode* node, gpointer data);

char cmd[1024];
/* ============================ >>> selectrow <<< ================================= */
void cb_select_row(GtkCTree* ctree, GtkCTreeNode* node, gint column,  gpointer app)
{
  char *path;
  /* GnomePixmap* pixmap_close, *pixmap_open;*/
  GSList** ptl;
  ZvtTerm* term;
  /* char cmd[1024];*/
  char *text, string[256];
  char *cols_text[1];
  char pnt[] = ".";
  GtkCTreeNode *n, *p, *to_remove, *pp, *ntu;
  /* static gboolean just_regen = FALSE;*/
  path = malloc(sizeof(char)*1024);
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  my_ctree_node_get_text(ctree, node, 0, &text);

  if (!strcmp(text, "."))
    {
      gtk_clist_freeze(GTK_CLIST(ctree));
      printf("QUA!!select: %s\n", text);
      /* rebuild this branch */
      /*gtk_widget_hide(GTK_WIDGET(ctree));*/
      p = GTK_CTREE_ROW(node)->parent;
      /*pp = GTK_CTREE_ROW(p)->parent;*/
      my_ctree_node_get_text(ctree, p, 0, &text);
      strcpy(string, text);
      build_path(ctree, p, &path);
      /*to_remove = GTK_CTREE_ROW(p)->children;*/
      n = GTK_CTREE_NODE_NEXT(node);
      /*gtk_ctree_remove_node(ctree, p);*/
      my_ctree_node_get_text(ctree, n, 0, &text);
      gtk_signal_emit_stop_by_name(GTK_OBJECT(ctree), "tree_select_row");
      while(n)
	{
	  
	  to_remove = n;
 	  n = GTK_CTREE_ROW(n)->sibling;
  	  gtk_ctree_remove_node(ctree, to_remove);
	}
      
      if (pixmap_open == NULL)
	 pixmap_close = pixmap_open = GNOME_PIXMAP(gnome_pixmap_new_from_file_at_size 
			  			  (GNOME_ICONDIR "/mgt/panel-folder.png",22,22));


#if 0
      cols_text[0] = string;
      p = gtk_ctree_insert_node(ctree, pp, NULL, cols_text, 2, 
				pixmap_open->pixmap, pixmap_open->mask, 
				pixmap_close->pixmap, pixmap_close->mask,
				FALSE, TRUE);
	

      insert_dirs(path, ctree, p, pixmap_open, pixmap_close);     
#endif
      gtk_ctree_collapse(ctree, p);
      cb_build_branch(ctree, p, NULL); 
      gtk_ctree_expand(ctree, p);
      /*my_ctree_node_get_text(ctree, ntu, 0, &text);*/
      gtk_clist_thaw(GTK_CLIST(ctree));
      gtk_signal_emit_stop_by_name(GTK_OBJECT(ctree), "tree_select_row");
      gtk_ctree_select(ctree, GTK_CTREE_NODE_NEXT(p));
      /*gtk_widget_show(GTK_WIDGET(ctree));*/
      free(path);
      return;
    }

  term = current_term(ptl);
  if (!strcmp(text, ".."))
    {
      strcpy(cmd, "cd ..\r\n");
    }
  else
    {
      build_path(ctree, node, &path);
      strcpy(cmd, "cd ");
      strcat(cmd, path);
      /* see zvtterm.c: 2477 */
      strcat(cmd, "\r");
    }
  write(term->vx->vt.keyfd, cmd, strlen(cmd));
  gtk_widget_grab_focus(GTK_WIDGET(term));
  free(path);
}
void cb_build_branch(GtkCTree* ctree, GtkCTreeNode* node, gpointer data)
{
  GtkCTreeNode* n, *subnode;
  GtkCTreeRow* row;
  char* path;
  int cw;
  DIR* pdir;
  /*GnomePixmap* pixmap_close, *pixmap_open;*/
  gchar* text;

  my_ctree_node_get_text(ctree, node, 0, &text);
  if (!strcmp(text, ".") || !strcmp(text, ".."))
      return;
  subnode = GTK_CTREE_ROW(node)->children;
  if (subnode == NULL)
    return;
  my_ctree_node_get_text(ctree, subnode, 0, &text);
  printf("next subnode: %p text:%s\n", GTK_CTREE_NODE_NEXT(subnode), text);
  if (strcmp(text,".") || (GTK_CTREE_NODE_NEXT(subnode) != NULL))
    return;
  path = malloc(sizeof(char)*1024);
  build_path(ctree, node, &path);
  printf("build branch path: %s\n", path);
  gtk_ctree_remove_node(ctree, subnode);
  if (pixmap_open == NULL)
    pixmap_close = pixmap_open = GNOME_PIXMAP(gnome_pixmap_new_from_file_at_size 
			  		      (GNOME_ICONDIR "/mgt/panel-folder.png",22,22));
  /*gtk_widget_hide(GTK_WIDGET(ctree));*/
  gtk_clist_freeze(GTK_CLIST(ctree));
  insert_dirs(path, ctree, node, pixmap_open, pixmap_close);
  gtk_clist_thaw(GTK_CLIST(ctree));

  cw = gtk_clist_optimal_column_width(GTK_CLIST(ctree), 0);
  gtk_clist_set_column_width(GTK_CLIST(ctree),0, cw);

  /*gtk_widget_show(GTK_WIDGET(ctree));*/
  free(path);
}
/* <<<PRE-ALPHA CODE >>> dir tree */
GtkWidget* add_dir_tree(GtkWidget* widget, GtkWidget* app)
{
  GtkWidget* scroll_win, *ctree;
  GtkWidget* frame_sw;

  scroll_win = gtk_scrolled_window_new(NULL, NULL);
  
  gtk_scrolled_window_set_policy  (GTK_SCROLLED_WINDOW(scroll_win),
				   GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
  ctree = gtk_myctree_new(1, 0);
  gtk_clist_set_auto_sort(GTK_CLIST(ctree), FALSE);
  gtk_clist_set_selection_mode(GTK_CLIST(ctree), GTK_SELECTION_SINGLE);
  gtk_clist_set_column_auto_resize (GTK_CLIST(ctree), 0, TRUE);
  gtk_clist_set_column_resizeable(GTK_CLIST(ctree), 0, FALSE);
  gtk_ctree_set_expander_style(GTK_CTREE(ctree),GTK_CTREE_EXPANDER_TRIANGLE);
  gtk_ctree_set_show_stub(GTK_CTREE(ctree), FALSE);
  gtk_ctree_set_reorderable(GTK_CTREE(ctree), FALSE);
  gtk_clist_set_use_drag_icons    (GTK_CLIST(ctree), FALSE);
  GTK_WIDGET_UNSET_FLAGS (ctree, GTK_CAN_FOCUS);


  /*gtk_clist_set_column_width(GTK_CLIST(ctree), 0, 200);*/
  build_tree(GTK_CTREE(ctree));
  gtk_widget_show(ctree);
  gtk_signal_connect(GTK_OBJECT(ctree), "tree-expand", cb_build_branch, NULL);
  /*gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll_win), ctree);*/
  gtk_signal_connect(GTK_OBJECT(ctree), "tree-collapse", cb_collapse_branch, NULL);
  /* gtk_signal_connect(GTK_OBJECT(ctree), "tree-select-row", cb_select_row, 
     (gpointer)app);*/
  gtk_widget_set_usize(GTK_WIDGET(ctree), 150, -1);
  gtk_container_add(GTK_CONTAINER(scroll_win), ctree);
  gtk_widget_show(scroll_win);
  frame_sw = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame_sw), GTK_SHADOW_IN);
  gtk_widget_show(GTK_WIDGET(frame_sw));
  gtk_container_add(GTK_CONTAINER(frame_sw), GTK_WIDGET(scroll_win));
  gtk_widget_set_usize(frame_sw, 150, 0);
  gtk_paned_pack1 (GTK_PANED (widget), GTK_WIDGET (frame_sw), TRUE, TRUE);
  /*gtk_widget_set_usize(GTK_WIDGET(scroll_win), 100, -1);*/
  return frame_sw;
}
#endif

void change_title(GtkWidget* widget, gpointer data);
void button_prev_page(GtkWidget* w);
void button_next_page(GtkWidget* w);

extern void paste_cmd(GtkWidget* widget, GSList** p_term_list);

/* ========================================================== */
/* Function to handle shortcuts */
gint snooper_func(GtkWidget* widget, GdkEventKey *event, gpointer data)
{
  GtkNotebook* nb;
  GSList** ptl;
  int i, nopg;
  GtkWidget* app;
  static gboolean next_is_cmd = FALSE;
#if 0
  char* ctrl_l;
  ZvtTerm* term;
  struct _vtx *vx; 
#endif
  if (event->type == GDK_KEY_PRESS)
    {
      app = gtk_widget_get_toplevel(GTK_WIDGET(widget));
      nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
      ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
      if (!app || !nb || !ptl)
	return 0;
	
      if (next_is_cmd)
	{
	  /* This emulates screen behaviour */
	  if ( ( (event->keyval >= GDK_0) && (event->keyval <= GDK_9) ) ||
	       ( (event->keyval >= GDK_KP_0) && (event->keyval <= GDK_KP_9) ))
	    {
	      char **cmds_names;
	      int n, cmd_num;
	      cmds_names = gtk_object_get_data(GTK_OBJECT(app), "cmds_names");
	      if ( (event->keyval >= GDK_0) && (event->keyval <= GDK_9) ) 
		cmd_num = ((int)event->keyval - (int) GDK_0);
	      else
		cmd_num = ((int)event->keyval - (int) GDK_KP_0);

	      n = 0;
	      while(cmds_names[n])
		n++;
	      if (cmd_num >= n || cmd_num < 0)
		return 0;
	      new_shell_with_command_bb(ptl, cmd_num);
	      return 1;
	    }
	  switch (event->keyval)
	    {
	    case GDK_n:
	      new_shell(ptl, 0);
	      break;
	    case GDK_r:
	      new_root(ptl,0);
	      break;
	    case GDK_m:
	      new_mc(ptl, 0);
	      break;
#if 0 
	    case GDK_l:
	      term = current_term(ptl);
	      vx = term->vx; //\E[H\E[2J
	      ctrl_l= g_strdup("\033");
	      vt_writechild(&vx->vt, ctrl_l, strlen(ctrl_l));
	      break;
#endif
	    } 
	  next_is_cmd = FALSE;
	  return 1;
	}
      else
	{
	  if (event->state & GDK_CONTROL_MASK)
	    {
	      if ((event->keyval == GDK_F1) ||
		  (event->keyval == GDK_KP_F1))
		{
		  next_is_cmd = TRUE;
		  return 1;
		}
#if 0
	      if (event->keyval == GDK_v)
		{
		  term = current_term(ptl);
		  paste_cmd(GTK_WIDGET(term), ptl);
		  return 1;
		}
#endif
	      if ((event->keyval == GDK_F2) ||
		  (event->keyval == GDK_KP_F2) )
		{
		  change_title(NULL, nb);
		  return 1;
		}
	      if (ptl)
		nopg = g_slist_length(*ptl);
	      else
		return 0;
	      for (i = 0; i <= 9; i++)
		{
		  if ( (event->keyval == (i + GDK_0)) ||
		       (event->keyval == (i + GDK_KP_0) ) )
		    {
		      if (i < nopg)
			gtk_notebook_set_page(GTK_NOTEBOOK(nb), i);
		      return 1;
		    }
		} 
	    }
	  if (event->state & GDK_SHIFT_MASK)
	    {
	      if ((event->keyval == GDK_Right) || 
		  (event->keyval == GDK_KP_Right))
		{
		  button_next_page(GTK_WIDGET(nb));
		  return 1;
		}
	      else if ((event->keyval == GDK_Left) ||
		       (event->keyval == GDK_KP_Left) )
		{
		  button_prev_page(GTK_WIDGET(nb));
		  return 1;
		}
	    }
	}
    }
  return 0;
}

struct chg_struct {
GtkNotebook* nb;
ZvtTerm* term;
int page;
};

gboolean
parse_path( gchar          *str,
	    gchar         **item)
{
  gchar *translation;
  gchar *p, *q;
  gchar *path, *parent_path;
  
  path = g_strdup (str);

  p = q = path;
  while (*p)
    {
      if (*p != '_')
        {
          *q++ = *p;
        }
      p++;
    }
  *q = 0;

  translation = str;
  parent_path = g_strdup (path);
  p = strrchr (parent_path, '/');
  if (!p)
    {
      /*g_warning ("invalid entry path `%s'", str);*/
      return FALSE;
    }
  *p = 0;

  p = strrchr (translation, '/');
  if (p)
    p++;
  else
    p = translation;

  g_free(path);
  g_free(parent_path);
  
  *item = g_strdup (p);
  return TRUE;
}


/* ====================== >>> changed_txt <<< ================================= */
void changed_txt(char* string, gpointer data)
{
  int cp;
  GtkWidget *app, *child, *label;
  GtkNotebook* nb;
  ZvtTerm* term;
  GSList** ptl;
  struct chg_struct* pcs;
  struct terminal_config* cfg;
  char tmp3[550], txt[300], *ttitle, *tname;
#if 0  
  nb = GTK_NOTEBOOK(data);
  cp = gtk_notebook_get_current_page(nb);
#endif
  pcs = (struct chg_struct*) data;
  nb = pcs->nb;
  cp = pcs->page;
  term = pcs->term;
  free(pcs);
  app = gtk_widget_get_toplevel(GTK_WIDGET(nb));
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
#if 0
  term = current_term(ptl);
#endif
  
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  
  if (string == NULL) 
    {
      gtk_widget_grab_focus(GTK_WIDGET(term));
      return;
    }
  child = gtk_notebook_get_nth_page(nb, cp);
  tname = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
  ttitle = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
  
  if (!strcmp(ttitle, tname))
    {
      /* if ttitle == tname then change also the window title
	 otherwise leave it unchanged */
      strcpy(ttitle, string);
      sprintf(tmp3, "%s - [ %d-%s ]", cfg->window_title, cp, string);
      gtk_window_set_title (GTK_WINDOW(app), tmp3);
    }
  if (!cfg->titled_tabs)
    strcpy(tname, string);
  /*else
    strcpy(ttitle, string);
   */
  
  sprintf(txt, "%d-%s", cp, string);

  if (cfg->titled_tabs)
    trunc_string(txt, cfg->maxch);

  label = gtk_notebook_get_tab_label(nb,child);
  gtk_label_set_text(GTK_LABEL(label),txt);

  label = gtk_notebook_get_menu_label(nb, child);
  gtk_label_set_text(GTK_LABEL(label), txt);

  gtk_widget_grab_focus(GTK_WIDGET(term));
  
 
}

typedef struct {
  gpointer function;
  gpointer data;
  GtkEntry * entry;
} callback_info;

static void
dialog_string_callback (GnomeMessageBox * mbox, gint button, callback_info * data)
{
  gchar * s = NULL;
  gchar * tmp;
  GnomeStringCallback func = (GnomeStringCallback)data->function;
  
  if (button == 0) {
    tmp = gtk_entry_get_text (data->entry);
    if (tmp) s = g_strdup(tmp);
  }

  (* func)(s, data->data);
}

static GtkWidget *
MGT_request_dialog (const gchar * request, const gchar * default_text, const guint16 max_length,
                GnomeStringCallback callback, gpointer data,
                gboolean password,
                GtkWindow * parent)
{
  GtkWidget * mbox;
  callback_info * info;
  GtkWidget * entry;

  mbox = gnome_message_box_new ( request, GNOME_MESSAGE_BOX_QUESTION,
                                 GNOME_STOCK_BUTTON_OK,
                                 GNOME_STOCK_BUTTON_CANCEL,
                                 NULL );
  gnome_dialog_set_default ( GNOME_DIALOG(mbox), 0 );

  /* set up text entry widget */
  entry = gtk_entry_new();
  if (password) gtk_entry_set_visibility (GTK_ENTRY(entry), FALSE);
  if ((default_text != NULL) && (*default_text))
    gtk_entry_set_text(GTK_ENTRY(entry), default_text);
  if (max_length > 0)
    gtk_entry_set_max_length(GTK_ENTRY(entry), max_length);
 
  gtk_editable_select_region(GTK_EDITABLE(entry), 0, -1);

  gtk_box_pack_end ( GTK_BOX(GNOME_DIALOG(mbox)->vbox),
                     entry, FALSE, FALSE, GNOME_PAD_SMALL );

  /* If Return is pressed in the text entry, propagate to the buttons */
  gnome_dialog_editable_enters(GNOME_DIALOG(mbox), GTK_EDITABLE(entry));

  info = g_new(callback_info, 1);

  info->function = callback;
  info->data = data;
  info->entry = GTK_ENTRY(entry);

  gtk_signal_connect_full(GTK_OBJECT(mbox), "clicked",
                          GTK_SIGNAL_FUNC(dialog_string_callback),
                          NULL,
                          info,
                          (GtkDestroyNotify)g_free,
                          FALSE, FALSE);

  if (parent != NULL) {
    gnome_dialog_set_parent(GNOME_DIALOG(mbox),parent);
  }

  gtk_widget_grab_focus (entry);
  gtk_widget_show (entry);
  gtk_widget_show (mbox);
  return mbox;
}

GtkWidget *
MGT_gnome_request_dialog (gboolean password, const gchar * prompt,
                      const gchar * default_text, const guint16 max_length,
                      GnomeStringCallback callback, gpointer data,
                      GtkWindow * parent)
{
  return MGT_request_dialog (prompt, default_text, max_length,
                         callback, data, password, parent);


}

/* ===================== >>> change_title <<< =================================== */
void change_title_page(GtkWidget* widget, gpointer data, int page)
{
  char lbltxt[256];
  gchar* txt = NULL;
  int cp, len;
  GtkWidget* chgtxt;
  GtkNotebook* nb;
  struct chg_struct *pcs;
  GtkWidget *app, *child; 
  GSList **ptl, *tmp;
  ZvtTerm* term;
  struct terminal_config* cfg;
  nb = GTK_NOTEBOOK(data);
  
  if (page < 0)
    cp = gtk_notebook_get_current_page(nb);
  else 
    cp = page;

  app = gtk_widget_get_toplevel(GTK_WIDGET(nb));
  
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  
  if (page < 0)
    term = current_term(ptl);
  else
    {
      tmp = g_slist_nth(*ptl, page);
      term = ZVT_TERM(tmp->data);
    }
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  
  sprintf(lbltxt, "Change title of terminal n.%d", cp);
  
  child = gtk_notebook_get_nth_page(nb, cp);
  if (cfg->titled_tabs)
    {
      txt = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
      len = 256;
    }
  else
    {
      txt = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
      len = 32;
    }

  pcs = malloc(sizeof(struct chg_struct));
  pcs->nb = nb;
  pcs->page = cp;
  pcs->term = term;
  chgtxt = MGT_gnome_request_dialog(FALSE, lbltxt, txt, len, 
				changed_txt, (gpointer) pcs, GTK_WINDOW(app));
  gtk_window_set_modal(GTK_WINDOW(chgtxt), TRUE);
}

void change_title(GtkWidget* widget, gpointer data)
{
  change_title_page(widget, data, -1);
}

void button_prev_page(GtkWidget* w)
{
  GtkWidget *app, *term;
  GSList** ptl;
  int cp, lp;

  app = gtk_widget_get_toplevel(w);
  ptl = gtk_object_get_data(GTK_OBJECT(app),"ptermlist");

  cp = gtk_notebook_get_current_page(GTK_NOTEBOOK(w));
  lp = g_slist_length(*ptl) - 1;

  if (cp == 0)
   gtk_notebook_set_page(GTK_NOTEBOOK(w), lp);
  else 
   gtk_notebook_prev_page(GTK_NOTEBOOK(w));
    term = GTK_WIDGET(current_term(ptl));
  gtk_widget_grab_focus(term);
}

void button_next_page(GtkWidget* w)
{
  GtkWidget *app, *term;
  GSList** ptl;
  int cp, lp;
  app = gtk_widget_get_toplevel(w);
  ptl = gtk_object_get_data(GTK_OBJECT(app),"ptermlist");

  cp = gtk_notebook_get_current_page(GTK_NOTEBOOK(w));
  lp = g_slist_length(*ptl) - 1;
 
  if (cp == lp)
    gtk_notebook_set_page(GTK_NOTEBOOK(w), 0);
  else 
    gtk_notebook_next_page(GTK_NOTEBOOK(w));
  
  term = GTK_WIDGET(current_term(ptl));
  gtk_widget_grab_focus(term);

}

void create_toolbar(GnomeApp *app)
{
  GSList** ptl;
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  gnome_app_create_toolbar_with_data(GNOME_APP(app), gnome_terminal_toolbar,
				     ptl);
}

GtkWidget  *create_buttonbar(GtkWidget* app, GtkWidget* notebook)
{
  GtkWidget* button, *menubar2, *table, *hbox_but, *pixmap;
  GSList** p_term_list;

  p_term_list = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  get_main_menu (GTK_WIDGET(app), &menubar2, p_term_list);
  gtk_widget_show (menubar2);
  
  gtk_object_set_data(GTK_OBJECT(app), "butmenu_widget", menubar2);

  hbox_but = gtk_hbox_new (0, 3);
  gtk_object_set_data(GTK_OBJECT(app), "buttonbar", hbox_but);
  rebuild_buttonbar_menu(GTK_WIDGET(app));
  
  table = gtk_table_new(1, 4, TRUE);

  gtk_table_set_col_spacings(GTK_TABLE(table), 3);

  gtk_box_pack_start (GTK_BOX (hbox_but), menubar2, FALSE, TRUE, 0);
  
  /* button = gtk_button_new_with_label ("    Next   "); */
  button = gnome_stock_button(GNOME_STOCK_PIXMAP_REMOVE);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC(remove_book),
		      GTK_OBJECT(notebook));

  gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 0,1);
  gtk_widget_show(button);

  pixmap = gnome_stock_new_with_icon(GNOME_STOCK_MENU_PREF);
  button = gnome_pixmap_button(pixmap, N_("Title"));

  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC(change_title),
		      GTK_OBJECT(notebook));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 3, 4,0,1);
  pixmap = gnome_stock_new_with_icon(GNOME_STOCK_BUTTON_PREV);
  button = gnome_pixmap_button(pixmap, N_("Tab Left"));

  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      (GtkSignalFunc) butcb_move_left,
		      GTK_OBJECT(notebook));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 0, 1,0,1);

  pixmap = gnome_stock_new_with_icon(GNOME_STOCK_BUTTON_NEXT);
  button = gnome_pixmap_button(pixmap, N_("Tab Right"));

  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      (GtkSignalFunc) butcb_move_right,
		      GTK_OBJECT(notebook));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 1, 2,0,1);

  gtk_widget_show(table);

  gtk_box_pack_start(GTK_BOX(hbox_but), table, 0, 1, 0);
  return hbox_but;

}

void create_menubar(GnomeApp* app)
{
  GSList** ptl;
 
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");

  gnome_app_create_menus_with_data (GNOME_APP (app), 
				    gnome_terminal_menu, ptl);
  rebuild_menubar_from_arrays(GNOME_APP(app));

}
void hide_buttonbar(GnomeApp* app, gboolean hbb)
{
  GtkWidget* vbox, *hbox_but, *notebook;
  GtkCheckMenuItem *toggle_item;
  
  vbox = gtk_object_get_data(GTK_OBJECT(app), "appvbox");
  hbox_but = gtk_object_get_data(GTK_OBJECT(app), "buttonbar");
  notebook = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  if (!hbox_but)
    {
      hbox_but = create_buttonbar(GTK_WIDGET(app), GTK_WIDGET(notebook));
      /*gtk_object_set_data(GTK_OBJECT(app), "buttonbar", hbox_but);*/
      gtk_box_pack_start(GTK_BOX(vbox), hbox_but, 0, 1, 0); 
    } 

  if (hbb == TRUE)
    {
      gtk_widget_hide(GTK_WIDGET(hbox_but));      
    }
  else
    {
      gtk_widget_show(GTK_WIDGET(hbox_but));    
    }

  if (GTK_IS_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_BUTTONBAR].widget)) 
    {
      /* update menu */
      toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_BUTTONBAR].widget);
      toggle_item->active = !hbb;
    }
}

void hide_menubar(GnomeApp* app, gboolean hmb)
{
  GtkCheckMenuItem *toggle_item;
  
  if (!app->menubar)
    {
      create_menubar(app);
    }

  if (hmb)
    gtk_widget_hide (app->menubar->parent);
  else
    gtk_widget_show (app->menubar->parent);

  if (GTK_IS_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_MENUBAR].widget)) 
    {
      /* update menu */
      toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_MENUBAR].widget);
      toggle_item->active = !hmb;
    }
}

void hide_toolbar(GnomeApp* app, gboolean htb)
  {
  GnomeDockItem* dock_item;
  GnomeDockLayoutItem* dock_layout_item;
  GnomeDockPlacement dock_plac;
  guint num_band_return, band_position_return, offset_return; 
  GtkCheckMenuItem *toggle_item;
  
  if (app->layout)
    {
      dock_layout_item = gnome_dock_layout_get_item_by_name(app->layout, 
		    					    GNOME_APP_TOOLBAR_NAME);
       if (!dock_layout_item)
	{
	  create_toolbar(app);
	  dock_layout_item = gnome_dock_layout_get_item_by_name(app->layout, 
	    							GNOME_APP_TOOLBAR_NAME);
	}
       if (htb == TRUE)
	 gtk_widget_hide(GTK_WIDGET(dock_layout_item));      
       else
	 gtk_widget_show(GTK_WIDGET(dock_layout_item));    
    }
  else
    {
      dock_item = gnome_dock_get_item_by_name  (GNOME_DOCK(app->dock),
                                               GNOME_APP_TOOLBAR_NAME,
					       &dock_plac,
					       &num_band_return,
					       &band_position_return,
					       &offset_return);
      if (!dock_item)
	{
	  create_toolbar(app);
	  dock_item = gnome_dock_get_item_by_name  (GNOME_DOCK(app->dock),
	      					    GNOME_APP_TOOLBAR_NAME,
	     					    &dock_plac,
	     					    &num_band_return,
	     					    &band_position_return,
	     					    &offset_return);
	}       
 
      if (htb == TRUE)
	gtk_widget_hide(GTK_WIDGET(dock_item));      
      else
	gtk_widget_show(GTK_WIDGET(dock_item));    
    }
  
  if (GTK_IS_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_TOOLBAR].widget)) 
    {
      /* update menu */
      toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_TOOLBAR].widget);
      toggle_item->active = !htb;
    }
}

char** vector_dup(char** v)
{
  int x = 0;
  char** rp;
  while(v[x])
    x++;
  
  rp = malloc(sizeof(char*)*(x+1));
  x = 0;
  while(v[x])
    {
      rp[x] = malloc(sizeof(char)*(strlen(v[x])+1));
      strcpy(rp[x], v[x]);
      x++;
    }
  
  rp[x] = NULL;
  return rp;
}


void nb_switch_pg (GtkNotebook * notebook, GtkNotebookPage * page,
                      gint page_num, gpointer user_data)
{
  GtkWidget * tmp, *app;
  GtkWidget* term;
  gchar tmp3[512];
  GSList* tl;
  GSList** ptl;
  char *ttitle;
  struct terminal_config* cfg;
  app = gtk_widget_get_toplevel(GTK_WIDGET(notebook));
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  
  tmp = gtk_notebook_get_tab_label (GTK_NOTEBOOK(notebook),
                                    gtk_notebook_get_nth_page (GTK_NOTEBOOK(notebook),
						       page_num));
  if (!ptl)
    return;
      
  if (!(*ptl))
    return;

  tl = g_slist_nth(*ptl, page_num);
  if (!tl)
    return;

  term = GTK_WIDGET(tl->data);
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  ttitle = gtk_object_get_data(GTK_OBJECT(term), "termtitle");

  ZVT_TERM(term)->pg_switched = 1;

  sprintf(tmp3, "%s - [ %d-%s ]", cfg->window_title, page_num, ttitle);
  gtk_window_set_title (GTK_WINDOW(app), tmp3);
  gtk_widget_grab_focus(GTK_WIDGET(term));
}

void check_resize(GtkContainer* app, gpointer data)
{
  int *resize;
  ZvtTerm* te;

  te = current_term((GSList**)data); 
  
  if (!te->pg_switched )
    {
      te->force_paint = 1;
      
    }
  else
    {
      te->pg_switched = 0;
    }
  /* NOTE: probably it's better to put this under the condition
     that it isn't a tab switch i.e. I can put this after te->force_paint=1 */
  resize = gtk_object_get_data(GTK_OBJECT(app), "is_a_resize");
  *resize = TRUE;
  /*set_all_undefined((GSList**)data);*/
}

/* This function is called when user set a new theme for example 
   and it sets correctly all tabs styles */


void cb_style_set(GtkWidget* w, GtkStyle* ps, gpointer data)
{
  GSList **ptl, *tmp;
  GtkWidget* term, *child, *label;
  GtkStyle* rcstyle;
  GtkNotebook* nb;
  int i, *p_state;
  GtkStyle* old_style[UNDEFINED+1];
  struct  terminal_config* cfg;

  ptl = gtk_object_get_data(GTK_OBJECT(w), "ptermlist");

  term = GTK_WIDGET((*ptl)->data);
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  nb = GTK_NOTEBOOK(gtk_object_get_data(GTK_OBJECT(w), "notebook"));
  
  child = gtk_notebook_get_nth_page(nb, 0);
  label = gtk_notebook_get_tab_label(nb, child);

  rcstyle = gtk_rc_get_style(label);
  if (!rcstyle)
    rcstyle = gtk_widget_get_style(label);

  for (i = 0; i < UNDEFINED + 1; i++)
   old_style[i]= tab_style[i];

  init_styles(rcstyle, cfg);
  
  /* e qui deve settare lo stile di tutti i tab!!! */
  tmp = *ptl;
  i = 0;
  while(tmp)
    {
      term = GTK_WIDGET(tmp->data);
      child = gtk_notebook_get_nth_page(nb, i);
      label = gtk_notebook_get_tab_label(nb, child);
      p_state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
      gtk_widget_set_style(label, tab_style[UNCHANGED]);
      gtk_widget_set_style(GTK_WIDGET(label), tab_style[*p_state]);
      tmp = tmp->next;
      i++;
    }
  
  for (i = 0; i < UNDEFINED + 1; i++)
    gtk_style_unref(old_style[i]);

}

  GtkWidget *
  new_terminal_cmd (char **cmd, struct terminal_config *cfg_in, const gchar *geometry, int termid, char** cmds_names_in,  char** cmds_in)
{
        /* p_term_list is a pointer to the list of all terminals in the current window
	 */
        GSList** p_term_list;
	GtkWidget *notebook;
	GtkWidget *lblmenu, *frame, *app, *vbox, *hbox_but, *label;
	GtkWidget  *hbox, *scrollbar;
	GtkStyle* rcstyle;
#ifdef GT_DIR_TREE
	GtkWidget* hpaned, *frame_sw, *ctree;
#endif	
	ZvtTerm   *term;
#ifdef  SHADING
	GdkImlibColorModifier mod, rmod, gmod, bmod;
#endif
	char *nome_term, *term_title;
	static gint snoop_id = 0;
	char buffer [40];
	char nb_txt[1024];
	char wmclass_class [64], wmclass_name[64];
	char wintit[512];
	char *shell, *name;
	int i = 0;
	struct terminal_config *cfg;
	int width, height, *isres;
	int xpos, ypos, *pts;
	char **cmds = NULL, **cmds_names = NULL;
	/* FIXME: is seems like a lot of this stuff should be done by apply_changes instead */

	cfg = terminal_config_dup (cfg_in);

	if (cmds_in)
	  {	  
	    cmds = vector_dup(cmds_in);
	    cmds_names = vector_dup(cmds_names_in);
	  }

	gnome_terminal_menu[1].moreinfo = custom_submenu_void;

	cfg->terminal_id = termid;

	/* Setup the environment for the gnome-terminals:
	 *
	 * TERM is set to xterm (which is what zvt emulates)
	 * COLORTERM is set for slang-based applications to auto-detect color
	 * WINDOWID spot is reserved for the xterm compatible variable.
	 * COLS is removed
	 * LINES is removed
	 */
	if (!env_copy){
		char **p;
		
		for (p = env; *p; p++)
			;
		i = p - env;
		env_copy = (char **) g_malloc (sizeof (char *) * (i + 1 + EXTRA));
		for (i = 0, p = env; *p; p++){
		        if ((strncmp (*p, "COLUMNS=", 8) == 0)
				   || (strncmp (*p, "LINES=", 6) == 0)
				   || (strncmp(*p, "WINDOWID=", 9) == 0)
			           || (strncmp (*p, "TERM=", 5) == 0)
				   || (strncmp (*p, "GNOME_DESKTOP_ICON=", 19) == 0)) {
				/* nothing: do not copy those */
			} else
				env_copy [i++] = *p;
		}
		term_pos = i++;
		env_copy [term_pos] = "";
		env_copy [i++] = "COLORTERM=gnome-terminal";
		winid_pos = i++;
		env_copy [winid_pos] = "TEST";
		env_copy [i] = NULL;
	}

	app = gnome_app_new ("MultiTerminal", _("Multi Gnome Terminal"));
	
	isres = malloc(sizeof(int));
	*isres = FALSE;
	gtk_object_set_data(GTK_OBJECT(app), "is_a_resize", isres);
	
	/* PROVA */
	gtk_container_set_resize_mode(GTK_CONTAINER(app), GTK_RESIZE_QUEUE);
	/* override the title if it was in the config */
	if (cfg->window_title) {
	  gtk_window_set_title(GTK_WINDOW(app), cfg->window_title);
 	}
	else
	  cfg->window_title = g_strdup("MGT");
	    
	  
	/* override the icon if it was in the config */
	if (cfg->window_icon) {
	  gnome_window_icon_set_from_file (GTK_WINDOW(app), cfg->window_icon);
 	}

	g_snprintf (wmclass_name, sizeof (wmclass_name), "%s", 
		    GTK_WINDOW(app)->wmclass_name);
	g_snprintf (wmclass_class, sizeof(wmclass_class), "%s",
		    GTK_WINDOW(app)->wmclass_class); 
    	gtk_window_set_wmclass (GTK_WINDOW (app), wmclass_name, wmclass_class);

	gtk_window_set_policy(GTK_WINDOW (app), TRUE, TRUE, TRUE);
	/*gtk_window_set_policy(GTK_WINDOW (app), FALSE, TRUE, FALSE);*/

	if (cmd != NULL)
		initial_term = app;

	gtk_widget_realize (app);

	/* ACCELERATORS 21/08/01 */
#define USE_SNOOPER
#ifdef USE_SNOOPER	
	if (!snoop_id)
	  snoop_id = gtk_key_snooper_install(snooper_func, NULL);
#else
	gtk_signal_connect(GTK_OBJECT(app), "key-press-event", 
			   GTK_SIGNAL_FUNC(snooper_func), NULL);
#endif	
	terminals = g_list_append (terminals, app);
	/* Setup the Zvt widget */
	
	/*
	 * Handle geometry specification; height and width are in
	 * terminal rows and columns
	 */

	width=80;
	height=24;
	xpos=-1;
	ypos=-1;
	if (geometry) {
		gnome_parse_geometry (geometry, &xpos, &ypos, &width, &height);
		if (width == -1 || height == -1) {
			width=80;
			height=24;
		}
		/* Only the first window gets --geometry treatment for now */
		geometry = NULL;
	}

	term = (ZvtTerm *)zvt_term_new_with_size(width, height);
	gnome_term_set_font (term, cfg->font, cfg->use_bold);
	gtk_signal_connect(GTK_OBJECT(term), "new_output", new_output, NULL);
       	pts = malloc(sizeof(int));
	*pts = UNDEFINED;
	gtk_object_set_data(GTK_OBJECT(term), "term_state", pts);
	pts = malloc(sizeof(int));
	*pts = FALSE;
	gtk_object_set_data(GTK_OBJECT(term), "new_out", pts);

	if (xpos != -1 && ypos != -1)
	  gtk_widget_set_uposition (GTK_WIDGET (app), xpos, ypos);
	
	if ((zvt_term_get_capabilities (term) & ZVT_TERM_PIXMAP_SUPPORT) != 0){
		zvt_pixmap_support = TRUE;
	}
	gtk_object_set_data(GTK_OBJECT(app), "term", term);

	gtk_widget_grab_focus(GTK_WIDGET(term));

	gtk_widget_show (GTK_WIDGET (term));
	gtk_signal_connect_object(GTK_OBJECT(app),"configure_event",
				  GTK_SIGNAL_FUNC(term_change_pos),
				  GTK_OBJECT(app));

	zvt_term_set_scrollback (term, cfg->scrollback);

	zvt_term_set_wordclass  (term, (guchar *)cfg->wordclass);
	zvt_term_set_bell  (term, !cfg->bell);
	zvt_term_set_blink (term, cfg->blink);
	zvt_term_set_scroll_on_keystroke (term, cfg->scroll_key);
	zvt_term_set_scroll_on_output (term, cfg->scroll_out);
	zvt_term_set_del_key_swap (term, cfg->swap_keys);
#ifdef HAVE_ZVT_DEL_IS_DEL
	zvt_term_set_del_is_del (term, cfg->del_is_del);
#endif

	gtk_signal_connect (GTK_OBJECT (term), "child_died",
			    GTK_SIGNAL_FUNC (terminal_kill), term);

	gtk_signal_connect (GTK_OBJECT (term), "title_changed",
			    (GtkSignalFunc) title_changed, term);

	gtk_signal_connect (GTK_OBJECT (app), "delete_event",
			   GTK_SIGNAL_FUNC (close_app), term);

	gtk_signal_connect (GTK_OBJECT (app), "grab_focus",
			    GTK_SIGNAL_FUNC(grab_focus), term);

	gtk_signal_connect (GTK_OBJECT (term), "button_press_event",
			    GTK_SIGNAL_FUNC (button_press), term);
/*
	gtk_signal_connect_after (GTK_OBJECT (term), "realize",
				  GTK_SIGNAL_FUNC (cb_term_realize), term);
*/	
#ifdef ZVT_TERM_MATCH_SUPPORT
	zvt_term_match_add( ZVT_TERM(term), "(((news|telnet|nttp|file|http|ftp|https)://)|(www|ftp))[-A-Za-z0-9\\.]+(:[0-9]*)?", VTATTR_UNDERLINE, "host only url");
	zvt_term_match_add( ZVT_TERM(term), "(((news|telnet|nttp|file|http|ftp|https)://)|(www|ftp))[-A-Za-z0-9\\.]+(:[0-9]*)?/[-A-Za-z0-9_\\$\\.\\+\\!\\*\\(\\),;:@&=\\?/~\\#\\%]*[^]'\\.}>\\) ,\\\"]", VTATTR_UNDERLINE, "full url");
#endif
        gtk_object_set_data(GTK_OBJECT(term), "env_copy", env_copy);

	p_term_list = (GSList**) malloc(sizeof(GSList*));
	*p_term_list = g_slist_append(NULL, (gpointer) term);
 	gtk_signal_connect(GTK_OBJECT(app), "check-resize", check_resize, p_term_list);

	/* Disable tear off of menubar and of toolbar which cause the app to die */
	gnome_preferences_set_menubar_detachable(FALSE);
	gnome_preferences_set_toolbar_detachable(FALSE);
	gtk_object_set_data(GTK_OBJECT(app), "ptermlist", p_term_list);
	gtk_object_set_data(GTK_OBJECT(app), "cmds_names", cmds_names);
	gtk_object_set_data(GTK_OBJECT(app), "cmds_list", cmds);
	gtk_object_set_data(GTK_OBJECT(app), "custom_submenu", NULL);
	gtk_object_set_data(GTK_OBJECT(app), "buttonbar_menu", NULL);
	gtk_object_set_data(GTK_OBJECT(app), "buttonbar", NULL);
	if (!cfg->toolbar_hidden)
          {
	    create_toolbar(GNOME_APP(app));
	  }
        gnome_terminal_edit[0].user_data = (gpointer) p_term_list;


	if (!cfg->menubar_hidden)
          {
	    create_menubar(GNOME_APP(app));
	  }
	/* p_term_list is now passed to callbacks */
	
	/* Decorations */
	/* added vbox */
	vbox = gtk_vbox_new(0,0);
	
	hbox = gtk_hbox_new (0, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox), 0);

	/* gtk_container_set_border_width (GTK_CONTAINER (hbox), 2); */
       	gtk_box_set_spacing (GTK_BOX (hbox), 2);

	gtk_widget_show (hbox);
	/* added show of vbox */
	gtk_widget_show (vbox);
	
	get_shell_name (&shell, &name, cfg->invoke_as_login_shell);

	scrollbar = gtk_vscrollbar_new (GTK_ADJUSTMENT (term->adjustment));
	gtk_object_set_data (GTK_OBJECT (term), "scrollbar", scrollbar);
	gtk_object_set_data (GTK_OBJECT (term), "config", cfg);
	GTK_WIDGET_UNSET_FLAGS (scrollbar, GTK_CAN_FOCUS);

        if (cfg->scrollbar_position == SCROLLBAR_LEFT)
		gtk_box_pack_start (GTK_BOX (hbox), scrollbar, 0, 1, 0);
	else
		gtk_box_pack_end (GTK_BOX (hbox), scrollbar, 0, 1, 0);
        if (cfg->scrollbar_position != SCROLLBAR_HIDDEN)
		gtk_widget_show (scrollbar);
	
	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);

	gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET (term), 1, 1, 0);
		
	gtk_widget_show(frame);
#ifdef GT_DIR_TREE
	hpaned = gtk_hpaned_new();
	gtk_container_add(GTK_CONTAINER(frame), GTK_WIDGET(hbox)); 
	frame_sw = add_dir_tree(GTK_WIDGET(hpaned), GTK_WIDGET(app));
	
	/* HIDE DIRTREE */
	/*gtk_widget_hide(frame_sw);
	  gtk_paned_set_handle_size(GTK_PANED(hpaned), 0);
	  gtk_paned_set_gutter_size(GTK_PANED(hpaned), 0);*/
	/* ============= */
	gtk_paned_pack2(GTK_PANED(hpaned), GTK_WIDGET(frame), TRUE, TRUE);
	
	gtk_widget_show(GTK_WIDGET(hpaned));
#else
	gtk_container_add(GTK_CONTAINER(frame), GTK_WIDGET(hbox));
#endif
	notebook = gtk_notebook_new();
	GTK_WIDGET_UNSET_FLAGS (notebook, GTK_CAN_FOCUS);
	gtk_container_set_resize_mode(GTK_CONTAINER(notebook), GTK_RESIZE_QUEUE);
	gtk_container_set_border_width(GTK_CONTAINER(notebook), 0);
	gtk_notebook_popup_enable (GTK_NOTEBOOK(notebook));
	gtk_object_set_data(GTK_OBJECT(app), "notebook", notebook);
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), TRUE);

	sprintf(nb_txt, "0-Shell");
	label = gtk_label_new(nb_txt);

        sprintf(wintit, "%s - [ 0-Shell ]", cfg->window_title);	
	gtk_window_set_title (GTK_WINDOW(app), wintit);

	lblmenu = gtk_label_new(nb_txt);
#ifdef DEFAULT_GTK_STYLE	
	init_styles(gtk_widget_get_style(label), cfg);
#else
	rcstyle = gtk_rc_get_style(label);
        if (!rcstyle)
          rcstyle = gtk_widget_get_style(label);
	init_styles(rcstyle, cfg);

	gtk_signal_connect(GTK_OBJECT(app), "style-set", cb_style_set, NULL);
#endif
	/* hbox -> frame now each terminal is sorrounded by a frame! */
#ifdef GT_DIR_TREE
	gtk_notebook_append_page_menu (GTK_NOTEBOOK (notebook), hpaned, label, lblmenu);
#else
	gtk_notebook_append_page_menu (GTK_NOTEBOOK (notebook), frame, label, lblmenu);
#endif
	gtk_notebook_set_page (GTK_NOTEBOOK(notebook), 0);
	
        if (cfg->tab_hidden)
          {
            gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook), FALSE);
          }

        gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), cfg->tab_position);
	gtk_widget_show(notebook);
	
	/* Create a bunch of buttons */
	
	nome_term = malloc(sizeof(char)*33);
	strcpy(nome_term, "Shell");
	gtk_object_set_data(GTK_OBJECT(term), "mtermname", nome_term);
       	term_title = malloc(sizeof(char)*256);
	strcpy(term_title,"Shell");
	gtk_object_set_data(GTK_OBJECT(term), "termtitle", term_title);

	gtk_signal_connect(GTK_OBJECT(notebook), "switch-page", nb_switch_pg, 
			   p_term_list);

        gtk_box_pack_start(GTK_BOX(vbox), notebook, 1, 1, 0); 
        if (!cfg->buttonbar_hidden)
           {  
	     hbox_but = create_buttonbar(GTK_WIDGET(app), notebook);
	     gtk_box_pack_start(GTK_BOX(vbox), hbox_but, 0, 1, 0); 
	     gtk_widget_show(hbox_but);
	   }
        else
	     hbox_but= NULL;
        gtk_object_set_data(GTK_OBJECT(app), "appvbox", vbox);
	gtk_object_set_data(GTK_OBJECT(app), "buttonbar", hbox_but);

	gnome_app_set_contents (GNOME_APP (app), vbox);
	/* we need to call need_hints before app is shown
	   otherwise it changes the window size */
	set_hints(GTK_WIDGET(term));
	configure_term_dnd (term);
#ifdef SHADING
	term->tintback = cfg->tintback;
	mod.contrast = mod.gamma = 256;
	mod.brightness = cfg->shading;
	rmod.contrast = rmod.gamma = 256;
	gmod.contrast = gmod.gamma = 256;
	bmod.contrast = bmod.gamma = 256;
	rmod.brightness = cfg->rtint;
	gmod.brightness = cfg->gtint;
	bmod.brightness = cfg->btint;
	zvt_term_set_image_mode(term, cfg->image_mode);
	zvt_term_set_shading(term, mod, rmod, gmod, bmod);
#endif	
	if (zvt_pixmap_support && cfg->background_pixmap) {
		int flags;
#ifdef ZVT_BACKGROUND_SCROLL
		flags = cfg->shaded?ZVT_BACKGROUND_SHADED:0;
		flags |= cfg->scroll_background?ZVT_BACKGROUND_SCROLL:0;
#else
		flags = cfg->shaded;
#endif
		zvt_term_set_background (term,
					 cfg->pixmap_file,
					 cfg->transparent, flags);
	} else if (zvt_pixmap_support && cfg->transparent)
		zvt_term_set_background (term, NULL,
					 cfg->transparent, cfg->shaded);
	else
         	zvt_term_set_background (term, NULL, 0, 0);
	

	gtk_widget_show (app);

        set_color_scheme (term, cfg);
	gtk_widget_realize(GTK_WIDGET(term));
	XSync(GDK_DISPLAY(), False);
	gtk_widget_queue_resize(GTK_WIDGET(app));
	gtk_signal_connect(GTK_OBJECT(term), "size-allocate",
			   term_alloc_size, term);
	
	errno = 0;
	switch (zvt_term_forkpty (ZVT_TERM(term), cfg->update_records)){
	case -1:
		show_pty_error_dialog(errno);
		g_free (shell);
		g_free (name);

		/* should we exit maybe? */
		return NULL;
		
	case 0: {
		int open_max = sysconf (_SC_OPEN_MAX);

		for (i = 3; i < open_max; i++)
			fcntl (i, F_SETFD, 1);

		/* set delayed env variables */
		g_snprintf (buffer, sizeof (buffer),
			    "WINDOWID=%d",(int) GDK_WINDOW_XWINDOW(GTK_WIDGET(term)->window));
		env_copy [winid_pos] = buffer;

		if (cfg->termname && cfg->termname [0])
			env_copy [term_pos] = cfg->termname;
		else
			env_copy [term_pos] = "TERM=xterm";

		if (cmd){
			environ = env_copy;
			execvp (cmd[0], cmd);
		} else
		  {
		    execle (shell, name, NULL, env_copy);
		  }
		perror ("Could not exec\n");
		_exit (127);
		}
	}
	/* term->p_term_list */
	g_free (shell);
	g_free (name);

	return app;
}

