#define NO
#include <config.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkprivate.h>
#include <gnome.h>
#include "zvtterm.h"
#include <orb/orbit.h>
#include <libgnorba/gnorba.h>
#include <libgnomeui/gnome-window-icon.h>
#include <glade/glade.h>

#include <X11/Xatom.h>

#include "gnome-terminal.h"

#define  GT_DIR_TREE

#define DEFAULT_BUTTONBAR_ITEMS 5

#define XZVT_TERM(obj)          GTK_CHECK_CAST (obj, xzvt_term_get_type (), xZvtTerm)
#define XZVT_TERM_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, xzvt_term_get_type (), xZvtTermClass)
#define XZVT_IS_TERM(obj)       GTK_CHECK_TYPE (obj, xzvt_term_get_type ())

#define DEFAULT_FONT "-misc-fixed-medium-r-normal--20-200-75-75-c-100-iso8859-1"
#define EXTRA 6


enum scrollbar_position_enum {
	SCROLLBAR_LEFT   = 0,
	SCROLLBAR_RIGHT  = 1,
	SCROLLBAR_HIDDEN = 2
};

enum targets_enum {
        TARGET_STRING,
	TARGET_COLOR,
	TARGET_BGIMAGE
};

/* nautilus uses this UTTER HACK to reset backgrounds, ugly ugly ugly,
 * broken, ugly ugly, but whatever */
#define RESET_IMAGE_NAME "/nautilus/backgrounds/reset.png"

/* The color set */
enum color_set_enum {
	COLORS_WHITE_ON_BLACK,
	COLORS_BLACK_ON_WHITE,
	COLORS_GREEN_ON_BLACK,
	COLORS_BLACK_ON_LIGHT_YELLOW,
	COLORS_CUSTOM
};

enum palette_enum {
	PALETTE_LINUX,
	PALETTE_XTERM,
	PALETTE_RXVT,
	PALETTE_CUSTOM
};

typedef struct {
	GtkWidget *prop_win;
	GtkWidget *blink_checkbox;
	GtkWidget *scroll_kbd_checkbox;
	GtkWidget *scroll_out_checkbox;
	GtkWidget *swapkeys_checkbox;
#ifdef HAVE_ZVT_DEL_IS_DEL
	GtkWidget *del_is_del_checkbox;
#endif
	GtkWidget *login_by_default_checkbox;
	GtkWidget *use_bold_checkbox;
	GtkWidget *wordclass_entry;
	GtkWidget *pixmap_checkbox;
	GtkWidget *pixmap_file_entry;
	GtkWidget *pixmap_label;
	GtkWidget *pixmap_entry;
	GtkWidget *transparent_checkbox;
	GtkWidget *shaded_checkbox;
#ifdef ZVT_BACKGROUND_SCROLL
	GtkWidget *pixmap_scrollable_checkbox;
#endif
	GtkWidget *menubar_checkbox;
	/* ADDED 2 FIELDS */
	GtkWidget *toolbar_checkbox;
	GtkWidget *buttonbar_checkbox; 	
	GtkWidget *close_dialog_checkbox; 
	GtkWidget *tab_position;
	GtkWidget *perclbl;
	/* ================= */
#ifdef SHADING
	GtkWidget* shaded_hscale;
	GtkWidget* tinted_checkbox;
	GtkWidget* tinted_colorpicker; 
	GtkWidget* om_imgmode;
#endif  
	GtkWidget *maxch;
	GtkWidget *lbl_maxch;
	GtkWidget *titled_tabs;	
	GtkWidget *bell_checkbox;
	GtkWidget *font_entry;
	GtkWidget *color_scheme;
	GtkWidget *def_fore_back;
	GtkWidget *scrollbar;
	GtkWidget *scrollback_spin;
	GtkWidget *class_box;
	GtkWidget *fore_label;
	GtkWidget *back_label;
	GtkWidget *palette_label;
	GtkWidget *lbl_termchgd;
	GtkWidget *lbl_termchgn;	
	GtkWidget *but_default; 
	/* MODIFIED 18->20 */
	GtkWidget *palette[20];
	int changed;
} preferences_t;

struct terminal_config {
	int keyboard_secured :1;		/* Does this terminal have the keyboard secured? */
	int tintback: 1;
	int titled_tabs       :1;
        int bell             :1;                /* Do we want the bell? */
	int blink            :1; 		/* Do we want blinking cursor? */
	int scroll_key       :1;       		/* Scroll on input? */
	int scroll_out       :1;       		/* Scroll on output? */
	int swap_keys        :1;       		/* Swap Delete/Backspace? */
	int login_by_default :1;                /* do --login as default */
#ifdef ZVT_BACKGROUND_SCROLL
	int scroll_background:1; 		/* background will scroll */
#endif
	int use_bold         :1;		/* Use bold on bright colours */
#ifdef HAVE_ZVT_DEL_IS_DEL
	int del_is_del       :1; 		/* Generates Delete DEL/^H? */
#endif
	enum palette_enum color_type; 			/* The color mode */
	enum color_set_enum color_set;
	char *font; 				/* Font used by the terminals */
	int scrollback; 			/* Number of scrollbacklines */
	char *class;
	enum scrollbar_position_enum scrollbar_position;
	int invoke_as_login_shell; 		/* How to invoke the shell */
	int update_records;
	int update_records_and, update_records_xor;
	const char *user_back_str, *user_fore_str;
	int menubar_hidden; 			/* Whether to show the menubar */
	/* ADDED 2 FIELDS */
	int toolbar_hidden;
	int buttonbar_hidden;
	int tab_hidden;
	GtkPositionType tab_position;
	int close_confirm;
	/* ============== */
	int transparent;
	int have_user_background;		/* Only used for command line parsing */
#ifdef ZVT_BACKGROUND_SCROLL
	int have_user_scroll_bg; 		/* Only used for command line parsing */
#endif
	int shaded;
#ifdef SHADING
	int maxch;
	int shading;
	int rtint;
	int gtint;
	int btint;
	int image_mode;
#endif
	int have_user_shaded;			/* Only used for command line parsing */
	int background_pixmap;
	int terminal_id;			/* terminal id for this terminal */
	char *pixmap_file;
        char *window_title;                     /* the window title */
        char *window_icon;                      /* the window icon */
	char *wordclass;			/* select-by-word character class */
	char *termname;				/* TERM variable setting, store as TERM=xxx */
	/* MODIFIED 18->20 */
	GdkColor palette[20];			/* the full palette */
} ;

enum term_state { 
  CHANGING,
  CHANGED,
  UNCHANGED,
  VISIBLE,
  UNDEFINED
};

#define GTK_TYPE_MYCTREE            (gtk_myctree_get_type ())
#define GTK_MYCTREE(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_MYCTREE, GtkMyCTree))
#define GTK_MYCTREE_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_MYCTREE, GtkMyCTreeClass))
#define GTK_IS_MYCTREE(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_MYCTREE))
#define GTK_IS_MYCTREE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_MYCTREE))
#define PM_SIZE                    8
#define TAB_SIZE                   (PM_SIZE + 6)
#define CELL_SPACING               1
#define CLIST_OPTIMUM_SIZE         64
#define COLUMN_INSET               3
#define DRAG_WIDTH                 6
#define ROW_TOP_YPIXEL(clist, row) (((clist)->row_height * (row)) + \
                                    (((row) + 1) * CELL_SPACING) + \
                                    (clist)->voffset)
#define ROW_FROM_YPIXEL(clist, y)  (((y) - (clist)->voffset) / \
                                    ((clist)->row_height + CELL_SPACING))
#define COLUMN_LEFT_XPIXEL(clist, col)  ((clist)->column[(col)].area.x \
                                    + (clist)->hoffset)

/*
 * These are the indices for the toggle items in the file menu. If
 * you change the file menus, these macros MUST be updated to reflect
 * the changes.
 */
#define FILE_MENU_TOGGLE_INDEX_MENUBAR 5 
#define FILE_MENU_TOGGLE_INDEX_TOOLBAR 6
#define FILE_MENU_TOGGLE_INDEX_BUTTONBAR 7

