/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: main.c,v 3.3 2001/10/29 17:26:12 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>

#include	"murasaki.h"
#include	"env.h"

int debug;	/* debug flag */

int
main(int argc,char **argv)
{
	struct mu_op *opp = &mu_op;

	if (argc > 1) {
		fprintf(stderr,"murasaki version %s\n",MU_VERSION);
		exit(0);
	}

	openlog(opp->command,LOG_PID|LOG_CONS,LOG_DAEMON);
	if (getenv("MURASAKI_DEBUG"))
		debug=1;

	DPRINTF(LOG_CONS,"path = \"%s\"",getenv("PATH"));
	if (opp->get_info)
		opp->get_info();
	switch(get_action()) {
	case ACTION_ADD:
		opp->run(opp,ACTION_ADD);
		break;
	case ACTION_REMOVE:
		opp->run(opp,ACTION_REMOVE);
		break;
	default:
		syslog(LOG_LEVEL,"illegal action");
		break;
	}
#ifdef	KERNEL_JOB
	closelog();
	if (opp->end)
		opp->end(opp);
#endif	/* KERNEL_JOB */
	return 0;
}
