/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: match.c,v 3.4 2001/10/29 17:36:30 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>

#include	"murasaki.h"
#include	"env.h"

#define PCI_ANY_ID (~0)		/* from linux/pci.h */

#define	CHAR_COMMENT	'#'
#define	CHAR_RSEP		'\n'

#define	ST_COMMENT		255
#define	ST_SKIP			(ST_COMMENT - 1)
#define	ST_MODULE		1
#define	ST_VENDOR		(ST_MODULE + 1)
#define	ST_DEVICE		(ST_VENDOR + 1)
#define	ST_SUB_VENDOR	(ST_DEVICE + 1)
#define	ST_SUB_DEVICE	(ST_SUB_VENDOR + 1)
#define	ST_CLASS		(ST_SUB_DEVICE + 1)
#define	ST_CLASS_MASK	(ST_CLASS + 1)
#define	ST_DRIVER_DATA	(ST_CLASS_MASK + 1)

static int
real_match(MU_pci_config_t *active,MU_pci_config_t *map)
{
	if (active->id.vendor || active->sub_id.vendor || active->class_mask) {
	DPRINTF(LOG_LEVEL,"vendor:0x%x device:0x%x subvendor:0x%x subdevice:0x%x class:0x%x class_mask:0x%x",
		map->id.vendor,map->id.device,
		map->sub_id.vendor,map->sub_id.device,
		map->class,map->class_mask);
        if ((map->id.vendor == PCI_ANY_ID || active->id.vendor == map->id.vendor) &&
            (map->id.device == PCI_ANY_ID || active->id.device == map->id.device) &&
            (map->sub_id.vendor == PCI_ANY_ID || active->sub_id.vendor == map->sub_id.vendor) &&
            (map->sub_id.device == PCI_ANY_ID || active->sub_id.device == map->sub_id.device) &&
            !((active->class ^ map->class) & map->class_mask))
		return GOOD;
	}
	return INVALID;
}

int
match_config(char **list,char *start,char *end,void *conf)
{
	MU_pci_config_t *config = conf;
	MU_pci_config_t map;
	char *ptr,*module,*module_start,*module_end = NULL;
	int status = ST_MODULE;
	unsigned int value,len;
	char *fwdp;
	int mod_count = 0;

	DPRINTF(LOG_LEVEL,"match_config:vendor:0x%x device:0x%x subvendor:0x%x subdevice 0x%x class:0x%x class_mask:0x%x(ignore)",
		config->id.vendor,config->id.device,
		config->sub_id.vendor,config->sub_id.device,
		config->class,config->class_mask);
	for(module_start = ptr = start; ptr < end;ptr++) {
		if (status == ST_COMMENT) {
			while(*ptr != CHAR_RSEP) {
				if (ptr >= end)
					goto error_return;
				ptr++;
			}
			status = ST_MODULE;
			continue;
		} else if (*ptr == CHAR_COMMENT) {
			status = ST_COMMENT;
			continue;
		}
		if (status == ST_MODULE) {
			module_start = ptr;
			while(*ptr != ' ' && *ptr != '\t') {
				if (ptr >= end)
					goto error_return;
				ptr++;
			}
			module_end = ptr;
		} else {
			value = (unsigned int)strtoul(ptr,&fwdp,0);
			ptr = fwdp;
			switch(status) {
			case ST_VENDOR:
				map.id.vendor = value;
				break;
			case ST_DEVICE:
				map.id.device = value;
				break;
			case ST_SUB_VENDOR:
				map.sub_id.vendor = value;
				break;
			case ST_SUB_DEVICE:
				map.sub_id.device = value;
				break;
			case ST_CLASS:
				map.class = value;
				break;
			case ST_CLASS_MASK:
				map.class_mask = value;
				break;
			case ST_DRIVER_DATA:	/* ignore */
				status = ST_MODULE;
				if (real_match(config,&map) == GOOD) {
					len = module_end - module_start;
					module = malloc(len+1);
					if (module == NULL)
						goto error_return;
					memcpy(module,module_start,len);
					module[len] = '\0';
					syslog(LOG_LEVEL,"MATCH(%s) -> vendor:0x%x device:0x%x subvendor:0x%x subdevice 0x%x class:0x%x class_mask:0x%x",
						module,
						map.id.vendor,map.id.device,
						map.sub_id.vendor,map.sub_id.device,
						map.class,map.class_mask);
					if (add_to_list(list,module,LIST_MAX) == INVALID)
						goto error_return;
					mod_count++;
				}
				continue;
			default:
				goto error_return;
			}
		}
		status++;
	}
	return mod_count;

error_return:
	return INVALID;
}

