/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 3.2 2001/10/29 17:39:13 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"env.h"

MU_pci_config_t config;

static void
get_info_pci(void)
{
	if (get_id_pci_class(&config) == INVALID)
		exit(1);
	if (get_id_pci_id(&config) == INVALID)
		exit(1);
	if (get_id_pci_slot(&config) == INVALID)
		exit(1);
}

static void
end_pci(struct mu_op *opp)
{
	free(((MU_pci_config_t *)opp->config)->slot);
}

struct mu_op mu_op = {
	command: MU_PCI,
	mappath: MU_CONF_DIR "/" MU_PCIMAP,
	default_mapname: MU_DEFAULT_PCIMAP,
	config: &config,
	get_info: get_info_pci,
	run: load_module,
	end: end_pci,
};
