//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audiomix.h,v 1.2 2001/11/20 15:19:31 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AUDIOMIX_H__
#define __AUDIOMIX_H__

#include <list>
#include "audionode.h"

#ifndef AUDIO_CHANNELS
#define AUDIO_CHANNELS 2  // stereo
#endif

//---------------------------------------------------------
//   AudioFifo
//---------------------------------------------------------

class AudioFifo : public AudioNode {
      float** data;
      int head;
      int tail;
      int size;
      int used;

   public:
      AudioFifo() {
            data = 0;
            };
      ~AudioFifo();
      void setup(int buffers, int bsize);
      float* getFreeBuffer();
      void writeBuffer();
      virtual void getData(float* buffer, int idx);
      };

typedef std::list<AudioNode*> AudioNodeList;
typedef AudioNodeList::iterator iAudioNode;

//---------------------------------------------------------
//   AudioMixer
//---------------------------------------------------------

class AudioMixer : public AudioNode {
      AudioNodeList inputs;
      virtual void getData(float* buffer, int);

   public:
      AudioMixer();
      virtual ~AudioMixer();

      virtual void connect(AudioNode* as);
      virtual void disconnect(AudioNode* as);
      };

#endif
