//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: lmaster.h,v 1.2 2001/11/20 15:19:33 muse Exp $
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __LMASTER_EDIT_H__
#define __LMASTER_EDIT_H__

#include <qwidget.h>
#include "midieditor.h"
#include "noteinfo.h"
#include "cobject.h"
#include <qmainwindow.h>

class QToolButton;
class QListView;
class QListViewItem;
class SigEvent;
class TEvent;

//---------------------------------------------------------
//   LMaster
//---------------------------------------------------------

class LMaster : public MidiEditor {
      QListView* view;
      QToolBar* tools;

      Q_OBJECT
      virtual void closeEvent(QCloseEvent*);
      void updateList();
      void insertTempo(const TEvent*);
      void insertSig(const SigEvent*);

   private slots:
      void select(QListViewItem*);

   public slots:
      void songChanged(int);

   signals:
      void deleted(int);

   public:
      LMaster();
      ~LMaster();
      virtual void readStatus(Xml&);
      virtual void writeStatus(int, Xml&) const;
      };

#endif

