//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: sfendian.h,v 1.2 2001/11/20 15:19:34 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//  based on libsndfile:
//  Copyright (C) 1999-2000 Erik de Castro Lopo <erikd@zip.com.au>
//=========================================================

#include	<endian.h>
	#if (__BYTE_ORDER == __LITTLE_ENDIAN)
		#define	CPU_IS_LITTLE_ENDIAN		1
		#define	CPU_IS_BIG_ENDIAN			0
	#elif (__BYTE_ORDER == __BIG_ENDIAN)
		#define	CPU_IS_LITTLE_ENDIAN		0
		#define	CPU_IS_BIG_ENDIAN			1
	#else
		#error "A bit confused about endian-ness! Have <endian.h> but not __BYTEORDER."
	#endif

#define		ENDSWAP_SHORT(x)			((((x)>>8)&0xFF)|(((x)&0xFF)<<8))
#define		ENDSWAP_INT(x)				((((x)>>24)&0xFF)|(((x)>>8)&0xFF00)|(((x)&0xFF00)<<8)|(((x)&0xFF)<<24))

#if (CPU_IS_LITTLE_ENDIAN == 1)
	#define	H2LE_SHORT(x)				(x)
	#define	H2LE_INT(x)					(x)
	#define	LE2H_SHORT(x)				(x)
	#define	LE2H_INT(x)					(x)

	#define	BE2H_INT(x)					ENDSWAP_INT(x)
	#define	BE2H_SHORT(x)				ENDSWAP_SHORT(x)
	#define	H2BE_INT(x)					ENDSWAP_INT(x)
	#define	H2BE_SHORT(x)				ENDSWAP_SHORT(x)

#elif (CPU_IS_BIG_ENDIAN == 1)
	#define	H2LE_SHORT(x)				ENDSWAP_SHORT(x)
	#define	H2LE_INT(x)					ENDSWAP_INT(x)
	#define	LE2H_SHORT(x)				ENDSWAP_SHORT(x)
	#define	LE2H_INT(x)					ENDSWAP_INT(x)

	#define	BE2H_INT(x)					(x)
	#define	BE2H_SHORT(x)				(x)
	#define	H2BE_INT(x)					(x)
	#define	H2BE_SHORT(x)				(x)

#else
	#error "Cannot determine endian-ness of processor."
#endif

