//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: tempolabel.h,v 1.3 2002/01/03 10:51:54 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __TEMPOLABEL_H__
#define __TEMPOLABEL_H__

#include <qlabel.h>
#include <qspinbox.h>

//---------------------------------------------------------
//   TempoLabel
//---------------------------------------------------------

class TempoLabel : public QLabel {
      double _value;

      Q_OBJECT

   protected:
      QSize sizeHint() const;

   public slots:
      void setValue(int);
      void setValue(double);

   public:
      TempoLabel(QWidget*, const char* name = 0);
      };

//---------------------------------------------------------
//   TempoSpinbox
//---------------------------------------------------------

class TempoSpinBox : public QSpinBox {
      Q_OBJECT

   protected:
      QSize sizeHint() const;
      virtual QString mapValueToText(int);
      virtual int mapTextToValue(bool*);

   private slots:
      void tempoChanged(int);

   public slots:
      void setValue(double);

   signals:
      void valueChanged(double);

   public:
      TempoSpinBox(QWidget*, const char* name = 0);
      };

#endif

