/***************************************************************************
                          packet.h  -  description
                             -------------------
    begin                : Thu May 31 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#if !defined(__PACKET_H_INCLUDED__)
#define __PACKET_H_INCLUDED__

#include "byteorder.h"

class MGnuNode;

struct Node
{
	IP   Host;
	UINT Port;

	UINT Ping;
	UINT Speed;
	BYTE Distance;

	DWORD ShareSize;
	DWORD ShareCount;
	
	std::vector<Node*> Friends;
	
	const Node& operator=(const Node& orig){
		Host = orig.Host;
		Port = orig.Port;
		Ping = orig.Ping;
		Speed = orig.Speed;
		Distance = orig.Distance;
		ShareSize = orig.ShareSize;
		ShareCount = orig.ShareCount;
		Friends = orig.Friends;
		return *this;
	}
	Node() :
		Port(0),
		Ping(0),
		Speed(0),
		Distance(0),
		ShareSize(0),
		ShareCount(0)
	{
		Host.S_addr = 0;
	}
	Node(const Node& orig) :
		Host(orig.Host),
		Port(orig.Port),
		Ping(orig.Ping),
		Speed(orig.Speed),
		Distance(orig.Distance),
		ShareSize(orig.ShareSize),
		ShareCount(orig.ShareCount),
		Friends(orig.Friends)
	{}
};

/////////////////////////////////////////////////////////////////////////////
// Gnutella packets

#pragma pack (1)

struct packet_Header		// Size 23
{
	GUID  Guid;					// 0  - 15
	BYTE  Function;				// 16
	BYTE  TTL;					// 17
	BYTE  Hops;					// 18
	LE(DWORD) le_Payload;		// 19 - 22
};


struct packet_Ping			// Size 23
{
	packet_Header Header;		// 0  - 22	
};


struct packet_Pong				// Size 37
{
	packet_Header Header;		// 0  - 22
	LE(WORD)      le_Port;		// 23 - 24
	IP            Host;			// 25 - 28
	LE(DWORD)     le_FileCount;	// 29 - 32
	LE(DWORD)     le_FileSize;	// 33 - 36
};


struct packet_Query			// Size 26+
{		
	packet_Header Header;		// 0  - 22
	LE(WORD)      le_Speed;		// 23 - 24
	// Search					// 25+
};


struct packet_QueryHit		// Size 35+
{
	packet_Header Header;		// 0  - 22
	BYTE          TotalHits;	// 23
	LE(WORD)      le_Port;		// 24 - 25
	IP            Host;			// 26 - 29
	LE(DWORD)     le_Speed;		// 30 - 33
	// QueryHitItem				// 34+
	
	// QueryHit Descriptor

	// ClientGuid				// Last 16 bytes
};

struct packet_QueryHitItem	// Size 9+
{
	LE(DWORD) le_Index;				// 0  - 3
	LE(DWORD) le_Size;				// 4  - 7
	// FileName						// 8+	
};

struct packet_QueryHitEx	    // Size 6+
{
	BYTE VendorID[4];			// 0  - 3
	BYTE Length;				// 4

	// Public Sector
	unsigned	FlagPush	 : 1; // 5
	unsigned	FlagBad 	 : 1;
	unsigned	FlagBusy	 : 1;
	unsigned	FlagStable   : 1;
	unsigned	FlagSpeed	 : 1;
	unsigned    FlagTrash    : 3;

	unsigned    Push		 : 1; // 6
	unsigned	Bad			 : 1;
	unsigned	Busy		 : 1;
	unsigned	Stable  	 : 1;
	unsigned	Speed		 : 1;
	unsigned    Trash		 : 3;

	// Private Sector
	//BYTE bug1;
	//BYTE bug2;
};

struct packet_Push			// Size 49
{
	packet_Header Header;		// 0  - 22;
	GUID          ServerID;		// 23 - 38
	LE(DWORD)     le_Index;		// 39 - 42
	IP            Host;			// 43 - 46
	LE(WORD)      le_Port;		// 47 - 48
};

#pragma pack ()

#endif // __PACKET_H_INCLUDED__


