// randomnoise.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// A modification of unix rand() to return floating point values between
// + and - 1, and wrapped for C++.  Used for dithered rescaling of floating
// point numbers, and for LPC resynthesis.

#ifndef RANDOMNOISE_H
#define RANDOMNOISE_H

class RandomNoise {
public:
	RandomNoise(unsigned seed=1, double amp=1.0)
		: mySeed(seed), amplitude(amp) {}
	double operator () (void) {
		int i = ((mySeed = mySeed*1103515245 + 12345)>>16) & 077777;
		return amplitude * ((double)i/16384. - 1.);
	}
	void setGain(double gain) { amplitude = gain; }
	void setSeed(unsigned seed) { mySeed = seed; }
private:
	unsigned mySeed;
	double amplitude;
};

#endif
