/***************************************************************************
                          mytest3.h  -  description
                             -------------------
    begin                : Wed Aug 8 2001
    copyright            : (C) 2001 by Venu, MySQL AB
    email                : venu@mysql.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __TMYODBC__TEST__H
#define __TMYODBC__TEST__H

#ifdef HAVE_CONFIG_H
#include <myconf.h>
#endif

#ifdef WIN32
#include <windows.h>
#endif 

#ifndef MY_DEBUG
#define MY_DEBUG
#endif

/* STANDARD C HEADERS */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

/* ODBC HEADERS */
#include <sql.h>
#include <sqlext.h>

/* for clock() */
#include <time.h> 

#ifndef NULL
#define NULL 0
#endif

#ifndef ushort
#define ushort unsigned short
#endif

#ifndef bool
#define bool unsigned char
#endif

#ifndef true
#define true 1
#endif

#ifndef false
#define false 0
#endif

#ifndef my_assert
#define my_assert assert
#endif

#ifndef myassert
#define myassert assert
#endif

#ifndef Sleep
#define Sleep _sleep
#endif

#ifdef MY_DEBUG
#define myprintf printf
#else
#define myprintf
#endif

#define MAX_NAME_LEN 255
#define MAX_COLUMNS 500
#define MAX_ROW_DATA_LEN 1000
#define MYSQL_NAME_LEN 64

SQLCHAR *mydsn = "myodbc3";
SQLCHAR *myuid = "root";
SQLCHAR *mypwd = "";
SQLCHAR *myserver = "localhost";
SQLCHAR *mydb     = "test";
SQLCHAR *test_db= "client_odbc_test";

SQLCHAR init_db[3][100]=
{
  "DROP DATABASE IF EXISTS client_odbc_test",
  "CREATE DATABASE client_odbc_test",
  "USE client_odbc_test"
};

/* PROTOTYPE */
void myerror(SQLRETURN rc,SQLSMALLINT htype, SQLHANDLE handle);

#define my_error() fprintf(stdout," ERROR occured at %d@%s\n",__LINE__,__FILE__)

SQLUINTEGER myresult(SQLHSTMT hstmt);

/* UTILITY MACROS */
#define myenv(henv,r)  \
        if ( ((r) != SQL_SUCCESS) ) \
            myerror(r, 1,henv); \
        my_assert( ((r) == SQL_SUCCESS) || ((r) == SQL_SUCCESS_WITH_INFO) )

#define myenv_r(henv,r)  \
        if ( r == SQL_ERROR ) \
            myerror(r, 1, henv); \
        my_assert( r == SQL_ERROR )

#define myenv_err(henv,r,rc)  \
        if ( rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO ) \
            myerror(rc, 1, henv); \
        my_assert( r )

#define mycon(hdbc,r)  \
        if ( ((r) != SQL_SUCCESS) ) \
            myerror(r, 2, hdbc); \
        my_assert( ((r) == SQL_SUCCESS) || ((r) == SQL_SUCCESS_WITH_INFO) )

#define mycon_r(hdbc,r)  \
        if ( r == SQL_ERROR ) \
            myerror(r, 2, hdbc); \
        my_assert(rc==SQL_ERROR)

#define mycon_err(hdbc,r,rc)  \
        if ( rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO ) \
            myerror(rc, 2, hdbc); \
        my_assert( r )

#define mystmt(hstmt,r)  \
        if ( ((r) != SQL_SUCCESS) ) \
            myerror(r, 3, hstmt); \
        my_assert( ((r) == SQL_SUCCESS) || ((r) == SQL_SUCCESS_WITH_INFO) )

#define mystmt_r(hstmt,r)  \
        if ( r == SQL_ERROR ) \
            myerror(r, 3, hstmt); \
        my_assert( r == SQL_ERROR )

#define mystmt_err(hstmt,r,rc)  \
        if ( rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO ) \
            myerror(rc, 3, hstmt); \
        my_assert( r )

#define myheader(str) { fprintf(stdout,"\n\n######################################\n"); \
                        fprintf(stdout,"%s", str); \
                        fprintf(stdout,"\n######################################\n"); \
                      }
#define IS_NUM(t) (if
/**
ERROR HANDLER
*/
void myerror(SQLRETURN rc, SQLSMALLINT htype, SQLHANDLE handle)
{
  RETCODE lrc;

  if( rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO ) 
  {
    SQLCHAR      szSqlState[6],szErrorMsg[SQL_MAX_MESSAGE_LENGTH];
    SQLINTEGER   pfNativeError;
    SQLSMALLINT  pcbErrorMsg;
    
    lrc = SQLGetDiagRec(htype, handle,1,    
                        (SQLCHAR *)&szSqlState,
                        (SQLINTEGER *)&pfNativeError,
                        (SQLCHAR *)&szErrorMsg,
                         SQL_MAX_MESSAGE_LENGTH-1,
                        (SQLSMALLINT *)&pcbErrorMsg);
    if(lrc == SQL_SUCCESS || lrc == SQL_SUCCESS_WITH_INFO)
      fprintf(stdout,"\n [%s]%s\n",szSqlState,szErrorMsg);
    else 
      fprintf(stdout," SQLError returned :%d, but rc = %d\n",lrc,rc);
  }
}

/**
  CONNECTION
*/
void myconnect(SQLHENV *henv,SQLHDBC *hdbc, SQLHSTMT *hstmt)
{
  SQLRETURN rc;

    rc = SQLAllocHandle(SQL_HANDLE_ENV,SQL_NULL_HANDLE,henv);
    myenv(*henv,rc);   
  
    rc = SQLSetEnvAttr(*henv,SQL_ATTR_ODBC_VERSION,(SQLPOINTER)SQL_OV_ODBC3,0);
    myenv(*henv,rc);   

    rc = SQLAllocHandle(SQL_HANDLE_DBC,*henv, hdbc);
    myenv(*henv,rc);    

    fprintf(stdout," Connecting to '%s' with user name '%s'...\n",mydsn,myuid);
    rc = SQLConnect(*hdbc, mydsn, SQL_NTS, myuid, SQL_NTS,  mypwd, SQL_NTS);
    mycon(*hdbc,rc);

    rc = SQLSetConnectAttr(*hdbc,SQL_ATTR_AUTOCOMMIT,(SQLPOINTER)SQL_AUTOCOMMIT_ON,0);
    mycon(*hdbc,rc);

    rc = SQLAllocHandle(SQL_HANDLE_STMT,*hdbc,hstmt);
    mycon(*hdbc,rc);

    {
      int i;
      for (i=0; i< sizeof(init_db)/sizeof(init_db[0]); i++)
        SQLExecDirect(*hstmt, (SQLCHAR *)init_db[i], SQL_NTS);
    }
    SQLFreeStmt(*hstmt, SQL_CLOSE);
    SQLSetStmtAttr(*hstmt,SQL_ATTR_CURSOR_TYPE,(SQLPOINTER)SQL_CURSOR_STATIC,0);
    SQLSetStmtOption(*hstmt,SQL_SIMULATE_CURSOR,SQL_SC_NON_UNIQUE);
    SQLSetStmtOption(*hstmt, SQL_CURSOR_TYPE, SQL_CURSOR_KEYSET_DRIVEN);
}
/**
  DRV CONNECTION
*/
void mydrvconnect(SQLHENV *henv,SQLHDBC *hdbc, SQLHSTMT *hstmt,SQLCHAR *connIn)
{
  SQLRETURN rc;
  SQLCHAR   connOut[MAX_NAME_LEN];

    rc = SQLAllocHandle(SQL_HANDLE_ENV,SQL_NULL_HANDLE,henv);
    myenv(*henv,rc);   
  
    rc = SQLSetEnvAttr(*henv,SQL_ATTR_ODBC_VERSION,(SQLPOINTER)SQL_OV_ODBC3,0);
    myenv(*henv,rc);   

    rc = SQLAllocHandle(SQL_HANDLE_DBC,*henv, hdbc);
    myenv(*henv,rc);    

    fprintf(stdout," Connecting to '%s' \n",connIn);
    rc = SQLDriverConnect(*hdbc,NULL,connIn,MAX_NAME_LEN,
                          connOut,MAX_NAME_LEN,NULL,SQL_DRIVER_COMPLETE);
    mycon(*hdbc,rc);
    fprintf(stdout,"\n output connection string: %s", connOut);

    rc = SQLSetConnectAttr(*hdbc,SQL_ATTR_AUTOCOMMIT,(SQLPOINTER)SQL_AUTOCOMMIT_ON,0);
    mycon(*hdbc,rc);

    rc = SQLAllocHandle(SQL_HANDLE_STMT,*hdbc,hstmt);
    mycon(*hdbc,rc);

    {
      int i;
      for (i=0; i< sizeof(init_db)/sizeof(init_db[0]); i++)
        SQLExecDirect(*hstmt, (SQLCHAR *)init_db[i], SQL_NTS);
    }
    SQLFreeStmt(*hstmt, SQL_CLOSE);
    SQLSetStmtAttr(*hstmt,SQL_ATTR_CURSOR_TYPE,(SQLPOINTER)SQL_CURSOR_STATIC,0);
    SQLSetStmtOption(*hstmt,SQL_SIMULATE_CURSOR,SQL_SC_NON_UNIQUE);
    SQLSetStmtOption(*hstmt, SQL_CURSOR_TYPE, SQL_CURSOR_KEYSET_DRIVEN);
}
/**
  DISCONNECT
*/
void mydisconnect(SQLHENV *henv,SQLHDBC *hdbc, SQLHSTMT *hstmt)
{
  SQLRETURN rc;

    SQLExecDirect(*hstmt, (SQLCHAR *)init_db[0], SQL_NTS);
    SQLFreeStmt(*hstmt, SQL_CLOSE);

    rc = SQLEndTran(SQL_HANDLE_DBC, *hdbc, SQL_COMMIT);
    mycon(*hdbc, rc);

    rc = SQLFreeStmt(*hstmt, SQL_DROP);
    mystmt(*hstmt,rc);

    rc = SQLDisconnect(*hdbc);
    mycon(*hdbc,rc);

    rc = SQLFreeConnect(*hdbc);
    mycon(*hdbc,rc);

    rc = SQLFreeEnv(*henv);
    myenv(*henv,rc);
}
/**
  Print resultset dashes
*/
static void my_print_dashes(SQLHSTMT hstmt, SQLSMALLINT nCol)
{
  SQLRETURN  rc;
  SQLINTEGER field_count, disp_size, nullable;
  SQLCHAR    ColName[MAX_NAME_LEN+1];
  SQLUSMALLINT i, j;
  SQLSMALLINT  col_len;

  field_count= (SQLINTEGER)nCol;
  fputc('\t',stdout);
  fputc('+', stdout);

  for(i=1; i<= field_count; i++)
  {
    nullable = 0;
    rc = SQLColAttribute(hstmt,i,SQL_DESC_BASE_COLUMN_NAME,&ColName,
                         MAX_NAME_LEN,&col_len,NULL);
    mystmt(hstmt,rc);
    rc = SQLColAttribute(hstmt,i,SQL_DESC_DISPLAY_SIZE,NULL,0,
                         NULL,&disp_size);
    mystmt(hstmt,rc);
    rc = SQLColAttribute(hstmt,i,SQL_DESC_NULLABLE,NULL,0,
                         NULL,&nullable);
    mystmt(hstmt,rc);
    
    if (disp_size < col_len)
      disp_size = col_len;
    if (disp_size < 4 && nullable)
      disp_size = 4;
    for(j=1; j < disp_size+3; j++)
      fputc('-',stdout);
    fputc('+',stdout);
  }
  fputc('\n',stdout);
}
static void my_print_data(SQLHSTMT hstmt, SQLUSMALLINT index,
                          SQLCHAR *data, SQLINTEGER length)
{
  SQLRETURN  rc;
  SQLINTEGER disp_size, nullable;
  SQLCHAR    ColName[MAX_NAME_LEN+1];
  SQLSMALLINT col_len;

    nullable = 0;
    rc = SQLColAttribute(hstmt,index,SQL_DESC_BASE_COLUMN_NAME,&ColName,
                         MAX_NAME_LEN,&col_len,NULL);
    mystmt(hstmt,rc);
    rc = SQLColAttribute(hstmt,index,SQL_DESC_DISPLAY_SIZE,NULL,0,
                         NULL,&disp_size);
    mystmt(hstmt,rc);
    rc = SQLColAttribute(hstmt,index,SQL_DESC_NULLABLE,NULL,0,
                         NULL,&nullable);
    mystmt(hstmt,rc);

    if (disp_size < length)
      disp_size = length;
    if (disp_size < col_len)
      disp_size = col_len;
    if (disp_size < 4 && nullable)
      disp_size = 4;
    if (length == SQL_NULL_DATA)
      fprintf(stdout,"%-*s  |",disp_size, "NULL");
    else
      fprintf(stdout,"%-*s  |",disp_size,data);
}
/**
RESULT SET
*/
int my_print_non_format_result(SQLHSTMT hstmt)
{
  SQLRETURN   rc;
  SQLUINTEGER nRowCount=0, pcColDef;
  SQLCHAR     szColName[MAX_NAME_LEN];
  SQLCHAR     szData[MAX_COLUMNS][MAX_ROW_DATA_LEN]={0};
  SQLSMALLINT nIndex,ncol,pfSqlType, pcbScale, pfNullable;

  rc = SQLNumResultCols(hstmt,&ncol);
  mystmt(hstmt,rc);

  myprintf("\n");

  for(nIndex = 1; nIndex <= ncol; nIndex++)
  {
    rc = SQLDescribeCol(hstmt,nIndex,szColName, MAX_NAME_LEN+1, NULL,
                        &pfSqlType,&pcColDef,&pcbScale,&pfNullable);
    mystmt(hstmt,rc);

    myprintf("%s\t",szColName);

    rc = SQLBindCol(hstmt,nIndex, SQL_C_CHAR, szData[nIndex-1],
                    MAX_ROW_DATA_LEN+1,NULL);
    mystmt(hstmt,rc);
  }

  myprintf("\n------------------------------------------------------\n");

  rc = SQLFetch(hstmt);
  while(rc == SQL_SUCCESS || rc == SQL_SUCCESS_WITH_INFO)
  {
     nRowCount++;
     for(nIndex=0; nIndex< ncol; nIndex++)
       myprintf("%s\t",szData[nIndex]);

     myprintf("\n");
     rc = SQLFetch(hstmt);
   }

   SQLFreeStmt(hstmt,SQL_UNBIND);
   SQLFreeStmt(hstmt,SQL_CLOSE);

   fprintf(stdout,"\n Total rows fetched: %d\n",nRowCount);
   return(nRowCount);
}

/**
  RESULT SET
*/
SQLUINTEGER myresult(SQLHSTMT hstmt)
{
  SQLRETURN   rc;
  SQLUINTEGER nRowCount;
  SQLCHAR     ColName[MAX_NAME_LEN+1];
  SQLCHAR     Data[MAX_ROW_DATA_LEN+1];
  SQLINTEGER  size, pcbLength;
  SQLUSMALLINT nIndex;
  SQLSMALLINT  ncol;

  rc = SQLNumResultCols(hstmt,&ncol);
  mystmt(hstmt,rc);

  if (ncol > 10)
   return my_print_non_format_result(hstmt);

  fputc('\n',stdout);
  my_print_dashes(hstmt, ncol);
  fputc('\t',stdout);
  fputc('|', stdout);

  for (nIndex = 1; nIndex <= ncol; nIndex++)
  {
    rc = SQLColAttribute(hstmt,nIndex,SQL_DESC_BASE_COLUMN_NAME,ColName,MAX_NAME_LEN,
                         NULL,NULL);
    mystmt(hstmt,rc);
    my_print_data(hstmt,nIndex,ColName,0);
  }
  fputc('\n',stdout);
  my_print_dashes(hstmt, ncol);

  nRowCount= 0;

  rc = SQLFetch(hstmt);
  while (rc == SQL_SUCCESS || rc == SQL_SUCCESS_WITH_INFO)
  {
     nRowCount++;
     fputc('\t',stdout);
     fputc('|', stdout);

     for(nIndex=1; nIndex<= ncol; nIndex++)
     {
       rc = SQLColAttribute(hstmt,nIndex,SQL_DESC_DISPLAY_SIZE,NULL,0,
                         NULL,&size);
       mystmt(hstmt,rc);
       rc = SQLGetData(hstmt, nIndex, SQL_C_CHAR, Data,
                       MAX_ROW_DATA_LEN,&pcbLength);
       mystmt(hstmt,rc);
       my_print_data(hstmt, nIndex, Data, pcbLength);
     }
     fputc('\t',stdout);
     fputc('\n', stdout);
     rc = SQLFetch(hstmt);
   }
   my_print_dashes(hstmt,ncol);
   SQLFreeStmt(hstmt,SQL_UNBIND);
   SQLFreeStmt(hstmt,SQL_CLOSE);

   fprintf(stdout,"\n Total rows fetched: %d\n",nRowCount);
   return nRowCount;
}

/**
  ROWCOUNT
*/
SQLUINTEGER myrowcount(SQLHSTMT hstmt)
{
  SQLRETURN   rc;
  SQLUINTEGER nRowCount= 0;

  rc = SQLFetch(hstmt);
  while(rc == SQL_SUCCESS || rc == SQL_SUCCESS_WITH_INFO)
  {
     nRowCount++;
     rc = SQLFetch(hstmt);
  }
  SQLFreeStmt(hstmt,SQL_UNBIND);
  fprintf(stdout,"\n Total rows fetched: %d",nRowCount);
  return(nRowCount);
}
/**
  SQLExecDirect
*/
SQLRETURN tmysql_exec(SQLHSTMT hstmt, SQLCHAR *sql_stmt)
{
  return(SQLExecDirect(hstmt,(SQLCHAR *)sql_stmt,SQL_NTS));
}
/**
  SQLPrepare
*/
SQLRETURN tmysql_prepare(SQLHSTMT hstmt, SQLCHAR *sql_stmt)
{
  return(SQLPrepare(hstmt,sql_stmt,SQL_NTS));
}
/**
  return integer data by fetching it
*/
SQLINTEGER my_fetch_int(SQLHSTMT hstmt, SQLUSMALLINT irow)
{
  SQLINTEGER nData;

  SQLGetData(hstmt,irow,SQL_INTEGER,&nData,0,NULL);
  fprintf(stdout," my_fetch_int: %d\n",nData);
  return(nData);
}
/**
  return string data, by fetching it
*/
const char *my_fetch_str(SQLHSTMT hstmt, SQLCHAR *szData,SQLUSMALLINT irow)
{
  SQLINTEGER nLen=0;

  SQLGetData(hstmt,irow,SQL_CHAR,szData,MAX_ROW_DATA_LEN+1,&nLen);
  fprintf(stdout," my_fetch_str: %s(%d)\n",szData,nLen);
  return((const char *)szData);
}

/*
  Check if server running is MySQL
*/
bool server_is_mysql(SQLHDBC hdbc)
{
  SQLCHAR driver_name[MYSQL_NAME_LEN];

  SQLGetInfo(hdbc,SQL_DRIVER_NAME,driver_name,MYSQL_NAME_LEN,NULL);
  
  if (strncmp(driver_name,"myodbc",6) >= 0 || strncmp(driver_name,"libmyodbc",9) >= 0)
    return true;

  return false;
}

/*
  Check if driver supports SQLSetPos
*/
bool driver_supports_setpos(SQLHDBC hdbc)
{
  SQLRETURN    rc;
  SQLUSMALLINT status= true;

  rc = SQLGetFunctions(hdbc, SQL_API_SQLSETPOS, &status);
  mycon(hdbc,rc);

  if (!status)
    return false;
  return true;
}

/*
  Check if driver supports SQLSetPos
*/
bool driver_supports_positioned_ops(SQLHDBC hdbc)
{
  SQLRETURN    rc;
  SQLINTEGER status;

  rc = SQLGetInfo(hdbc, SQL_POS_OPERATIONS, &status, 0, NULL);
  mycon(hdbc,rc);

  if (status & (SQL_POS_UPDATE || SQL_POS_DELETE))
    return true;
  return false;
}

/*
  Check for minimal MySQL version
*/
bool mysql_min_version(SQLHDBC hdbc, SQLCHAR *min_version, unsigned int length)
{
  SQLCHAR server_version[MYSQL_NAME_LEN];
  SQLRETURN rc;

  if (!server_is_mysql(hdbc))
    return true;

  rc = SQLGetInfo(hdbc,SQL_DBMS_VER,server_version,MYSQL_NAME_LEN,NULL);
  mycon(hdbc, rc);

  if (strncmp(server_version, min_version, length) >= 0)
    return true;
  
  return false;
}

/*
  Check for minimal Connector/ODBC version
*/
bool driver_min_version(SQLHDBC hdbc, SQLCHAR *min_version, unsigned int length)
{
  SQLCHAR driver_version[MYSQL_NAME_LEN];
  SQLRETURN rc;

  if (!server_is_mysql(hdbc))
    return true;

  rc = SQLGetInfo(hdbc,SQL_DRIVER_VER,driver_version,MYSQL_NAME_LEN,NULL);
  mycon(hdbc, rc);

  if (strncmp(driver_version, min_version, length) >= 0)
    return true;
  
  return false;
}

/*
  Check if server supports transactions
*/
bool server_supports_trans(SQLHDBC hdbc)
{
  SQLSMALLINT trans;
  SQLRETURN   rc;

  rc = SQLGetInfo(hdbc,SQL_TXN_CAPABLE,&trans,0,NULL);
  mycon(hdbc,rc);
  
  if (trans != SQL_TC_NONE)
    return true;
  return false;
}

/*
  Check if server supports GRANT
*/
bool server_supports_grant(SQLHSTMT hstmt)
{
  SQLRETURN   rc;

  rc = SQLExecDirect(hstmt,"GRANT ALL ON *.* TO 'junk_test_odbc_usr'",SQL_NTS);
  if (rc == SQL_ERROR)
  {
    SQLINTEGER native_err;

    rc = SQLGetDiagField(SQL_HANDLE_STMT,hstmt,1,SQL_DIAG_NATIVE,&native_err,0,NULL);
    mystmt(hstmt,rc);

    if (native_err == 1047) /* command not found */
      return false;
  }
  SQLExecDirect(hstmt,"DELETE FROM mysql.user WHERE User='junk_test_odbc_usr'",SQL_NTS);
  return true;
}
#endif /* __TMYODBC__TEST__H */


