/* Copyright (C) 2000-2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   There are special exceptions to the terms and conditions of the GPL as it
   is applied to this software. View the full text of the exception in file
   EXCEPTIONS in the directory of this software distribution.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include "MYODBCSetupDataSourceTab3d.h"

MYODBCSetupDataSourceTab3d::MYODBCSetupDataSourceTab3d( QWidget *pwidgetParent )
    : QWidget( pwidgetParent, "MYODBCSetupDataSourceTab3d" )
{
    QVBoxLayout *playoutFields = new QVBoxLayout( this );
    playoutFields->setMargin( 20 );
    playoutFields->setSpacing( 5 );

    playoutFields->addStretch( 10 );

    pcheckboxTraceDriverCalls = new MYODBCSetupCheckBox( "Trace Driver Calls To myodbc.log", this );
    QToolTip::add( pcheckboxTraceDriverCalls, "Make a debug log in `c:\\myodbc.log'. This is the same as putting MYSQL_DEBUG=d:t:O,c::\\myodbc.log in `AUTOEXEC.BAT'. (On Unix, the file is `/tmp/myodbc.log'.)" );
    pcheckboxTraceDriverCalls->setAssistText( "Make a debug log in `c:\\myodbc.log'. This is the same as putting MYSQL_DEBUG=d:t:O,c::\\myodbc.log in `AUTOEXEC.BAT'. (On Unix, the file is `/tmp/myodbc.log'.)" );
    playoutFields->addWidget( pcheckboxTraceDriverCalls );

    pcheckboxSaveQueries = new MYODBCSetupCheckBox( "Save Queries to myodbc.sql", this );
    QToolTip::add( pcheckboxSaveQueries, "Enable query logging to `myodbc.sql' file. (Enabled only in debug mode.)" );
    pcheckboxSaveQueries->setAssistText( "Enable query logging to `myodbc.sql' file. (Enabled only in debug mode.)" );
    playoutFields->addWidget( pcheckboxSaveQueries );

    playoutFields->addStretch( 10 );
}


