unit AdminService;

interface

uses Classes, ComCtrls, Registry, Windows, SysUtils, StrUtils, WinSvc,
  myx_admin_public_interface, AuxFuncs, Contnrs, TntRegistry, TntComCtrls,
  TntClasses;

type
  TMySQLService = class(TObject)
    ExistingService: Boolean;
    StartType: integer;
    ServiceName: WideString;
    DisplayName: WideString;
    Description: WideString;
    ConfigFile: WideString;
    ConfigFileSection: WideString;
    ServerType: WideString;
    PathToBinary: WideString;
    Status: integer;
    ErrorLog: WideString;
    logfile_size: Longword;
  end;


procedure ScanForServices(TreeView: TTntTreeView; Icon: integer;
  ObjectList: TObjectList = nil);

implementation

procedure ScanForServices(TreeView: TTntTreeView; Icon: integer;
  ObjectList: TObjectList);
var ServiceReg: TTntRegistry;
  KeyInfo: TRegKeyInfo;
  SubKeyNames: TTntStringList;
  i,j: integer;
  ImagePath, s, s1: WideString;
  tmp: WideString;
  tokenList: TTntStringList;
  MySQLService: TMySQLService;
  errornr: MYX_ADMIN_LIB_ERROR;
  errorlog: WideString;
begin
  ServiceReg:=TTntRegistry.Create;
  SubKeyNames:=TTntStringList.Create;
  try
    ServiceReg.RootKey:=HKEY_LOCAL_MACHINE;

    ServiceReg.OpenKey('SYSTEM\'+
      'CurrentControlSet\Services', False);

    ServiceReg.GetKeyInfo(KeyInfo);
    ServiceReg.GetKeyNames(SubKeyNames);

    ServiceReg.CloseKey;

    for i:=0 to SubKeyNames.Count-1 do
    begin
      ServiceReg.OpenKey('SYSTEM\'+
        'CurrentControlSet\Services\'+SubKeyNames[i], False);

      try
        ImagePath:=ServiceReg.ReadString('ImagePath');
      except
        ImagePath:='';
      end;

      //Check if mysqld is in ImagePath
      if(Pos('mysqld', LowerCase(ImagePath))>0)then
      begin
        MySQLService:=TMySQLService.Create;
        MySQLService.ExistingService:=True;
        //ServiceList.Add(MySQLService);

        MySQLService.ServiceName:=SubKeyNames[i];
        //ReadString returns an exception if  the registry entry contains
        //something other than a string
        try
          MySQLService.DisplayName:=ServiceReg.ReadString('DisplayName');
        except
          MySQLService.DisplayName:= '';
        end;
        try
          MySQLService.Description:=ServiceReg.ReadString('Description');
        except
          MySQLService.Description:= '';
        end;

        try
          MySQLService.StartType:=ServiceReg.ReadInteger('Start');
        except
          MySQLService.StartType:=3;
        end;

        //Typical ImagePath:
        //c:\programme\mysql\bin\mysqld-max-nt --defaults-file="C:\Programme\MySQL\my.cnf" MySQL
        //c:\program files\mysql\bin\mysqld-max-nt --defaults-file="C:\Programme\MySQL\my.cnf" MySQL

        //parse the imagePath
        MySQLService.ConfigFile:='';
        MySQLService.ConfigFileSection:='';

        tokenList:= TTntStringList.Create();
        ParseCommandLine(ImagePath, tokenList);

        for j:=0 to tokenList.count-1 do
        begin
          if (j=0) then
          begin
            tmp:= AnsiDequotedStr(tokenList[j], '"');
            MySQLService.PathToBinary:=ExtractFilePath(tmp);
            MySQLService.ServerType:=Trim(ExtractFileName(tmp));
            if(CompareText(Copy(MySQLService.ServerType, Length(MySQLService.ServerType)-3, 4),
              '.exe')=0)then
              MySQLService.ServerType:=Copy(MySQLService.ServerType, 1, Length(MySQLService.ServerType)-4);
          end
          else if (AnsiStartsStr('--defaults-file=', tokenList[j])) then
          begin
            tmp:= Copy(tokenList[j],Length('--defaults-file=')+1,
                       Length(tokenList[j])-Length('--defaults-file='));
            MySQLService.ConfigFile:= AnsiDequotedStr(tmp, '"');
          end
          else if (NOT AnsiStartsStr('--', tokenList[j]) ) then
          begin
            MySQLService.ConfigFileSection:= tokenList[j];
          end;
        end;

        tokenList.Free();


        {//Get command from ImagePath
        //"xxx" yyy or xxx yyy
        if(Copy(ImagePath, 1, 1)='"')then
          s:=Copy(ImagePath, 1, Pos('"', Copy(ImagePath, 2, Length(ImagePath))))
        else
          if(Pos(' ', Copy(ImagePath, 1, Length(ImagePath)))>0)then
            s:=Copy(ImagePath, 1, Pos(' ', Copy(ImagePath, 2, Length(ImagePath))))
          else
            s:=ImagePath;

        MySQLService.PathToBinary:=ExtractFilePath(s);
        if(Copy(MySQLService.PathToBinary, 1, 1)='"')then
          MySQLService.PathToBinary:=IncludeTrailingPathDelimiter(
            Copy(MySQLService.PathToBinary, 2,
            Length(MySQLService.PathToBinary)-2));

        MySQLService.ServerType:=ExtractFileName(s);

        MySQLService.ConfigFile:='';
        MySQLService.ConfigFileSection:='';

        //Get defaults-file
        s:=Trim(Copy(ImagePath, Length(s)+1, Length(ImagePath)));
        if(s<>'')then
        begin

          if(Pos('--defaults-file=', s)>0)then
          begin
            s1:=Copy(s, Pos('--defaults-file=', s)+16, Length(s));

            //--defaults-file="xxx" or --defaults-file=xxx
            if(Copy(s1, 1, 1)='"')then
              s1:=Copy(s1, 1, Pos('"', Copy(s1, 2, Length(s1)))+1)
            else
              if(Pos(' ', s1)>0)then
                s1:=Copy(s1, 1, Pos(' ', s1)-1);

            MySQLService.ConfigFile:=s1;
            //Remove " if present
            if(Copy(MySQLService.ConfigFile, 1, 1)='"')then
              MySQLService.ConfigFile:=Copy(MySQLService.ConfigFile, 2,
                Length(MySQLService.ConfigFile)-2);

            //The rest is the serice name
            //Trim(Copy(s, Length(s1)+16+1, Length(s)));

            MySQLService.ConfigFileSection:='mysqld';
          end
          else
            //If there is no ConfigFile, the service name is the section name
            MySQLService.ConfigFileSection:=Trim(s);
        end;
        }

        //if the ConfigFile isn't specified in the Registry
        //it can be c:\my.cnf or windows-directory\my.ini
        if(MySQLService.ConfigFile='')then
        begin
          s:=GetWindowsDir;

          if(FileExists(s+'my.ini'))then
            MySQLService.ConfigFile:=s+'my.ini'
          else if(FileExists('c:\my.cnf'))then
            MySQLService.ConfigFile:='c:\my.cnf'
          else
          begin
            //If there is no default cnf file yet,
            //use PathToBinaries\my.cnf
            s1:=IncludeTrailingPathDelimiter(
              Copy(MySQLService.PathToBinary, 1, Pos('\bin', MySQLService.PathToBinary)-1));
            if(s<>'')then
              MySQLService.ConfigFile:=s1+'my.cnf'
            else
              MySQLService.ConfigFile:=s+'my.ini';
          end;
        end;

        //if the ConfigFileSection isn't specified in the Registry
        //it is mysqld
        if(MySQLService.ConfigFileSection='')then
          MySQLService.ConfigFileSection:='mysqld';


        //-----------------------------------------------------------------
        //Try to find errorfile
        MySQLService.ErrorLog:='';

        //first see if error-log is specified in the configfile
        if ( (MySQLService.ConfigFile<> '') and fileExists(Mysqlservice.ConfigFile) ) then
        begin
          ErrorLog:=myx_get_cnf_value(MySQLService.ConfigFile,
                                       mysqlservice.configfilesection,
                                       'log-error', @errornr);
          if (errorlog <> '') then
            MySQLService.ErrorLog:= errorlog;
        end;

        //secondly make some guesses
        if (MySQLService.ConfigFile = '') then
        begin
          s:=GetLocalHostName;


          if(FileExists(GetProgramFilesDir+'MySQL\data\'+s+'.err'))then
            MySQLService.ErrorLog:=GetProgramFilesDir+'MySQL\data\'+s+'.err'
          else if(FileExists('C:\MySQL\data\'+s+'.err'))then
            MySQLService.ErrorLog:='C:\MySQL\data\'+s+'.err'
          else if(FileExists('D:\MySQL\data\'+s+'.err'))then
            MySQLService.ErrorLog:='D:\MySQL\data\'+s+'.err';
        end;
        MySQLService.logfile_size:=0;

        //-----------------------------------------------------------------
        //Get Service Status
        MySQLService.Status:=ServiceStatus('', MySQLService.ServiceName);

        if(TreeView<>nil)then
          AddTreeViewChildNode(TreeView, nil, MySQLService.ServiceName,
            Icon+Ord(MySQLService.Status<>SERVICE_RUNNING), MySQLService);

        if(ObjectList<>nil)then
          ObjectList.Add(MySQLService);
      end;

      ServiceReg.CloseKey;
    end;

  finally
    SubKeyNames.Free;
    ServiceReg.Free;
  end;
end;


end.
