#include "mainwindow.h"
#include "serverlistviewitem.h"
#include <qmessagebox.h>
#include <qstatusbar.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qdom.h>
#include <qfile.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

void MainWindow::slot_close()
{
	((QWidget *)dialog)->close();
}

void MainWindow::slot_connect_new()
{
	QString l;

	l += "mysql_navigator ";

	disconnect((const QObject *)dialog->fire,SIGNAL(clicked()),(const QObject *)this,SLOT(slot_fire()));
	connect((const QObject *)dialog->fire,SIGNAL(clicked()),(const QObject *)this,SLOT(slot_close()));

	dialog->flag = TRUE;
	dialog->exec();

	disconnect((const QObject *)dialog->fire,SIGNAL(clicked()),(const QObject *)this,SLOT(slot_close()));
	connect((const QObject *)dialog->fire,SIGNAL(clicked()),(const QObject *)this,SLOT(slot_fire()));

	if(dialog->flag == FALSE)
		return;

	if(dialog->host->text().isEmpty())
	{
	}
	else
		l += "-h " + dialog->host->text() + " ";				

	if(dialog->user->text().isEmpty())
	{
	}
	else
		l += "-u " + dialog->user->text() + " ";				

	if(dialog->password->text().isEmpty())
	{
	}
	else
		l += "-p " + dialog->password->text() + " ";				

	if(dialog->database->text().isEmpty())
	{
	}
	else
		l += "-d " + dialog->database->text() + " ";				

	
	if(dialog->port->text().isEmpty())
	{
	}
	else
		l += "-P " + dialog->port->text() + " ";				

	if(dialog->socket->text().isEmpty())
	{
	}
	else
		l += "-s " + dialog->socket->text() + " ";				

	l += "&";

	//debug(l.latin1());

	system(l.latin1());
}

void MainWindow::slot_connect()
{
	if(flag)
	{
		return;
	}

	dialog->exec();

	if(flag)
	{
		statusBar()->message(tr("Connected..."),3000);

		if(global.schema.flag)
			slot_schema_window();	
	
		slot_database();

		enable_menu();

		load_history();
	}
}

void MainWindow::slot_fire()
{
	if(dialog->host->text().length()==0)
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter host name"));
		dialog->host->setFocus();
		return;
	}
	if(dialog->user->text().length()==0)
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter user name"));
		dialog->user->setFocus();
		return;
	}
	if(dialog->password->text().length()==0)
	{
		QMessageBox::warning (this, tr("MySQL Navigator"), tr("You did not enter password. \nFor security reason, it is very dangerous. \n Please change your password, if you succeed login. :-)"));
	}

	if(!mysql_real_connect(&mysql,
							dialog->host->text().latin1(),
							dialog->user->text().latin1(),
							dialog->password->text().latin1(),
							dialog->database->text().length()==0?NULL:dialog->database->text().latin1(),
							dialog->port->text().length()==0?3306:dialog->port->text().toUInt(),
							dialog->socket->text().length()==0?NULL:dialog->socket->text().latin1(),
							0	
							))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
	}
	else
	{
		host = dialog->host->text();
		user = dialog->user->text();

		//dialog->password->clear();
		/*
		dialog->host->clear();
		dialog->user->clear();
		dialog->password->clear();
		dialog->database->clear();
		dialog->port->clear();
		dialog->socket->clear();
		*/
		dialog->host->setSelection(0, dialog->host->text().length());
		dialog->host->setFocus();
		flag =  TRUE;
		((QWidget *)dialog)->hide();
	}
}

void MainWindow::load_server_list(Connect *dialog)
{
	char buffer[100];

	sprintf(buffer, "%s/.mysqlnavigator.rc", getenv("HOME"));

	QFile l(buffer);

	if(l.exists() == FALSE)
	{
		return;
	}

	if(l.open(IO_ReadOnly) == FALSE)
	{
		return;
	}
				
	QDomDocument mysql("mysql");

	if(mysql.setContent(&l) == FALSE)
	{
		l.close();
		return;
	}

	l.close();

	QDomNodeList node= mysql.elementsByTagName("SERVER");

	int count = node.count();

	QListViewItem *dummy = NULL;

	for(int l = 0; l < count; l++)
	{
		QString host;
		QString user;
		QString password;
		QString database;
		QString port;
		QString socket;

		QDomNode l_;

		l_= node.item(l).firstChild();	// host node
		host = l_.firstChild().nodeValue();

		l_= l_.nextSibling();	// user node
		user = l_.firstChild().nodeValue();
					
		l_= l_.nextSibling();	// password node
		password = l_.firstChild().nodeValue();

		l_= l_.nextSibling();	// database node
		database = l_.firstChild().nodeValue();

		l_= l_.nextSibling();	// port node
		port = l_.firstChild().nodeValue();
					
		l_= l_.nextSibling();	// socket node
		socket = l_.firstChild().nodeValue();

		dummy = new ServerListViewItem(dialog->list, dummy, host, host, user, password, database, port, socket);
	
		if(l == 0)
		{
			//dialog->slot_server(dummy);
			dialog->list->setSelected(dummy, TRUE);
		}
	}
}

void MainWindow::connect_directly(const QString &host, const QString &user, const QString &password, const QString &database, const int &port, const QString socket)
{

	if(!mysql_real_connect(&mysql,
							host.latin1(),
							user.latin1(),
							password.latin1(),
							database.latin1(),
							port,
							socket.latin1(),
							0	
							))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
	}
	else
	{
		this->host = host;
		this->user = user;

		//dialog->password->clear();
		/*
		dialog->host->clear();
		dialog->user->clear();
		dialog->password->clear();
		dialog->database->clear();
		dialog->port->clear();
		dialog->socket->clear();
		*/



		dialog->host->setSelection(0, dialog->host->text().length());
		dialog->host->setFocus();
		flag =  TRUE;

		statusBar()->message(tr("Connected..."),3000);

		if(global.schema.flag)
			slot_schema_window();	
	
		slot_database();

		enable_menu();

		load_history();
	}
}
