#include "mdiwindow.h"
#include "mainwindow.h"
#include "password.h"
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qmenubar.h>

void MainWindow::slot_password()
{
	if(!flag)
	{
		return;
	}

	MDIWindow* window = new MDIWindow(work_space, 0, WDestructiveClose);

 	Password *password = new Password(&mysql, window);

	connect(password, SIGNAL(signal_error()), this, SLOT(slot_error()));

    window->setCentralWidget(password);

	window->setCaption(tr("Password"));
    
	window->setFixedSize(231, 164 + 25); 

	QPopupMenu *l = new QPopupMenu();
	l->insertItem(tr("&Fire"), password, SLOT(slot_fire()), CTRL+Key_F);
	l->insertSeparator();
	l->insertItem(tr("&Close"), password, SLOT(slot_close()), CTRL+Key_C);
	window->menuBar()->insertItem(tr("&File"), l);
	
	l = new QPopupMenu();
	l->insertItem(tr("&About..."), password, SLOT(slot_about()), Key_F1);
	window->menuBar()->insertItem(tr("&Help"), l);

	window->show();
}
