#include "process.h"
#include <qmessagebox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlineedit.h>

void Process::signal_connect()
{
	connect((const QObject *)close, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_close()));
	connect((const QObject *)kill, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_kill()));
	connect((const QObject *)process, SIGNAL(rightButtonPressed ( QListViewItem *, const QPoint &, int )), this, SLOT(slot_kill(QListViewItem *)));
}

void Process::resizeEvent(QResizeEvent *l)
{
	process->resize(l->size().width() - 20, l->size().height() - 45 - 10);

	close->setGeometry(l->size().width() - 50,
					   l->size().height() - 10 - 25,
					   40,
					   23);
	
	kill->setGeometry(l->size().width() - 50 - 50,
					   l->size().height() - 10 - 25,
					   40,
					   23);
}
