#include <qpixmap.h>
#include "schema.h"
#include "table.xpm"
#include "field.xpm"

Schema::Schema(MYSQL *mysql, const QString &host, const QString &user, QWidget *widget, const char *name)
	: QListView(widget, name)
{
	addColumn("tree");  // only one column
	setRootIsDecorated(TRUE);

	((QWidget *)(header()))->hide();

	this->mysql = mysql;
	this->host = host;
	this->user = user;

	QPalette si= this->palette();
    si.setColor(QColorGroup::Highlight, QColor(210, 220, 240));
	si.setColor(QColorGroup::HighlightedText, QColor(0, 0, 0));
	si.setColor(QColorGroup::Button, QColor(159, 171, 190));
	si.setColor(QColorGroup::Base, QColor(238, 238, 224));
	setPalette(si);

	setAllColumnsShowFocus(TRUE);

	setSorting(-1);

	connect(this, SIGNAL(expanded(QListViewItem *)), this, SLOT(slot_expand(QListViewItem *)));
	connect(this, SIGNAL(collapsed(QListViewItem *)), this, SLOT(slot_collapse(QListViewItem *)));
}

Schema::~Schema()
{
}

void Schema::set_table(QListViewItem *database)
{
	MYSQL_RES *result;	

	MYSQL_ROW row;

	QListViewItem *table;	

	mysql_select_db(mysql,database->text(0).latin1());

	result = mysql_list_tables(mysql,NULL);

	if(result == NULL)
	{
		debug("mysql_list_tables failed");
		return;
	}

	table = NULL;

	while((row = mysql_fetch_row(result)))
	{
		table = new QListViewItem(database, table, row[0]);
		table->setPixmap(0, QPixmap(table_xpm));	
		set_field(table);
	}

	mysql_free_result(result);

	if(this->database.find(database->text(0)) != this->database.end())
	{
		database->setOpen(this->database.find(database->text(0)).data());
	}


	//database->listView()->setOpen(database,TRUE);
}

void Schema::set_field(QListViewItem *table)
{
	MYSQL_RES *result;

	MYSQL_FIELD *field;

	QListViewItem *si;

	result = mysql_list_fields(mysql,table->text(0).latin1(),NULL);

	if(result == NULL)
	{
		debug("mysql_list_fields failed");
		return;
	}

	si = NULL;

	while((field = mysql_fetch_field(result)))
	{
		si = new QListViewItem(table, si, field->name);
		si->setPixmap(0, QPixmap(field_xpm));	
	}

	if(this->table.find(table->text(0)) != this->table.end())
	{
		table->setOpen(this->table.find(table->text(0)).data());
	}
	
	mysql_free_result(result);
}
