#include <qmessagebox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlistview.h>

#include "multilinelistviewitem.h"
#include "table.h"

void Table::slot_close()
{
	parentWidget()->close();
}

void Table::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is a table window."));
}

void Table::slot_fire()
{
	if(table->text().length() == 0)
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter table name you will create."));
		return;
	}

	if(database->currentText() == QString("mysql"))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Can't create table in mysql database."));
		return;
	}

	mysql_select_db(mysql, database->currentText());

	QString sql;

	sql += "CREATE TABLE ";
	sql += table->text(); 
	sql += "(";

	QListViewItem *l;
	l = fields->firstChild();

	while(l)
	{
		sql+= l->text(0);						// field
		sql+= QString(" ") + l->text(1);		    // type	
		if(l->text(2).contains("NOT"))
		{
			sql+= QString(" ") + l->text(2);		// null, not null
		}
		
		if(!l->text(4).isEmpty())					// default
		{
			sql+= QString(" ") + QString("DEFAULT ") + QString("\'") + l->text(4) + QString("\'");
		}
		if(!l->text(5).isEmpty())					// extra 
		{
			sql+= QString(" ") + l->text(5);						 
		}
		if(!l->text(3).isEmpty())
		{
			sql+= QString(", ") + l->text(3);		// key 
		}

		l= l->nextSibling();

		if(l)
		{
			sql += QString(", ");
		}
	}

	sql += ")";
	sql += " comment = \'";
	sql += comment->text();
	sql += "\'";

	sql= sql.simplifyWhiteSpace();

	//debug(sql.latin1());

	if(!mysql_query(mysql, sql.latin1()))
	{
		emit signal_schema();
		QMessageBox::warning(this, tr("MySQL Navigator"), QString(tr("Table ")) + table->text() + QString(tr(" in ")) + database->currentText() + QString(tr(" is created.")));
	}
	else
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		emit signal_error();
	}
}

void Table::slot_new()
{
	fields->clearSelection();
	field->setText("");
	type->setCurrentItem(0);
	binary->setCurrentItem(0);
	length->setText("");
	null->setCurrentItem(0);
	_default->setText("");
	extra->setCurrentItem(0);
	primary->setChecked(FALSE);
	index->setChecked(FALSE);
	unique->setChecked(FALSE);
	field->setFocus();
}

void Table::slot_save()
{
	QListViewItem *l;

	if(field->text().length() == 0)
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter field name you will create.\n"));
		return;
	}

	l = fields->selectedItem();
	if(l == 0)
	{
		//l = new QListViewItem(fields, get_last());
		l = new MultiLineListViewItem(fields, get_last());
		((MultiLineListViewItem *)l)->set_height(19);
	}
	else
	{
		for(int s = 0; s < 6; s++)
			l->setText(s, "");
		//debug("overwrite...");
	}

	l->setText(0, field->text());
	
	if(length->text().length() == 0)
	{
		l->setText(1, type->currentText() + " " + binary->currentText());
	}
	else
	{
		l->setText(1, type->currentText() + "(" + length->text() + ") " + binary->currentText());
	}
	if(null->currentText() == QString("NOT NULL"))
	{
		l->setText(2, "NOT NULL");
	}
	else
	{
		l->setText(2, "");
	}

	if(primary->isChecked())
	{
		l->setText(3, QString("PRIMARY KEY") + QString("(") + field->text() + QString(")"));
	}
	else
	{
		l->setText(3, "");
	}

	l->setText(4, _default->text());

	if(extra->currentText() == QString("AUTO_INCREMENT"))
	{
		QString sql;
		sql += QString("AUTO_INCREMENT");

		if(index->isChecked())
		{
			sql += QString(", ");
			sql += QString("INDEX") + QString("(") + field->text() + QString(")");
			if(unique->isChecked())
			{
				sql += QString(", ");
				sql += QString("UNIQUE") + QString("(") + field->text() + QString(")");
			}
		}
		else if(unique->isChecked())
		{
			sql += QString(", ");
			sql += QString("UNIQUE") + QString("(") + field->text() + QString(")");
		}

		l->setText(5, sql);
	}
	else
	{
		QString sql;

		if(index->isChecked())
		{
			sql += QString(", ");
			sql += QString("INDEX") + QString("(") + field->text() + QString(")");
			if(unique->isChecked())
			{
				sql += QString(", ");
				sql += QString("UNIQUE") + QString("(") + field->text() + QString(")");
			}
		}
		else if(unique->isChecked())
		{
			sql += QString(", ");
			sql += QString("UNIQUE") + QString("(") + field->text() + QString(")");
		}
		l->setText(5, sql);
	}
}

void Table::slot_drop()
{
	fields->removeItem(fields->selectedItem());
	fields->clearSelection();
}

void Table::slot_up()
{
	if(fields->firstChild() == NULL)
		return;

	QListViewItem *l = fields->selectedItem()->itemAbove();

	if(l == NULL)
	{
		return;
	}

	l = l->itemAbove();

	if(l == NULL)
	{
		fields->firstChild()->moveItem(fields->selectedItem());
		return;
	}

	fields->selectedItem()->moveItem(l);
}

void Table::slot_down()
{
	if(fields->firstChild() == NULL)
		return;
	
	QListViewItem *l = fields->selectedItem()->itemBelow();

	if(l == NULL)
	{
		return;
	}

	fields->selectedItem()->moveItem(l);
}

QListViewItem *Table::get_last()
{
	QListViewItem *l;
	QListViewItem *last;

	l = fields->firstChild();

	if(l == NULL)
	{
		return NULL;
	}

	last = l;
	
	while(TRUE)
	{
		l = l->itemBelow();

		if(l == NULL)
		{
			break;
		}

		last = l;
	}

	return last;
}


void Table::slot_database()
{
	MYSQL_RES *result;
	MYSQL_ROW row;

	QString text = database->currentText();

	database->clear();

	result = mysql_list_dbs(mysql,NULL);

	if(result == NULL)
	{
		debug("mysql_list_dbs failed");
		return;
	}

	while((row = mysql_fetch_row(result)))
	{
		database->insertItem(row[0]);
	}

	mysql_free_result(result);

	slot_current_database(text);

	return;
}

void Table::slot_current_database(const QString &text)
{
	for(int l = 0; l < database->count(); l++)
		if(text == database->text(l))
		{
			database->setCurrentItem(l);
			break;
		}
}

void Table::slot_field(QListViewItem *sql)
{
	field->setText("");
	type->setCurrentItem(0);
	binary->setCurrentItem(0);
	length->setText("");
	null->setCurrentItem(0);
	_default->setText("");
	extra->setCurrentItem(0);
	primary->setChecked(FALSE);
	index->setChecked(FALSE);
	unique->setChecked(FALSE);

	field->setText(sql->text(0));

	if(sql->text(1).contains("ZEROFILL"))
		binary->setCurrentItem(3);
	else if(sql->text(1).contains("UNSIGNED"))
		binary->setCurrentItem(2);
	if(sql->text(1).contains("BINARY"))
		binary->setCurrentItem(1);

	if(sql->text(2).contains("NOT"))
		null->setCurrentItem(0);
	else
		null->setCurrentItem(1);

	_default->setText(sql->text(4));

	if(sql->text(5).contains("AUTO"))
		extra->setCurrentItem(1);

	if(sql->text(3).contains("PRIMARY"))
		primary->setChecked(TRUE);

	if(sql->text(5).contains("INDEX"))
		index->setChecked(TRUE);

	type->setCurrentItem(get_type(sql->text(1)));

	length->setText(get_length(sql->text(1)));
	
	if(sql->text(5).contains("UNIQUE"))
		unique->setChecked(TRUE);
}

QString Table::get_length(QString type)
{
	QString sql;

	bool flag = FALSE;

	for(unsigned int l = 0; l < type.length(); l++)
	{
		if(flag)
		{
			if(type[l] != ')')
				sql += QChar(type[l]);
		}

		if(type[l] == '(')
			flag = TRUE;

		if(type[l] == ')')
		{
			break;
		}
	}

	//debug(sql.latin1());

	return sql;
}

int Table::get_type(QString sql)
{
	char type[25][20] = {"TINYINT", "SMALLINT", "MEDIUMINT", "INT", "BIGINT", "FLOAT", "DOUBLE", "DECIMAL", "DATE", "DATETIME", "TIMESTAMP", "TIME", "YEAR", "CHAR", "VARCHAR", "TINYBLOB", "TINYTEXT", "TEXT", "BLOB", "MEDIUMBLOB", "MEDIUMTEXT", "LONGBLOB", "LONGTEXT", "ENUM", "SET"};

	sql = sql.upper();

	for(int l = 0; l < 25; l++)
	{
		if(strncmp(sql.latin1(), type[l], strlen(type[l])) == 0)
		{
			//debug(type[l]);
			return l;
		}
	}

	return 0;
}

void Table::slot_clear()
{
	table->setText("");
	comment->setText("");
	fields->clear();
	field->setText("");
	type->setCurrentItem(0);
	length->setText("");
	binary->setCurrentItem(0);
	null->setCurrentItem(0);
	_default->setText("");
	extra->setCurrentItem(0);
	primary->setChecked(FALSE);
	primary->setChecked(FALSE);
	index->setChecked(FALSE);
	unique->setChecked(FALSE);
	table->setFocus();
}
