/*
 * $Id: radexample.c,v 1.2 1997/12/25 23:28:51 lf Exp $
 *
 * Copyright (C) 1995,1996,1997 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at lf@elemental.net 
 * and I'll send you a copy.
 *
 */


static char	rcsid[] =
		"$Id: radexample.c,v 1.2 1997/12/25 23:28:51 lf Exp $";

#include	<config.h>
#include	<includes.h>
#include	<radiusclient.h>
#include	<pathnames.h>

static char *pname = NULL;

int
main (int argc, char **argv)
{
	int             result;
	int		critical_badlogin = (1==1);
	char		username[128];
	char            passwd[AUTH_PASS_LEN + 1];
	VALUE_PAIR 	*send, *received;
	UINT4		service;
	char 		msg[4096], username_realm[256];
	char		*default_realm = rc_conf_str("default_realm");

	pname = (pname = strrchr(argv[0],'/'))?pname+1:argv[0];

	rc_openlog(pname);

        if (argc < 4 | argc > 5  ) {
                usage();
        }

	if (rc_read_config(argv[3]) != 0)
	   {
		printf("Config file not found\n");
		return(-1);
	   }
	
	if (rc_read_dictionary(rc_conf_str("dictionary")) != 0)
		return(-1);
	
	strncpy (username,argv[1], sizeof(username));
	strncpy (passwd, argv[2], sizeof (passwd));

	if (argc > 4)
	critical_badlogin = strcmp(argv[4],"checklogin");

	send = NULL;

	/*
	 * Fill in User-Name
	 */

	strncpy(username_realm, username, sizeof(username_realm));

	/* Append default realm */
	if ((strchr(username_realm, '@') == NULL) && default_realm &&
	    (*default_realm != '\0'))
	{
		strncat(username_realm, "@", sizeof(username_realm));
		strncat(username_realm, default_realm, sizeof(username_realm));
	} 

	if (rc_avpair_add(&send, PW_USER_NAME, username_realm, 0) == NULL)
		return(ERROR_RC);
	
	/*
	 * Fill in User-Password
	 */
	 
	if (rc_avpair_add(&send, PW_USER_PASSWORD, passwd, 0) == NULL)
		return (ERROR_RC);

	/*
	 * Fill in Service-Type
	 */
	
	service = PW_AUTHENTICATE_ONLY;
	if (rc_avpair_add(&send, PW_SERVICE_TYPE, &service, 0) == NULL)
		return (ERROR_RC);	
	
	result = rc_auth(0, send, &received, msg);
	
	if (result == OK_RC)
	{
		printf("\"%s\" RADIUS Authentication OK\n", username);
		return 0;
	}
	else
	{
	  if (result == 1)
		{
		printf("\"%s\" Connection To Radius Server Timed out\n", username, result);
		return 2;
		}
	 else 
		{
		printf("\"%s\" RADIUS Authentication failure \n", username, result);
		if (critical_badlogin)
			return 1;
		else
			return 2;
		}
	}	
}

void usage(void)
{
        printf("Usage: %s username passwd configfile [checklogin] \n",
                pname);
	printf( "            configfile is path to a radiusclient configfile\n");
	printf( "            checklogin causes a critical on bad login\n");
	printf( "            (default is critical for timeouts only\n");
        exit(-1);
}

