--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Containers.Vectors;
with Ada.Strings.Unbounded;
with Ada.Unchecked_Deallocation;
with Interfaces;
with Log4ada;

with McKae.XML.EZ_Out.String_Stream;

package Narval.Parameters is

   use McKae.XML.EZ_Out.String_Stream;
   use McKae.XML.EZ_Out.String_Stream.XML_String_Buffer;

   type Editor_Type is (None, File);
   type Container_Type is (Boolean_Type, Log_Level_Type,
                           Unsigned_8_Type, Unsigned_16_Type,
                           Unsigned_32_Type, Unsigned_64_Type, Natural_Type,
                           Positive_Type, Integer_Type, Float_Type,
                           Long_Float_Type, String_Type);
   type Parameter_Type (Container_Kind : Container_Type) is record
      Name : Ada.Strings.Unbounded.Unbounded_String;
      Mode : Mode_Type := No_Access;
      Monitor : Monitor_Kind := Never;
      Run_Parameter : Boolean := False;
      Editor : Editor_Type := None;
      case Container_Kind is
         when Boolean_Type =>
            Boolean_Value : Boolean := False;
         when Log_Level_Type =>
            Level_Value : Log4ada.Level_Type := Log4ada.Warn;
         when Unsigned_8_Type =>
            Unsigned_8_Value : Interfaces.Unsigned_8 := 0;
         when Unsigned_16_Type =>
            Unsigned_16_Value : Interfaces.Unsigned_16 := 0;
         when Unsigned_32_Type =>
            Unsigned_32_Value : Interfaces.Unsigned_32 := 0;
         when Unsigned_64_Type =>
            Unsigned_64_Value : Interfaces.Unsigned_64 := 0;
         when Natural_Type =>
            Natural_Value : Natural := 0;
         when Positive_Type =>
            Positive_Value : Positive := 1;
         when Integer_Type =>
            Integer_Value : Integer := 0;
         when Float_Type =>
            Float_Value : Float := 0.0;
         when Long_Float_Type =>
            Long_Float_Value : Long_Float := 0.0;
         when String_Type =>
            String_Value : Ada.Strings.Unbounded.Unbounded_String;
      end case;
   end record;
   type Parameter_Access is access all Parameter_Type;
   procedure Free is new Ada.Unchecked_Deallocation (Parameter_Type,
                                                     Parameter_Access);
   --  function "=" (Left, Right : Parametre_Access) return Boolean;
   package Parameter_Vector_Package is new Ada.Containers.Vectors
     (Natural, Parameter_Access, "=");
   procedure To_Xml (Parameter : Parameter_Type;
                     Xml_Buffer : in out String_Buffering.String_Buffer);
   function Image (Parameter : Parameter_Type) return String;
   procedure Set (Parameter : in out Parameter_Type;
                  Value : String);
   function Get_Attributes (Parameter : Parameter_Type) return Attributes_List;
   function "+"(Left : Attributes_List;
                Right : Attribute_Value_Pairs) return Attributes_List;
   function "+"(Left : Attribute_Value_Pairs;
                Right : Attribute_Value_Pairs) return Attributes_List;
   Read_Only_Parameter : exception;
   Parameter_Bad_Format : exception;
   function New_Parameter (Item : String) return Parameter_Access;
   function Find_Parameter (List : Parameter_Vector_Package.Vector;
                            Name : String;
                            Case_Sensitivity : Boolean := False)
                           return Parameter_Access;
   function Find_Parameter (List : Parameter_Vector_Package.Vector;
                            Name : Ada.Strings.Unbounded.Unbounded_String;
                            Case_Sensitivity : Boolean := False)
                           return Parameter_Access;
   Parameter_Not_Found : exception;
end Narval.Parameters;
