--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
package body Narval.Actors is

   -------------------------
   -- fonction Est_Vivant --
   -------------------------

   function Is_Alive (Object : access Actor) return Boolean is
   begin
      if Object.Process_Can_Go_To_End then
         return False;
      end if;
      return True;
   end Is_Alive;

   ------------------------------
   -- fonction Recuperer_Genre --
   ------------------------------

   function Get_Kind
     (Object : access Actor)
     return Actor_Kind_Type
   is
   begin
      return Object.Kind;
   end Get_Kind;

   --------------------------------
   -- procedure Terminer_Process --
   --------------------------------

   procedure End_Process (Object : access Actor) is
   begin
      Object.Process_Can_Go_To_End := True;
   end End_Process;

   ----------------------------
   -- fonction Doit_Terminer --
   ----------------------------

   function Have_To_End (Object : Actor) return Boolean is
   begin
      return Object.Process_Can_Go_To_End;
   end Have_To_End;

end Narval.Actors;
