--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Log4ada;

package Narval.Actors is

   pragma Remote_Types;

   type Actor (Kind : Actor_Kind_Type) is abstract tagged limited private;
   type Actor_Class_Access is access all Actors.Actor'Class;

   type Actor_Class_Access_Array is array (Positive range <>) of
     Actor_Class_Access;

   function Get_Kind (Object : access Actor)
                     return Actor_Kind_Type;

   function Is_Alive (Object : access Actor) return Boolean;

   procedure Trig_Event (Object : access Actor;
                         Event : String) is abstract;

   procedure Set (Object : access Actor;
                  Parameter : String;
                  Value : String) is abstract;
   function Arguments (Object : access Actor;
                       Xml : Boolean := True) return String is abstract;
   function Get_Xml (Object : access Actor;
                     Parameter : String) return String is abstract;
   function Get_Image (Object : access Actor;
                       Parameter_Name : String) return String is abstract;

   function Get_Available_Link
     (Object : access Actor;
      Asker : String;
      Port : String;
      Service_Name : String)
     return Link_Descriptor_Type is abstract;

   procedure Change_State (Object : access Actor;
                           Order : Action) is abstract;
   procedure Initialise (Active_Actor : access Actor;
                         Actor_Name : String) is abstract;
   procedure End_Process (Object : access Actor);
   function Have_To_End (Object : Actor) return Boolean;
   procedure Log_Message (Object : access Actor;
                          Message : String;
                          Level : Log4ada.Level_Type) is abstract;
private
   type Actor (Kind : Actor_Kind_Type) is abstract tagged limited record
      Process_Can_Go_To_End : Boolean := False;
   end record;
end Narval.Actors;
