--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Narval.Narval_Naming_Registry;
with Log4ada;
with Events_Receivers.Local_Consoles;
with Events_Receivers.Tcp_Socket;
with Options;
with Ada.Strings.Unbounded;


with Ada.Text_IO;

procedure Init_Central_Log is
   Local_Receiver : aliased
     Events_Receivers.Local_Consoles.Events_Display_Console_Type;
   Local_Receiver2 : aliased
     Events_Receivers.Tcp_Socket.Events_TCP_Socket_Type;
   Level : Log4ada.Level_Type := Log4ada.Warn;
   use Ada.Strings.Unbounded;
begin
   if Options.Present_Option ("help") then
      Ada.Text_IO.Put_Line ("Central Log Help");
      Ada.Text_IO.Put_Line ("Options :");
      Ada.Text_IO.Put_Line ("  --log_level info|warn|debug");
      Ada.Text_IO.Put_Line ("  --name NAME_OF_THE_LOGGER");
      Ada.Text_IO.Put_Line ("  --server SERVER_NAME_OR_ADDRESS");
      Ada.Text_IO.Put_Line ("  --port SERVER_PORT");
      Ada.Text_IO.Put_Line ("  --console BOOLEAN");
      Ada.Text_IO.Put_Line ("        default is False but if you want" &
                            " a console with the TCP logger you need " &
                            "to put it True.");
   else
      begin
         Level := Log4ada.Level_Type'Value (Options.Get_Option ("log_level"));
      exception
         when Options.Non_Present_Option =>
            null;
      end;
      begin
         Local_Receiver2.Name :=
           Ada.Strings.Unbounded.To_Unbounded_String
           (Options.Get_Option ("name"));
      exception
         when Options.Non_Present_Option =>
            null;
      end;
      begin
         Local_Receiver2.Server :=
           Ada.Strings.Unbounded.To_Unbounded_String
           (Options.Get_Option ("server"));
      exception
         when Options.Non_Present_Option =>
            null;
      end;
      begin
         Local_Receiver2.Port := Natural'Value (Options.Get_Option ("port"));
      exception
         when Options.Non_Present_Option =>
            null;
      end;
      begin
         Local_Receiver2.Console := Boolean'Value
           (Options.Get_Option ("console"));
      exception
         when Options.Non_Present_Option =>
            null;
      end;

      if Local_Receiver2.Name /=
        Ada.Strings.Unbounded.Null_Unbounded_String and
        Local_Receiver2.Server /=
        Ada.Strings.Unbounded.Null_Unbounded_String and
        Local_Receiver2.Port /= 0 then
         Ada.Text_IO.Put_Line ("Central_Log : TCP Logger. For " &
                               "more informations use 'central_log --help'.");
         Ada.Text_IO.Put_Line ("Name : " &
                               Ada.Strings.Unbounded.To_String
                               (Local_Receiver2.Name));
         Ada.Text_IO.Put_Line ("Server : " &
                               Ada.Strings.Unbounded.To_String
                               (Local_Receiver2.Server));
         Ada.Text_IO.Put_Line ("Port :" & Local_Receiver2.Port'Img);
         Events_Receivers.Tcp_Socket.Initialise (Receiver => Local_Receiver2,
                                                 Level => Level);
         begin
            Narval.Narval_Naming_Registry.Subscribe
              (Local_Receiver2'Unchecked_Access);
         exception
            when Narval.Narval_Naming_Registry.Already_Existent_Receiver =>
               Ada.Text_IO.Put_Line
                 ("Central_Log : a central log is already launched");
               return;
         end;
      else
         Ada.Text_IO.Put_Line ("Central_Log : Console Logger. " &
                               "For more informations use 'cen" &
                               "tral_log --help'.");
         Events_Receivers.Local_Consoles.Initialise
           (Receiver => Local_Receiver, Level => Level);
         begin
            Narval.Narval_Naming_Registry.Subscribe
              (Local_Receiver'Unchecked_Access);
         exception
            when Narval.Narval_Naming_Registry.Already_Existent_Receiver =>
               Ada.Text_IO.Put_Line
                 ("Central_Log : a central log is already launched");
               return;
         end;
      end if;
      loop
         delay 100.0;
      end loop;
   end if;
end Init_Central_Log;
