/* 
 * This file is part of ncps.
 */
#include <regex.h>

#define USER 8
#define TTY_WIDTH TTYC
#define PID 6
#define CPU 5
#define NICE 5
#define STAT 3
#define MEM 6

#define MIN_WIDTH USER + TTY_WIDTH + PID + STAT + CPU + NICE + MEM  + 4

#define BOX_WIDTH COLS

#define ctrl(c) ((c)-'@')

#define NORMAL 0
#define REINIT -2
#define QUIT -1
#define MONITOR_REFRESH -7
#define MONITOR -6
#define LEFT -5

#define COLOR_OPTIONS 7

#define NORMAL_COLOR 1
#define SELECTED_COLOR 2 
#define BANNER_COLOR 3
#define HIGHLIGHT_COLOR 4
#define SELECTED_HIGHLIGHT_COLOR 5
#define BANNER_SELECTED_COLOR 6

#define STRING_LENGTH 256

typedef struct color_config_s {
  int background;
  int foreground;
} color_config_t;

color_config_t color_config[COLOR_OPTIONS];

void draw_menu(killer_t *chow, int highlight, unsigned int selected, int count, int t_view);
void clear_all_screen(void);
int getchoice(killer_t *chow); 
void move_up(int times, int *selected_row, unsigned int *selected);
void move_down(int times, int *selected_row, unsigned int *selected, int count);
void row_clear(int current_row);
void draw_top(int key);
void help_screen(void);
void input_dlg(char *input, char *greet);
void murder(int selected, procinfo_t *list, int count, int sig);
void make_item(char *item, procinfo_t procinfo);
int parse_rc_color(const char *path, color_config_t *color_config);
int read_line(FILE *fp, char *s);
void parse_line_color(color_config_t *color_config, char *s);
