// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="Mike KrÃ¼ger" email="mike@icsharpcode.net"/>
//     <version value="$version"/>
// </file>

using System;
using System.Reflection;

	/// <summary>
	/// Indicates that field should be treated as a xml attribute for the codon or condition.
	/// The field is treated as a array, separated by ',' example :
	/// fileextensions = ".cpp,.cc,.C"
	/// </summary>
	[AttributeUsage(AttributeTargets.Field, Inherited=true)]
	public class XmlMemberArrayAttribute : Attribute
	{
		 mutable    separator :  array [char] =    array[ ',' ];
		 mutable  name : string;
		 mutable    isRequired : bool;
		
		/// <summary>
		/// Constructs a new instance.
		/// </summary>
		public this(mutable  name : string)
		{
			this.name  = name;
			isRequired = false;
		}
		
		public Separator :  array [char] {
			get {
				 separator;
			}
			set {
				separator = value;
			}
		}
		
		/// <summary>
		/// The name of the attribute.
		/// </summary>
		public Name : string {
			get {
				 name;
			}
			set {
				name = value;
			}
		}
		
		/// <summary>
		/// returns <code>true</code> if this attribute is required.
		/// </summary>
		public IsRequired : bool {
			get {
				 isRequired;
			}
			set {
				isRequired = value;
			}
		}
	}

public class t
{

	[XmlMemberArrayAttribute("shortcut", Separator=   array[ '|'])]
	 mutable  shortcut :  array [string];

	public static Main () :  void { }

}
/*
BEGIN-OUTPUT
END-OUTPUT
*/
