using System;

variant V 
{
  | A { a : V; b : V; }
  | B
  
  public override ToString () : string
  {
    match (this) {
      | A (a, b) => "A(" + a.ToString () + ", " + b.ToString () + ")"
      | B => "B"
    }
  }
}

public variant Color 
{ 
  | R 
  | G 
  | B 
  
  [Nemerle.OverrideObjectEquals]
  public Equals (c : Color) : bool
  {
    match ((this, c)) {
      | (R, R) 
      | (G, G) 
      | (B, B) => true
      | _ => false
    }
  }           
}

class K 
{
  public Prop : Color {
    get { Color.R() }
  }
  
  public PropNull : Color {
    get { null }
  }
}


public module NewMatchingWithNulls 
{
  /* no warnings here that matching is not exhaustive (all counter-examples must
     contain null values) */
  public foo (ccc : Color * Color * Color) : string // OK
  {
    | (R, _, _) => "1" // OK
    | (_, R, _) => "2" // OK
    | (_, _, R) => "3" // OK
    | (B, B, B) => "4" // OK
    | (_, _, G) => "5" // OK
    | (G, _, _) => "6" // OK
    | (_, G, _) => "7" // OK
  }

  public Main () : void
  {
    def print_exception (e : Exception, ids) {
      match (e) {
        | _ is MatchFailureException => 
          System.Console.WriteLine (ids + ": match failure")
        | _ is NullReferenceException =>
          System.Console.WriteLine (ids + ": null reference")
        | _ => System.Console.WriteLine (ids + ": unknown exception")
      }	
    }
  
    def x : V = null;

    match (x) {
      | A => {} // OK
      | _ => {} // OK
      | null => {} // W: this match clause is unused
    }
    
    match (x) {
      | A => {} // OK
      | B => {} // OK
      | null => {} // OK
      | _ => {} // W: this match clause is unused
    }
    
    match (x) { // OK
      | null => {} // OK
      | A => {} // OK
      | null => {} // W: this match clause is unused
      | B => {} // OK
    }
    
    try {
      match (V.A (null, V.B ()) : V) { // W: matching is not exhaustive
        | B => {} // OK
        | A (B, _) => {} // OK
        | A (A, A) => {} // OK
        | A (null, A) => {} // OK
      }
    } catch {
      // expected "match failure"
      | e => print_exception (e, "1")
    }
    
    match (x) { // OK
      | A => Console.WriteLine ("A")
      | _ => Console.WriteLine ("other than A")
    }
    
    try {
      match (x) { // OK
        | A => Console.WriteLine ("A") 
	| x => Console.WriteLine (x.ToString ())
      }
    } catch {
      // expected "null reference"
      | e => print_exception (e, "2")
    }
    
    try {
      match (x) { // OK
        | A => {}
	| B => {}
      }
    } catch {
      // expected "match failure"
      | e => print_exception (e, "3")
    }
    
    try {
      match ((V.A (V.B (), V.B ()), null) : V * V) { // OK
        | (A, A) => {} // OK
        | (A, B) => {} // OK
	| (B, null) => {} // OK
	| (B, _) => {} // OK
      }
    } catch {
      // expected "match failure"
      | e => print_exception (e, "4")
    }
    
    def k : K = null;
    
    try {
      match (k) { // OK
        | _ : K => {} // OK
      }
    } catch {
      // expected -- no exception
      | e => print_exception (e, "5")
    }

    try {    
      match (k) { // OK
        | K where (Prop = Color.R ()) => {}
        | _ => {}
      }
    } catch {
      // expected "null reference"
      | e => print_exception (e, "6")
    }
  
    def k = K ();
  
    try {
      match (k) { // OK
        | K where (PropNull = null) => {}
        | _ => {}
      }
    } catch {
      // expected -- no exception
      | e => print_exception (e, "7")
    } 
    
    System.Console.WriteLine (foo ((Color.R (), null, Color.G ())));
    System.Console.WriteLine (foo ((null, null, Color.G ())));
    
    try {
      System.Console.WriteLine (foo ((null, null, Color.B ())))
    } catch {
      // expected "match failure"
      | e => print_exception (e, "8")
    }
    
    try {
      System.Console.WriteLine (foo ((null, null, null)))
    } catch {
      // expected "match failure"
      | e => print_exception (e, "9")
    }
    
  }
}


/*
BEGIN-OUTPUT
1: match failure
other than A
2: null reference
3: match failure
4: match failure
6: null reference
1
5
8: match failure
9: match failure
END-OUTPUT
*/
