/*
 * THE NEMESIS PROJECT
 * Copyright (C) 1999, 2000, 2001 Mark Grimes <obecian@packetninja.net>
 * Portions copyright (C) 2001 Jeff Nathan <jeff@wwti.com>
 *
 * nemesis-arp.c (ARP/RARP Packet Injector)
 *
 */

#include "nemesis-arp.h"

int
main(int argc, char **argv)
{
   static int      fd = -1;
   int             opt, i;
   char           *file = NULL;
   char            buff[512];
   extern char    *optarg;
   extern int      opterr;
  
   got_link = 0;
   got_payload = 0;
  
   verbose = 0;
  
   if (argc < 2)
      usage(argv[0]);
  
   defaults();
  
   opterr = 0;
   while ((opt = getopt(argc, argv, "S:D:H:h:M:m:d:P:vRTs")) != EOF) {
      switch (opt) {
      case 'v':
         verbose = 1;
         putchar('\n');
         puts(TITLE " " VERSION);
         puts(CODERS);
         puts(NEWCODERS);
         putchar('\n');
         break;
      case 'd':
         device = optarg;
         got_link = 1;
         break;
      case 'T':
         reply = 1;
         break;
      case 'R':
         ltype = 1;
         break;
      case 's':
         solarismode = 1;
         for (i=0; i<6; i++ ) {
            arp_dst[i] = 0xff;
         }
         break;
      case 'h':	/* sender hardware address */
         arp_src_enable = 1;
         sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &addr_tmp[0],
		&addr_tmp[1], &addr_tmp[2], &addr_tmp[3], &addr_tmp[4],
		&addr_tmp[5]);
         for (i=0; i<6; i++) 
            arp_src[i] = (u_char) addr_tmp[i];
         break;
      case 'm':	/* target hardware address */
         arp_dst_enable = 1; 
         sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &addr_tmp[0],
		&addr_tmp[1], &addr_tmp[2], &addr_tmp[3], &addr_tmp[4],
		&addr_tmp[5]);
         for (i=0; i<6; i++)
            arp_dst[i] = (u_char) addr_tmp[i];
         break; 
      case 'S':
         if (!(source = libnet_name_resolve(optarg, 0))) {
            fprintf(stderr, "Invalid source IP address: %s\n", optarg);
            exit(-1);
         }
         if (verbose) {
            printf("%s %s\n\n", (ltype == 0 ? "ARP" : "RARP"),
		(reply == 0 ? "REQUEST" : "REPLY"));
            printf("[IP]  %s > ", optarg);
         }
         break;
      case 'D':
         if (!(dest = libnet_name_resolve(optarg, 0))) {
            fprintf(stderr, "Invalid destination IP address: %s\n", optarg);
            exit(-1);
         }
         if (verbose)
            printf("%s\n", optarg);
         break;
      case 'H':
         sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &addr_tmp[0],
		&addr_tmp[1], &addr_tmp[2], &addr_tmp[3], &addr_tmp[4],
		&addr_tmp[5]);
         for (i=0; i<6; i++)
            enet_src[i] = (u_char) addr_tmp[i];
         break;
      case 'M':
         sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &addr_tmp[0],
		&addr_tmp[1], &addr_tmp[2], &addr_tmp[3], &addr_tmp[4],
		&addr_tmp[5]);
         for (i=0; i<6; i++)
            enet_dst[i] = (u_char) addr_tmp[i];
         break;
      case 'P':
         file = optarg;
         got_payload = 1;
         if ((fd = open(file, O_RDONLY)) < 0) {
            (void) fprintf(stderr, "%s: open: ", argv[0]);
            perror(file);
            exit(-1);
         }
         break;
      case '?':
         usage(argv[0]);
         break;
      }    
   }
   argc -= optind;
   argv += optind;

   /* sanity checks */
   if (source == 0 || dest == 0) {
      printf("Source and/or Destination Address Missing.\n");
      exit(1);
   }

   if (!got_link || (got_link && !device)) {
      printf("Unspecified Device.\n");
      exit(-1);
   }

   if (solarismode == 1 && arp_dst_enable == 1) {
      printf("Using -s and -m is redundant, choose one or the other.\n");
      exit(1);
   }

   if (enet_src[0] == NULL) {
      e = libnet_get_hwaddr(l2, device, errbuf);
      for (i=0; i<6; i++)
         enet_src[i] = e->ether_addr_octet[i];
      if (!e) {
         fprintf(stderr, "cannot retrieve hardware address of %s: %s\n", 
		device, errbuf);
         exit(1);
      } 
   } 

   if (verbose) {
      printf("[MAC] ");
      printf("%02X:%02X:%02X:%02X:%02X:%02X > %02X:%02X:%02X:%02X:%02X:%02X\n", enet_src[0], enet_src[1], enet_src[2], enet_src[3], enet_src[4], enet_src[5], enet_dst[0], enet_dst[1], enet_dst[2], enet_dst[3], enet_dst[4], enet_dst[5]);
   }    

   if (got_payload) {
      payload = buff;
      while ((nbytes = read(fd, buff, sizeof(buff))) != 0) {
         payload_s += nbytes;
         if (verbose) {
            hexdump(payload, payload_s);
            if (buildarp() != -1) {
               if (verbose)
                  printf("\n%s Packet Injected\n", (ltype == 0 ? "ARP" : "RARP"));
            } else {
               if (verbose)
                  printf("\n%s Injection Failure\n", (ltype == 0 ? "ARP" : "RARP"));
            } 
         }
      }
     close(fd);
     exit(0);
   } 

   if (buildarp() != -1) {
      if (verbose)
         printf("\n%s Packet Injected\n", (ltype == 0 ? "ARP" : "RARP"));
   } else {
      if (verbose)
         printf("\n%s Injection Failure\n", (ltype == 0 ? "ARP" : "RARP"));
   }
   close(fd);
   exit(0);
}

void 
hexdump(char *buf, int len)
{
   int i, j, ptr, pad = PADDING, counter;
   ptr = 0;
   counter = 0;
   for (i = 0; i < len; i++) {
      counter++;
      printf("%02X ", (u_char) buf[i]);
      if ((i == (len - 1)) && (counter < pad))
         while (counter++ < pad) {
            printf("   ");
         }
      if (((i + 1) % pad == 0) || (i == (len - 1))) {
         counter = 0;
         for (j = ptr; j <= i; j++) {
            if ((buf[j] > 0x20) && (buf[j] < 0x7f)) {
               printf("%c", buf[j]);
            } else {
               putchar('.');
            } 
         } 
      ptr = i + 1;
      putchar('\n');
      } 
   } 
   putchar('\n');
}


void
usage(char *arg)
{
   putchar('\n');
   puts(TITLE " " VERSION);
   puts(CODERS);
   puts(NEWCODERS);
   putchar('\n');
  
   printf("ARP/RARP Usage:\n  %s [-v (verbose)] [optlist]\n\n", arg);
   printf("ARP/RARP Options: \n"
          "  -S <Source IP Address>\n"
          "  -D <Destination IP Address>\n"
          "  -h <Sender MAC address within ARP frame>\n"
          "  -m <Target MAC address within ARP frame>\n"
          "  -s <Solaris style ARP requests with target hardware addess set to broadcast>\n"
          "  -T ({ARP,RARP} REPLY enable)\n"
          "  -R (RARP enable)\n"
          "  -P <Payload File (Binary or ASCII)>\n\n");
   printf("Data Link Options: \n"
          "  -d <Ethernet Device>\n"
          "  -H <Source MAC Address>\n"
          "  -M <Destination MAC Address>\n\n");
   printf("You must define a Source, Destination and Ethernet device\n");
   exit(-1);
}

void
defaults()
{
   reply = 0;			/* request */
   ltype = 0;			/* arp */

   enet_src[0] = NULL;		/* Ethernet frame source address */
   enet_src[1] = NULL;
   enet_src[2] = NULL;
   enet_src[3] = NULL;
   enet_src[4] = NULL;
   enet_src[5] = NULL;

   enet_dst[0] = 0xff;		/* Ethernet frame destination address */
   enet_dst[1] = 0xff;
   enet_dst[2] = 0xff;
   enet_dst[3] = 0xff;
   enet_dst[4] = 0xff;
   enet_dst[5] = 0xff; 
  
   arp_dst[0] = 0x00;		/* ARP frame target address */
   arp_dst[1] = 0x00;
   arp_dst[2] = 0x00;
   arp_dst[3] = 0x00;
   arp_dst[4] = 0x00;
   arp_dst[5] = 0x00;

   arp_src_enable = 0;

   payload = NULL;
   payload_s = 0;
}
