#
# Copyright 2000 by Renaud Deraison <deraison@cvs.nessus.org>
#

if(description)
{
 script_id(10649);
 name["english"] = "processit";
 script_name(english:name["english"]);
 
 desc["english"] = "The 'processit' CGI is installed.
processit normally returns all environment variables.

This gives an attacker valuable information about the
configuration of your web server, allowing them to focus their
attacks.

Solution : Remove it from /cgi-bin.

Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/processit";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison");

 family["english"] = "CGI abuses";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

cgi = "processit.pl";
port = is_cgi_installed(cgi);
if(port)security_warning(port);

