/*
 * nblib.h  -  Header file for netboot library
 *
 * Copyright (C) 1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * Structure defining program options
 */
struct cmdopt {
	char		*longopt;	/* long option name */
	char		 shortopt;	/* short option character */
	enum {
		noval,			/* end of option list */
		boolval,		/* option has no argument */
		intval,			/* option has integer argument */
		strval,			/* option has string argument */
		procval,		/* call procedure when option given */
		nonopt			/* argument without option name */
	}		 valtype;
	union {
		char **strptr;		/* pointer to string buffer */
		int   *intptr;		/* pointer to integer buffer */
		int   *boolptr;		/* pointer to boolean buffer */
		void (*procptr) __P((struct cmdopt *));
	}		 valptr;
	char		*envdefault;	/* environment var name for default */
	char		*helptext;	/* help text for option */
	char		*helparg;	/* help text for argument */
};



/*
 * Structures holding all the information required to parse config file
 */
struct paramdef {
	char		 *name;		/* name of parameter in config file */
	enum {
		par_null,		/* end of parameter list */
		par_string,		/* string value */
		par_int,		/* integer value */
		par_bool,		/* boolean value */
		par_enum,		/* enumeration value */
		par_proc		/* procedure to handle argument */
	}		  type;
	char		**enumlist;	/* list of enumeration values */
	union {
		char  **strptr;		/* pointer to string buffer */
		int    *intptr;		/* pointer to integer value */
		int    *boolptr;	/* pointer to boolean value */
		int    *enumptr;	/* pointer to enumeration value */
		char *(*procptr) __P((char *, char *));
	}		  valptr;
};

struct sectdef {
	char		 *name;		/* name of section */
	struct paramdef  *params;	/* pointer to parameter list */
	char		*(*startsect) __P((char *, struct sectdef *));
	char		*(*endsect) __P((char *, struct sectdef *));
};



/*
 * Variables exported by library
 */
extern char *progname;		/* name of current program */
extern char *dbname;		/* name of system database file */
extern int write_chksum;	/* checksum for all bytes when writing */
extern int verbose;		/* verbosity flag */



/*
 * Routines exported by library
 */
extern voidstar nbmalloc __P((size_t amount));
extern int nbread __P((unsigned char *buf, unsigned int bufsize, int infile));
extern int nbwrite __P((unsigned char *buf, unsigned int bufsize, int outfile));
extern void copystr __P((char **dest, char *src));
extern void setpath __P((char **pathname, char *defaultname));
extern void readdb __P((struct sectdef *sect));
extern void nbsetup __P((int argc, char **argv,
				struct cmdopt *opts, struct sectdef *sects));

