/*
 * memory.c  -  Memory allocation and string handling
 *
 * Copyright (C) 1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define NO_BINARY 1	/* No need to include binary support here */
#include "common.h"
#include "nblib.h"
#include "privlib.h"



/*
 * Allocate memory - with error handling
 */
voidstar nbmalloc(amount)
size_t amount;
{
  voidstar ptr;

  if (amount <= 0) {
	fprintf(stderr, "%s: nbmyalloc: illegal amount of memory requested\n",
								progname);
	exit(EXIT_INTERNAL);
  }
  if ((ptr = malloc(amount)) == NULL) {
	perror(progname);
	exit(EXIT_MEMORY);
  }
  memset(ptr, 0, amount);
  return(ptr);
}



/*
 * Copy a string into a newly allocated memory block
 */
void copystr(dest, src)
char **dest;
char  *src;
{
  if (*dest != NULL)
	free(*dest);
  if ((*dest = strdup(src)) == NULL) {
	perror(progname);
	exit(EXIT_MEMORY);
  }
}



/*
 * Set a file or directory name with a default value, if it has no
 * name yet. If the name starts with two slashes, replace the first
 * slash with the netboot directory name.
 */
void setpath(pathname, defaultname)
char **pathname;
char  *defaultname;
{
  char *newname;
  size_t len;

  if (*pathname == NULL) {
	if (defaultname == NULL)
		return;
	if ((*pathname = strdup(defaultname)) == NULL) {
		perror(progname);
		exit(EXIT_MEMORY);
	}
  }

  if (!strncmp(*pathname, "//", 2)) {
	len = strlen(*pathname) + strlen(netbootdir) + 1;
	newname = nbmalloc(len);
	sprintf(newname, "%s%s", netbootdir, (*pathname)+1);
	free(*pathname);
	*pathname = newname;
  }
}

