/* This file is part of Netwib.
*/

/*-------------------------------------------------------------*/
netwib_err netwib_priv_mem_malloc(netwib_uint32 allocsize,
                                  netwib_ptr *pptr)
{
  if (pptr == NULL) {
    return(NETWIB_ERR_PANULLPTR);
  }

#if NETWIB_DEBUG_MEM_CORRUPT==0
  *pptr = malloc(allocsize);
  if (*pptr == NULL)
    return(NETWIB_ERR_FUMALLOC);
#else
  netwib_er(netwib_debug_memcorrupt_alloc(allocsize, pptr));
  netwib_er(netwib_debug_memcorrupt_check_periodic());
#endif
#if NETWIB_DEBUG_LEAK!=0
  netwib_er(netwib_debug_leak_add_mem(allocsize, *pptr));
#endif

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwib_priv_mem_realloc(netwib_uint32 newallocsize,
                                   netwib_ptr *pptr)
{
  if (pptr == NULL) {
    return(NETWIB_ERR_PANULLPTR);
  }

#if NETWIB_DEBUG_LEAK!=0
  netwib_er(netwib_debug_leak_del_mem(*pptr));
#endif
#if NETWIB_DEBUG_MEM_CORRUPT==0
  *pptr = realloc(*pptr, newallocsize);
  if (*pptr == NULL)
    return(NETWIB_ERR_FUREALLOC);
#else
  netwib_er(netwib_debug_memcorrupt_realloc(newallocsize, pptr));
  netwib_er(netwib_debug_memcorrupt_check_periodic());
#endif
#if NETWIB_DEBUG_LEAK!=0
  netwib_er(netwib_debug_leak_add_mem(newallocsize, *pptr));
#endif

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwib_priv_mem_free(netwib_ptr *pptr)
{
  if (pptr == NULL) {
    return(NETWIB_ERR_PANULLPTR);
  }

#if NETWIB_DEBUG_LEAK!=0
  netwib_er(netwib_debug_leak_del_mem(*pptr));
#endif
#if NETWIB_DEBUG_MEM_CORRUPT==0
  free(*pptr);
#else
  netwib_er(netwib_debug_memcorrupt_free(pptr));
  netwib_er(netwib_debug_memcorrupt_check_periodic());
#endif

  *pptr = NULL;
  return(NETWIB_ERR_OK);
}


