/*
                                  NETWIB
                             Network library
                Copyright(c) 1999-2005 Laurent Constantin
                                  -----

  Main server    : http://www.laurentconstantin.com/
  Backup servers : http://go.to/laurentconstantin/
                   http://laurentconstantin.est-la.com/
                   http://laurentconstantin.free.fr/
                   http://membres.lycos.fr/lauconstantin/
  [my current email address is on the web servers]

                                  -----
  This file is part of Netwib.

  Netwib is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  version 2 as published by the Free Software Foundation.

  Netwib is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details (http://www.gnu.org/).

------------------------------------------------------------------------
*/

#include <netwib/inc/maininc.h>

/*-------------------------------------------------------------*/
#define NETWIB_PRIV_ALLOWEDCHARS_NULL NULL
netwib_err netwib_char_init_kbd(netwib_constbuf *pmessage,
                                netwib_constbuf *pallowedchars,
                                netwib_char defaultchar,
                                netwib_char *pchar)
{
  netwib_char c, prompt;
  netwib_string allowedchars;
  netwib_bool havemessage;
  netwib_priv_kbd kbd;

  /* parameters verification */
  allowedchars = NETWIB_PRIV_ALLOWEDCHARS_NULL;
  if (pallowedchars != NULL) {
    netwib__buf_ref_string(pallowedchars, allowedchars, bufstorage,
                           netwib_char_init_kbd(pmessage, &bufstorage,
                                                defaultchar, pchar));
    if (defaultchar != NETWIB_CHAR_INIT_KBD_NODEF) {
      if (!netwib_c_strchr(allowedchars, defaultchar)) {
        return(NETWIB_ERR_PAINVALIDDEFAULT);
      }
    }
  }

  havemessage = NETWIB_FALSE;
  if (netwib__buf_ref_data_sizenull(pmessage) != 0) {
    havemessage = NETWIB_TRUE;
  }

  /* ask user */
  c = 0;
  prompt = ':';
  netwib_er(netwib_priv_kbd_initdefault(&kbd));
  netwib_er(netwib_priv_kbd_ctl_set_echoline(&kbd, NETWIB_TRUE, NETWIB_FALSE));
  while (NETWIB_TRUE) {
    if (havemessage) {
      if (allowedchars != NETWIB_PRIV_ALLOWEDCHARS_NULL &&
          defaultchar != NETWIB_CHAR_INIT_KBD_NODEF) {
        netwib_er(netwib_fmt_display("%{buf} (key in %s)[%c]%c ", pmessage,
                                     allowedchars, defaultchar, prompt));
      } else if (allowedchars != NETWIB_PRIV_ALLOWEDCHARS_NULL) {
        netwib_er(netwib_fmt_display("%{buf} (key in %s)%c ", pmessage,
                                     allowedchars, prompt));
      } else if (defaultchar != NETWIB_CHAR_INIT_KBD_NODEF) {
        netwib_er(netwib_fmt_display("%{buf} [%c]%c ", pmessage,
                                     defaultchar, prompt));
      } else {
        netwib_er(netwib_fmt_display("%{buf}%c ", pmessage, prompt));
      }
    }
    netwib_er(netwib_priv_kbd_read_key(&kbd, &c));
    if (c == 0x0D || c == 0x0A) {
      if (defaultchar != NETWIB_CHAR_INIT_KBD_NODEF) {
        c = defaultchar;
        break;
      }
    } else {
      if (havemessage) {
        netwib_er(netwib_fmt_display("\n"));
      }
    }
    if (allowedchars == NETWIB_PRIV_ALLOWEDCHARS_NULL) {
      break;
    }
    if (netwib_c_strchr(allowedchars, c)) {
      break;
    }
    prompt = '>';
  }
  netwib_er(netwib_priv_kbd_close(&kbd));

  if (pchar != NULL) *pchar = c;
  return(NETWIB_ERR_OK);
}
