/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include "SessionsCache.h"
#include <stdio.h>


SslSession::SslSession(const SslSession & other)
{
	m_sess = NULL;
	set_session(other.m_sess);
}

SslSession::SslSession()
{
	m_sess = NULL;
}

SslSession::~SslSession()
{
	if(m_sess)
		SSL_SESSION_free(m_sess);
}

bool SslSession::operator=(const SslSession & other)
{
	set_session(other.m_sess);
	return true;
}

void SslSession::set_session(SSL_SESSION * sess)
{
	if(m_sess)
	{
		SSL_SESSION_free(m_sess);
		m_sess = NULL;
	}
	if(sess)
	{
		m_sess = sess;
		CRYPTO_add(&m_sess->references, 1, CRYPTO_LOCK_SSL_SESSION);
	}
}

SSL_SESSION * SslSession::get_session() const
{
	if(!m_sess)
		return NULL;

	CRYPTO_add(&m_sess->references, 1, CRYPTO_LOCK_SSL_SESSION);
	return m_sess;
}

const char * SslSession::id2sz(SSL_SESSION * sess)
{
	static char str[(SSL_MAX_SSL_SESSION_ID_LENGTH+1)*2];
	char *cp;
	size_t n;
	cp = str;
	for (n = 0; n < sess->session_id_length && n < SSL_MAX_SSL_SESSION_ID_LENGTH; n++)
	{
		snprintf(cp, sizeof(str)-(cp-str), "%02X", sess->session_id[n]);
		cp += 2;
	}
	*cp = '\0';
	return str;
}












SessionsCache::SessionsCache()
{
	m_sessionsCtr = 0;
}

SessionsCache::~SessionsCache()
{

}

void SessionsCache::add_session(const mString & key, SSL_SESSION * sess)
{
	m_cacheLock.EnterCS();
	m_sessionsCtr++;
	if(sess)
	{
		if(m_cache.find(key) == m_cache.end())
		{
			m_cache[key] = SslSession();
		}
		m_cache[key].set_session(sess);
	}
	m_cacheLock.LeaveCS();
}

SSL_SESSION * SessionsCache::get_session(const mString & key)
{
	SSL_SESSION * ret;

	m_cacheLock.EnterCS();
	if(m_cache.find(key) != m_cache.end())
	{
		ret = m_cache[key].get_session();
	}
	else
	{
		ret = NULL;
	}
	m_cacheLock.LeaveCS();
	return ret;
}

void SessionsCache::delete_session(const mString & key)
{
	std::map<mString, SslSession>::iterator sess;

	m_cacheLock.EnterCS();
	sess = m_cache.find(key);

	if(sess != m_cache.end())
	{
		m_cache.erase(sess);
	}
	m_cacheLock.LeaveCS();
}

void SessionsCache::generate_id(mString & id, const mString & Server, const mString & dn, unsigned short Port)
{
	unsigned char md5[MD5_DIGEST_LENGTH];
	char tt[sizeof(long)*4+1];
	MD5_CTX ctx;

	MD5_Init(&ctx);
	MD5_Update(&ctx, Server.c_str(), Server.size());
	if(dn.size())
	{
		MD5_Update(&ctx, dn.c_str(), dn.size());
	}
	MD5_Update(&ctx, &Port, sizeof(Port));
	MD5_Final(md5, &ctx);

	for(int i=0; i<MD5_DIGEST_LENGTH; i++)
	{
		sprintf(tt, "%x", md5[i]);
		id += tt;
	}
}

unsigned long SessionsCache::get_numberOfSessions()
{
	return m_sessionsCtr;
}

void SessionsCache::clean()
{
	m_cacheLock.EnterCS();
	m_cache.clear();
	m_cacheLock.LeaveCS();
}
