/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.CharSeq;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Writer;
import java.util.Collection;

public class FString
extends SimpleVector
implements CharSeq,
Externalizable,
Consumable {
    public char[] data;
    protected static char[] empty = new char[0];

    public FString() {
        this.data = empty;
    }

    public FString(int num) {
        this.size = num;
        this.data = new char[num];
    }

    public FString(int num, char value) {
        char[] array = new char[num];
        this.data = array;
        this.size = num;
        while (--num >= 0) {
            array[num] = value;
        }
    }

    public FString(char[] values) {
        this.size = values.length;
        this.data = values;
    }

    public FString(String str) {
        this.data = str.toCharArray();
        this.size = this.data.length;
    }

    public FString(StringBuffer buffer) {
        this(buffer, 0, buffer.length());
    }

    public FString(StringBuffer buffer, int offset, int length) {
        this.size = length;
        this.data = new char[length];
        if (length > 0) {
            buffer.getChars(offset, offset + length, this.data, 0);
        }
    }

    public FString(char[] buffer, int offset, int length) {
        this.size = length;
        this.data = new char[length];
        System.arraycopy(buffer, offset, this.data, 0, length);
    }

    public FString(Sequence seq) {
        this.data = new char[seq.size()];
        this.addAll((Collection)seq);
    }

    public FString(CharSeq seq) {
        int size = seq.size();
        char[] data = new char[size];
        seq.getChars(0, size, data, 0);
        this.data = data;
        this.size = size;
    }

    public FString(CharSeq seq, int offset, int length) {
        char[] data = new char[length];
        seq.getChars(offset, offset + length, data, 0);
        this.data = data;
        this.size = length;
    }

    public int length() {
        return this.size;
    }

    public int getBufferLength() {
        return this.data.length;
    }

    public void setBufferLength(int length) {
        int oldLength = this.data.length;
        if (oldLength != length) {
            char[] tmp = new char[length];
            System.arraycopy(this.data, 0, tmp, 0, oldLength < length ? oldLength : length);
            this.data = tmp;
        }
    }

    protected Object getBuffer() {
        return this.data;
    }

    public final Object getBuffer(int index) {
        return Convert.toObject(this.data[index]);
    }

    public final Object setBuffer(int index, Object value) {
        Object old = Convert.toObject(this.data[index]);
        this.data[index] = Convert.toChar(value);
        return old;
    }

    public final Object get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return Convert.toObject(this.data[index]);
    }

    public final char charAt(int index) {
        if (index >= this.size) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public final char charAtBuffer(int index) {
        return this.data[index];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0 || srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.size) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (dstBegin + srcEnd - srcBegin > dst.length) {
            throw new StringIndexOutOfBoundsException(dstBegin);
        }
        if (srcBegin < srcEnd) {
            System.arraycopy(this.data, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }
    }

    public void getChars(int srcBegin, int srcEnd, StringBuffer dst) {
        if (srcBegin < 0 || srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.size) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin < srcEnd) {
            dst.append(this.data, srcBegin, srcEnd - srcBegin);
        }
    }

    public char[] toCharArray() {
        int seq_length = this.size;
        int val_length = this.data.length;
        if (seq_length == val_length) {
            return this.data;
        }
        char[] tmp = new char[seq_length];
        System.arraycopy(this.data, 0, tmp, 0, seq_length);
        return tmp;
    }

    public void shift(int srcStart, int dstStart, int count) {
        System.arraycopy(this.data, srcStart, this.data, dstStart, count);
    }

    public FString copy(int start, int end) {
        char[] copy2 = new char[end - start];
        for (int i = start; i < end; ++i) {
            copy2[i - start] = this.data[i];
        }
        return new FString(copy2);
    }

    public String toString() {
        return new String(this.data, 0, this.size);
    }

    public String substring(int start, int end) {
        return new String(this.data, start, end - start);
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.size) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.data[index] = ch;
    }

    public void setCharAtBuffer(int index, char ch) {
        this.data[index] = ch;
    }

    public final void fill(char ch) {
        int i = this.size;
        while (--i >= 0) {
            this.data[i] = ch;
        }
    }

    public void fill(int fromIndex, int toIndex, char value) {
        if (fromIndex < 0 || toIndex > this.size) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            this.data[i] = value;
        }
    }

    protected void clearBuffer(int start, int count) {
        while (--count >= 0) {
            this.data[start++] = '\u0000';
        }
    }

    public void replace(int where, char[] chars, int start, int count) {
        System.arraycopy(chars, start, this.data, where, count);
    }

    public void replace(int where, String string) {
        string.getChars(0, string.length(), this.data, where);
    }

    public int hashCode() {
        char[] val = this.data;
        int len = this.size;
        int hash = 0;
        for (int i = 0; i < len; ++i) {
            hash = 31 * hash + val[i];
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FString)) {
            return false;
        }
        char[] str = ((FString)obj).data;
        int n = this.size;
        if (str == null || str.length != n) {
            return false;
        }
        int i = n;
        while (--i >= 0) {
            if (this.data[i] == str[i]) continue;
            return false;
        }
        return true;
    }

    public int getElementKind() {
        return 29;
    }

    public void consume(Consumer out) {
        out.write(this.data, 0, this.data.length);
    }

    public boolean consumeNext(int ipos, Object xpos, Consumer out) {
        int index = ipos >>> 1;
        if (index >= this.size) {
            return false;
        }
        out.writeChar(this.data[index]);
        return true;
    }

    protected void consume(int iposStart, Object xposStart, int iposEnd, Object xposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int i = iposStart >>> 1;
        int end = iposEnd >>> 1;
        out.write(this.data, i, end - i);
    }

    public void writeTo(int start, int count, Writer dest) throws IOException {
        dest.write(this.data, start, count);
    }

    public void writeTo(Writer dest) throws IOException {
        dest.write(this.data, 0, this.size);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeChar(this.data[i]);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        char[] data = new char[size];
        for (int i = 0; i < size; ++i) {
            data[i] = in.readChar();
        }
        this.data = data;
        this.size = size;
    }
}

