/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.locator;

import gnu.mapping.Procedure;
import gnu.mapping.WrongType;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import nice.lang.rawArray;
import nice.tools.locator.Locator;
import nice.tools.locator.dispatch;

public class fun {
    public static URL url(File f) {
        String path = f.getPath();
        if (path.endsWith(".jar")) {
            return new URL("jar", "", nice.lang.dispatch.$$002b(nice.lang.dispatch.$$002b("file:", path), "!/"));
        }
        return f.toURL();
    }

    public static URL[] parsePath(String path, Procedure warning) {
        URL[] uRLArray;
        ArrayList<URL> components = new ArrayList<URL>();
        int start = 0;
        while (start < path.length() && path.charAt(start) == File.pathSeparatorChar) {
            ++start;
        }
        while (start < path.length()) {
            String pathComponent;
            int end = path.indexOf(File.pathSeparatorChar, start);
            if (end == -1) {
                end = path.length();
            }
            if ((pathComponent = path.substring(start, end)).length() > 0) {
                try {
                    File f = nice.tools.util.System.getFile(pathComponent);
                    if (f.canRead()) {
                        components.add(dispatch.url(f.getCanonicalFile()));
                    } else if (!f.exists()) {
                        warning.apply1(nice.lang.dispatch.$$002b(nice.lang.dispatch.$$002b("Path component ", pathComponent), " does not exist"));
                    } else {
                        warning.apply1(nice.lang.dispatch.$$002b(nice.lang.dispatch.$$002b("Path component ", pathComponent), " is not readable"));
                    }
                }
                catch (MalformedURLException e) {
                    warning.apply1(nice.lang.dispatch.$$002b(nice.lang.dispatch.$$002b("Path component ", pathComponent), " is invalid"));
                }
                catch (IOException e) {
                    warning.apply1(nice.lang.dispatch.$$002b(nice.lang.dispatch.$$002b("Path component ", pathComponent), " is invalid"));
                }
            }
            start = end + 1;
        }
        Object[] objectArray = components.toArray();
        if (objectArray != null) {
            int n = objectArray.length;
            URL[] uRLArray2 = new URL[n];
            System.arraycopy(objectArray, 0, uRLArray2, 0, n);
            uRLArray = uRLArray2;
        } else {
            uRLArray = null;
        }
        return uRLArray;
    }

    public static String toString(Object this_) {
        return nice.lang.dispatch.$$002b(this_.getClass().getName(), nice.lang.dispatch.$$002b(": ", Arrays.asList(((Locator)this_).path).toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URLConnection get(Locator this_, String resource) {
        Iterator for_in_iter_23_17 = nice.lang.dispatch.forIterator(rawArray.make(this_.path));
        while (for_in_iter_23_17.hasNext()) {
            URL base;
            try {
                base = (URL)for_in_iter_23_17.next();
            }
            catch (ClassCastException classCastException) {
                throw WrongType.make(classCastException, "nice.tools.code.EnsureTypeProc", -3);
            }
            try {
                URL url = new URL(base, resource);
                URLConnection connection = url.openConnection();
                if (connection == null) continue;
                connection.connect();
                return connection;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }
}

