/*
 * Decompiled with CFR 0.152.
 */
package nice.lang.inline;

import bossa.util.User;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Procedure2;

public class BoolOp
extends Procedure2
implements Inlineable {
    private static final int And = 1;
    private static final int Or = 2;
    private static final int Xor = 3;
    private static final int Eq = 4;
    private final int kind;
    private static final Type retType = Type.boolean_type;

    public static BoolOp create(String param) {
        int kind = 0;
        if ("&".equals(param)) {
            kind = 1;
        } else if ("|".equals(param)) {
            kind = 2;
        } else if ("^".equals(param)) {
            kind = 3;
        } else if ("==".equals(param)) {
            kind = 4;
        } else {
            User.error("Unknown inlined boolean operator " + param);
        }
        return new BoolOp(kind);
    }

    private BoolOp(int kind) {
        this.kind = kind;
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        StackTarget stack = new StackTarget(Type.boolean_type);
        args[0].compile(comp, stack);
        args[1].compile(comp, stack);
        switch (this.kind) {
            case 1: {
                code.emitAnd();
                break;
            }
            case 2: {
                code.emitIOr();
                break;
            }
            case 3: {
                code.emitXOr();
                break;
            }
            case 4: {
                code.emitXOr();
                code.emitPushConstant(1, Type.int_type);
                code.emitXOr();
            }
        }
        target.compileFromStack(comp, retType);
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return retType;
    }

    @Override
    public Object apply2(Object arg1, Object arg2) {
        throw new Error("Not implemented");
    }
}

