/*
   This function makes path relative to the base directory
*/
gchar *get_relative_path( const gchar *base, const gchar *path)
{
        g_return_val_if_fail(base != NULL && path != NULL, NULL);

        if (!g_path_is_absolute(base))
                return NULL;
        if (!g_path_is_absolute(path))
                return g_strdup(path);

#ifdef G_OS_WIN32
        if (g_ascii_isalpha(path[0]) && g_ascii_isalpha(base[0]) &&
                path[0] != base[0])
                        return g_strdup(path);
#endif

        gchar *path_tmp = g_strdup(g_path_skip_root(path));
        gchar *base_tmp = g_strdup(g_path_skip_root(base));
        // This check must be done because g_path_skip_root() consider
        // that "/somedir/" is relative!
        if (path_tmp == NULL) {
#ifdef G_OS_WIN32
                if (path[0] == '/')
                        path_tmp = g_strdup(path+1);
                else
#endif
                        path_tmp = g_strdup(path);
        }
        if (base_tmp == NULL) {
#ifdef G_OS_WIN32
                if (path[0] == '/')
                        base_tmp = g_strdup(base+1);
                else
#endif
                        base_tmp = g_strdup(base);
        }

        gchar *path_unix = g_strdelimit(path_tmp, "\\", '/');
        gchar *base_unix = g_strdelimit(base_tmp, "\\", '/');

        gchar **path_components = g_strsplit(path_unix, "/", 256);
        gchar **base_components = g_strsplit(base_unix, "/", 256);

        g_free(path_tmp);
        g_free(base_tmp);

        int i;
        for (i=0; path_components[i] != NULL && base_components[i] != NULL &&
                      strcmp(path_components[i],base_components[i]) == 0;
i++);

        gchar *path_tail = g_strjoinv(G_DIR_SEPARATOR_S, path_components+i);

        gchar *relative_path =
g_new(char,strlen(path_tail)+256*3*sizeof(gchar));
        gchar *tmp_pointer = relative_path;
        for (int j=i; base_components[j] != NULL; j++)
                tmp_pointer = g_stpcpy(tmp_pointer, "..\\");

        g_stpcpy(tmp_pointer, path_tail);

        g_free(path_tail);

        g_strfreev(base_components);
        g_strfreev(path_components);
        return relative_path;
}
