#ifndef __NJAMD_FE_LIBCWRAP_H__
#define __NJAMD_FE_LIBCWRAP_H__

/*
 * NJAMD internal libc wrappers: Standardizes behavior of various libc
 * functions and provides extra functionality where appropriate.
 */

#define NJ_ERRNO_WARN warn("%s", strerror(errno))
#define NJ_ERRNO_ERR  err("%s", strerror(errno))
#define NJ_MAX(x, y) (x) > (y) ? (x) : (y)

#define njAccept(s, addr, addrlen) \
		__njAccept(s, addr, addrlen, __FUNCTION__, __FILE__, __LINE__)
#define njBind(s, addr, addrlen) \
		__njBind(s, addr, addrlen, __FUNCTION__, __FILE__, __LINE__)
#define njClose(fd) \
		__njClose(fd, __FUNCTION__, __FILE__, __LINE__)
#define njDup2(oldfd, newfd) \
		__njDup2(oldfd, newfd, __FUNCTION__, __FILE__, __LINE__)
#define njExecvp(file, argv) \
		__njExecvp(file, argv, __FUNCTION__, __FILE__, __LINE__)
#define njFork() \
		__njFork(__FUNCTION__, __FILE__, __LINE__)
#define njFree(ptr) \
		if ((ptr) != NULL) { free(ptr); (ptr) = NULL; }
#define njGetSockName(s, addr, addrlen) \
		__njGetSockName(s, addr, addrlen, __FUNCTION__, __FILE__, __LINE__)
#define njListen(s, backlog) \
		__njListen(s, backlog, __FUNCTION__, __FILE__, __LINE__)
#define njMalloc(size) \
		__njMalloc(size, __FUNCTION__, __FILE__, __LINE__)
#define njPipe(filedes) \
		__njPipe(filedes, __FUNCTION__, __FILE__, __LINE__)
#define njRead(fd, buf, count) \
		__njRead(fd, buf, count, __FUNCTION__, __FILE__, __LINE__)
#define njSelect(n, readfds, writefds, exceptfds, timeout) \
		__njSelect(n, readfds, writefds, exceptfds, timeout, \
		__FUNCTION__, __FILE__, __LINE__)
#define njSetenv(name, value, overwrite) \
		__njSetenv(name, value, overwrite, __FUNCTION__, __FILE__, __LINE__)
#define njSignal(signum, handler) \
		__njSignal(signum, handler, __FUNCTION__, __FILE__, __LINE__)
#define njSocket(domain, type, protocol) \
		__njSocket(domain, type, protocol, __FUNCTION__, __FILE__, __LINE__)
#define njStrdup(str) \
		__njStrdup(str, __FUNCTION__, __FILE__, __LINE__)
#define njWrite(fd, buf, count) \
		__njWrite(fd, buf, count, __FUNCTION__, __FILE__, __LINE__)

extern int __njAccept(int s, struct sockaddr* addr, size_t* addrlen,
		const char* fn, const char* file, int line);
extern int __njBind(int s, struct sockaddr* addr, size_t addrlen,
		const char* fn, const char* file, int line);
extern int __njClose(int fd, const char* fn, const char* file, int line);
extern int __njDup2(int oldfd, int newfd, const char* fn, const char* file,
		int line);
extern int __njExecvp(const char* exe, char *const argv[], const char* fn,
		const char* file, int line);
extern pid_t __njFork(const char* fn, const char* file, int line);
extern int __njGetSockName(int s, struct sockaddr* addr, size_t* addrlen,
		const char* fn, const char* file, int line);
extern int __njListen(int s, int backlog, const char* fn, const char* file,
		int line);
extern void* __njMalloc(size_t size, const char* fn, const char* file,
		int line);
extern int __njPipe(int filedes[2], const char* fn, const char* file,
		int line);
extern ssize_t __njRead  (int fd, void* buf, size_t count, const char* fn,
		const char* file, int line);
extern int __njSelect(int n, fd_set* readfds, fd_set* writefds,
		fd_set* exceptfds, struct timeval* timeout, const char* fn,
		const char* file, int line);
extern int __njSetenv(const char* name, const char* value, int overwrite,
		const char* fn, const char* file, int line);
extern void (*__njSignal(int signum, void (*handler)(int),
		const char* fn, const char* file, int line))(int);
extern int __njSocket(int domain, int type, int protocol, const char* fn,
		const char* file, int line);
extern char* __njStrdup(const char* s, const char* fn, const char* file,
		int line);
extern ssize_t __njWrite (int fd, const void* buf, size_t count,
		const char* fn, const char* file, int line);

#endif /* __NJAMD_FE_LIBCWRAP_H__ */
