/**
 * @file threads.h
 *
 * Handles pthreads
 *
 */
#ifndef __NJ_LIB_THREADS_H__
#define __NJ_LIB_THREADS_H__
#include <config.h>

#ifdef _THREAD_SAFE
# include <pthread.h>
#endif

#include <lib/libc_syms.h>
#include <unistd.h>

/** Passed to the real pthread_create so we know all thread's starting
 * points.
 * @see pthread_create() __nj_pthread_launch() */
struct pthread_arg_wrapper
{
	void *(*start)(void *); /**< Always __nj_pthread_launch() */
	void *real_arg;			/**< The user's actual arg */
	struct nj_threads *threads;
};

struct nj_threads
{
	void (*libc_pthread_exit)(void *);
#ifdef _THREAD_SAFE
	int  (*libc_pthread_create)(pthread_t  *  thread, pthread_attr_t *attr,
			void * (*start_routine)(void *), void *);
	pthread_mutex_t 			launch_lock;
#endif

};

void __nj_threads_bootstrap_init(struct nj_threads *, struct nj_libc_syms *);
void __nj_threads_user_init(struct nj_threads *);
void __nj_threads_fini(struct nj_threads *);
#ifdef _THREAD_SAFE
int __nj_threads_create_thread(struct nj_threads *, pthread_t  *, pthread_attr_t *, void * (*start_routine)(void *), void *);
#endif
void *__nj_threads_launch(void *);
void __nj_threads_launch_end(void);

#endif /* output.h */
// vim:ts=4
