/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#include "DoStmt.h"
#include "Bytecode.h"
#include "CheckState.h"
#include "JumpStmt.h"

DoStmt::DoStmt(Condition *c, Stmt *s)
{
	fCondition = c;
	fBody = s;
}


DoStmt::~DoStmt()
{
	delete fCondition;
	delete fBody;
}


bool DoStmt::Check(CheckState &state)
{
	bool ok = true;
	bool v;
	
	state.fLoopDepth++;
	
	if (!fBody->Check(state)) ok = false;

	if (fCondition->Evaluate(v) && (v==false) && fBody->IsNullable())
		fNullable = true;
	else
		fNullable = false;
		
	state.fLoopDepth--;
	return ok;
}


void DoStmt::Emit(Bytecode &b)
{
	int cTarget, bTarget;
	int sLabel;
	
	/*
	 sLabel:
	 	fBody
	 cLabel:
	 	test -> sLabel
	 bLabel:
	*/
	
	b.PushLoopContext();
	
	sLabel = b.NewLabel();
	b.SetLabel(sLabel);
	
	fBody->Emit(b);
	cTarget = b.GetLength();
	fCondition->Emit(b, sLabel);
	bTarget = b.GetLength();
	
	b.PopLoopContext(cTarget, bTarget);
}

DoStmt* DoStmt::Clone(Mapping *b) const
{
	return new DoStmt(fCondition->Clone(b), fBody->Clone(b));
}
