/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#include "Stmt.h"

Stmt::~Stmt()
{
}


void Stmt::Emit(Bytecode &b)
{
	// this is where to hook general-purpose emit code that
	// applies to all statements.  For now, just call EmitActual()
	EmitActual(b);
}


void Stmt::ComputeNullable()
{
	Stmt *s;
	
	fNullable = false;
	
	for(s=GetChildren(); s; s=s->GetNext())
		s->ComputeNullable();
}


Stmt* LeafStmt::GetChildren()
{
	return 0;
}


ChainStmt::~ChainStmt()
{
	delete fBody;
}


Stmt* ChainStmt::GetChildren()
{
	return fBody;
}


BinaryStmt::BinaryStmt(Stmt *s1, Stmt *s2) :
	fPrimary(s1), fSecondary(s2)
{
	if (s2)
	{
		// this is a hack to get fBody and fHandler linked together
		PListSS<Stmt> list;
		
		list.InsertHead(s2);
		list.InsertHead(s1);
	}
}


BinaryStmt::~BinaryStmt()
{
	delete fPrimary;
	delete fSecondary;
}


Stmt *BinaryStmt::GetChildren()
{
	return fPrimary;
}


#ifdef DEBUG
#include <stdio.h>
#include <typeinfo>

void DumpStmt(Stmt *s, int tab)
{
	for(int i=0; i<tab; i++)
		putchar(' ');
	printf("%s  %08x\n", typeid(*s).name(), s);
	
	for(Stmt*c = s->GetChildren(); c; c=c->GetNext())
	{
		DumpStmt(c, tab + 2);
	}
}
#endif
