/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#include "RCX_Target.h"
#include "RCX_Constants.h"

static const class RCX_Target sTargets[] = {
	{
		kRCX_RCXTarget,	"RCX", 			"__RCX", "1",
		{ 0, 10, 0, 8, 0, 0, 0, 0 },
		32, 0, false, false, false, true
	},


	{
		kRCX_CMTarget,	"CyberMaster",	"__CM",	"1",
		{ 0, 4,	0, 4, 0, 0, 0, 0 },
		32, 0, false, false, false, true
	},


	{
		kRCX_ScoutTarget, "Scout",		"__SCOUT", "1",
		{ 0, 6,	0, 3, 0, 0, 0, 0 },
		10, 8, true, true, false, true
	},

	{
		kRCX_RCX2Target,	"RCX", 			"__RCX", "2",
		{ 0, 10, 0, 8, 0, 0, 0, 0 },
		32, 16, true, true, true, false
	},

	{
		kRCX_SpyboticsTarget,	"Spybotics", 		"__SPY", "1",
		{ 8, 8, 128, 32, 64, 16, 8, 8 },
		32, 4, true, true, true, false
	},
};

const RCX_Target *getTarget(RCX_TargetType type)
{
	// don't assume order of array matches types
	for(unsigned i=0; i<sizeof(sTargets)/sizeof(RCX_Target); ++i)
		if (sTargets[i].fType == type) return &sTargets[i];

	return 0;
};


bool RCX_Target::SourceWritable(int source) const
{
	// vars are always writable
	if (source == kRCX_VariableType) return true;
	
	// only RCX2/Spybotics support generic writable sources
	if (fType != kRCX_RCX2Target && fType != kRCX_SpyboticsTarget) return false;
	
	switch(source)
	{
		// these sources are writable for RCX 2
		case 0:	// shouldn't need this one..vars handled above
		case 1: // timer
		case 4: // random seed
		case 8: // program slot
		case 10:
		case 11:
		case 14:
		case 15:
		case 21:
		case 26:
		case 27:
		case 28:
		case 29:
		case 30:
		case 31:
		case 33: // UART settings
		case 36: // indirect
		
		case 37: // next 6 are for the datalog
		case 38:
		case 39:
		case 40:
		case 41:
		case 42:
			return true;
	}
	
	return false;
}


int RCX_Target::GetChunkLimit(RCX_ChunkType type) const
{
	if (type<0 || type>= kRCX_ChunkTypeCount) return 0;
	
	return fRanges[type].fBase + fRanges[type].fCount;
}
