/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern window_node *current_window;
extern buddylist_node *buddylist_head;
extern color_pref colors;
extern preferences pref;
extern char last_room_invite[];
extern char username[];
extern char password[];
extern void *handle;

void disconnect(void *c, const int error)
{
   alert("you have been disconnected from the AIM server.");
   clearbuddylist();
   update_buddywin();


   if(pref.auto_reconnect)
     {
	int i;

	sleep(5);
	info("Attempting to reconnect...");
	i = firetalk_signon(handle, NULL, 0, username, password);
	if(i == FE_SUCCESS)
	  info("Login Successful.");
	else
	  alert("Login Failed.");
     }
}

void doinit(void *c)
{
   info("Initializing...");
   firetalk_im_internal_add_buddy(c, username);
}

void error(void *c, const int error, const char * const roomoruser)
{
   wattrset(current_window->window, CP(colors.errfore, colors.errback)|A_BOLD);
   wprintw(current_window->window, "ERROR with %s : %s\n", roomoruser, firetalkerrors[error]);
   wrefresh(current_window->window);
   wattrset(current_window->window, CP(colors.mainfore, colors.mainback));
}

void got_info(void *c, const char * const who, const char * const info, const int warning, const int idle, const int flags)
{
   wattrset(current_window->window, CP(colors.warnfore, colors.warnback)|A_BOLD);
   wprintw(current_window->window, "%s warning: %d, idle time: %d info:\n", who, warning, idle);
   print_html(current_window, (char*)info);
   waddch(current_window->window, '\n');
   wattrset(current_window->window, CP(colors.mainfore, colors.mainback));
   wrefresh(current_window->window);
}

void set_idle(void *c, const int * const idle)
{
}

void eviled(void *c, const int newevil, const char * const eviler)
{
   wattrset(current_window->window, CP(colors.warnfore, colors.warnback)|A_BOLD);
   if(pref.verbose || pref.timestamp)
     {
	char tbuff[9];
	struct tm *time_info;
	time_t time_value;

	time_value = time(NULL);
	time_info = localtime(&time_value);
	strftime(tbuff, 9, "%X", time_info);
	wprintw(current_window->window, "%s ", tbuff);
     }

   wprintw(current_window->window, "%s has warned you to %d\%\n", eviler, newevil);
   wattrset(current_window->window, CP(colors.mainfore, colors.mainback));
   wrefresh(current_window->window);
}

void getaction(void *c, const char * const who, const int automessage, const char * const message)
{
}

void newnick(void *c, const char * const nickname)
{}

void passchanged(void *c)
{}

void user_nickchanged(void *c, const char * const oldnick, const char * const newnick)
{}

void listbuddy(void *c, const char * const nickname, const int online, const int away)
{
   int verbose = pref.verbose;

   pref.verbose = 0;
   if(online == FALSE)
     buddy_offline(c, nickname);
   else
     {
	pref.verbose = verbose;
	return;
     }
   pref.verbose = verbose;
}

void chat_joined(void *c, const char * const room)
{
   buddylist_node room_to_add;

   if(pref.verbose || pref.timestamp)
     {
	char tbuff[9];
	struct tm *time_info;
	time_t time_value;

	time_value = time(NULL);
	time_info = localtime(&time_value);
	strftime(tbuff, 9, "%X", time_info);
	wprintw(current_window->window, "%s ", tbuff);
     }

   strcpy(room_to_add.screenname, room);
   room_to_add.buddy_alias[0] = '\0';
   room_to_add.online = TRUE;
   room_to_add.away = FALSE;
   room_to_add.isroom = TRUE;
   room_to_add.idle_time = 0;

   if(addbuddytolist(room_to_add))
     alert("error adding room to list.");

   wattrset(current_window->window, CP(COLOR_MAGENTA, COLOR_BLACK)|A_BOLD);
   wprintw(current_window->window, "Joined room \"%s\"\n", room);
   wrefresh(current_window->window);
   wattrset(current_window->window, CP(colors.mainfore, colors.mainback));

   update_buddywin();
}

void chat_left(void *c, const char * const room)
{
   if(pref.verbose || pref.timestamp)
     {
	char tbuff[9];
	struct tm *time_info;
	time_t time_value;

	time_value = time(NULL);
	time_info = localtime(&time_value);
	strftime(tbuff, 9, "%X", time_info);
	wprintw(current_window->window, "%s ", tbuff);
     }

   removeroomfromlist(room);

   wattrset(current_window->window, CP(COLOR_MAGENTA, COLOR_BLACK)|A_BOLD);
   wprintw(current_window->window, "Left room \"%s\"\n", room);
   wrefresh(current_window->window);
   wattrset(current_window->window, CP(colors.mainfore, colors.mainback));

   update_buddywin();
}

void chat_invited(void *c, const char * const room, const char * const from, const char * message)
{
   if(pref.verbose || pref.timestamp)
     {
	char tbuff[9];
	struct tm *time_info;
	time_t time_value;

	time_value = time(NULL);
	time_info = localtime(&time_value);
	strftime(tbuff, 9, "%X", time_info);
	wprintw(current_window->window, "%s ", tbuff);
     }

   strcpy(last_room_invite, room);
   wattrset(current_window->window, CP(COLOR_MAGENTA, COLOR_BLACK)|A_BOLD);
   wprintw(current_window->window, "'%s' had invited you to room \"%s\" : %s\n", from, room, message);
   wrefresh(current_window->window);
   wattrset(current_window->window, CP(colors.mainfore, colors.mainback));
}

void chat_user_joined(void *c, const char * const room, const char * const who)
{
   if(pref.verbose || pref.timestamp)
     {
	char tbuff[9];
	struct tm *time_info;
	time_t time_value;

	time_value = time(NULL);
	time_info = localtime(&time_value);
	strftime(tbuff, 9, "%X", time_info);
	wprintw(current_window->window, "%s ", tbuff);
     }

   wattrset(current_window->window, CP(COLOR_MAGENTA, COLOR_BLACK)|A_BOLD);
   wprintw(current_window->window, "'%s' has joined you in room \"%s\"\n", who, room);
   wrefresh(current_window->window);
   wattrset(current_window->window, CP(colors.mainfore, colors.mainback));
}

void chat_user_left(void *c, const char * const room, const char * const who)
{
   if(pref.verbose || pref.timestamp)
     {
	char tbuff[9];
	struct tm *time_info;
	time_t time_value;

	time_value = time(NULL);
	time_info = localtime(&time_value);
	strftime(tbuff, 9, "%X", time_info);
	wprintw(current_window->window, "%s ", tbuff);
     }

   wattrset(current_window->window, CP(COLOR_MAGENTA, COLOR_BLACK)|A_BOLD);
   wprintw(current_window->window, "'%s' has left room \"%s\"\n", who, room);
   wrefresh(current_window->window);
   wattrset(current_window->window, CP(colors.mainfore, colors.mainback));
}
