/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
    
     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 
     of the License, or (at your option) any later version.
    
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
    
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  */
#ifndef _NTAIM_H
#define _NTAIM_H

/* the ntaim.c header file */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <sys/stat.h>
#include <errno.h>
#include <curses.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <ctype.h>
#include "firetalk.h"

/* Debugging stuff */
//#define DEBUG /* Turn this off if you don't want debugging */
#define DEBUG_PERM 0644
#define DEBUG_PATH "/tmp/ntaim-debug.log"
#ifdef DEBUG
#define MALLOC(x, y) debug_malloc(x, y)
#define FREE(x, y) debug_free(x, y)
#else
#define MALLOC(x, y) malloc(x)
#define FREE(x, y) free(x)
#endif

//#define RESIZEABLE 1
//#define HASRESIZETERM 1

/* generic stuff */
#ifndef CTRL
#define CTRL(x) ((x)&31)
#endif

#define STDIN 0
#define print(x) write(1, x, strlen(x))
#define MAX_SCREENNAME_SIZE 17
#define MAX_MESSAGE 1024

/* for tard tips */
#define TARDTIPCREATE 0
#define TARDTIPDESTROY 1

/* for buddy scrolling */
#define SCROLLLEFT 0
#define SCROLLRIGHT 1

/* for logging */
#define SEND 0
#define RECIEVE 1

/* for command aliases */
#define MAXMATCHES 10
#define MAXCOMMLENGTH 128 /* these can't be greater than this def */
#define MAXALIASNAME 64
#define MAXCOMMANDSTRING 128

/* for buddypounce */
#define SIGNON 1
#define SIGNOFF 2
#define GOAWAY 4
#define UNAWAY 8
#define UNIDLE 16

#define SEND_MESSAGE 1
#define BEEP 2
#define CALL_PROGRAM 3

/* for tab stuff */
#define TABSUCCESS 1
#define TABFAILURE 0
#define TABNOSPACE 2

/* for file stuff */
#define PATHSIZE 256
#define DOTTAIMPERM 0755
#define NTAIMPERM 0755

/* for matching color pairs */
#define CP(x,y) COLOR_PAIR( x * 8 + y + 1 )

typedef struct _color_pref
{
   unsigned short aliasfore;
   unsigned short aliasback;
   unsigned short sendfore;
   unsigned short sendback;
   unsigned short recvfore;
   unsigned short recvback;
   unsigned short errfore;
   unsigned short errback;
   unsigned short warnfore;
   unsigned short warnback;
   unsigned short helphdrfore;
   unsigned short helphdrback;
   unsigned short helpnamefore;
   unsigned short helpnameback;
   unsigned short helpusagefore;
   unsigned short helpusageback;
   unsigned short loginfore;
   unsigned short loginback;
   unsigned short alertfore;
   unsigned short alertback;
   unsigned short infofore;
   unsigned short infoback;
   unsigned short hstcntfore;
   unsigned short hstcntback;
   unsigned short upbudfore;
   unsigned short upbudback;
   unsigned short updenfore;
   unsigned short updenback;
   unsigned short tabfore;
   unsigned short tabback;
   unsigned short tardfore;
   unsigned short tardback;
   unsigned short budfore;
   unsigned short budback;
   unsigned short mainfore;
   unsigned short mainback;
   unsigned short chatfore;
   unsigned short chatback;
   unsigned short budwinfore;
   unsigned short budwinback;
   unsigned short helpfore;
   unsigned short helpback;
}color_pref;

typedef struct _commandalias_node
{
   char name[MAXALIASNAME];
   char command[MAXCOMMANDSTRING];
   struct _commandalias_node *next;
}commandalias_node;

typedef struct _buddylist_node
{
   char screenname[64];
   char stripedname[MAX_SCREENNAME_SIZE];
   char buddy_alias[64];
   char online:1;
   char away:1;
   char isroom:1;
   unsigned short idle_time;
   time_t when_last_awaymessage_sent;
   struct _buddylist_node *next;
   struct _buddylist_node *prev;
}buddylist_node;

typedef struct _preferences
{
   char beep:1;
   char verbose:1;
   char timestamp:1;
   char tardtips:1;
   char multi_windows:1;
   char window_popup_on_mesg:1;
   char logging:1;
   char auto_reconnect:1;
   char current_away_message;
   unsigned short away_timer; 
   unsigned short history_count;
}preferences;

typedef struct _history_node
{
   char *command;
   struct _history_node *next;
   struct _history_node *prev;
}history_node;

typedef struct _awaymessage_node
{
   char *message;
   struct _awaymessage_node *next;
}awaymessage_node;

typedef struct _window_node
{
   char screenname[MAX_SCREENNAME_SIZE]; /* striped name */
   WINDOW *window;
   char isroom;
   struct _window_node *next;
   struct _window_node *prev;
}window_node;

typedef struct _color_node
{
   unsigned short int foreground;
   unsigned short int background;
   struct _color_node *next;
}color_node;

/* buddy pounce stuff */
typedef struct _send_message_BP
{
   char whotosendto[MAX_SCREENNAME_SIZE];
   char *message;
}send_message_BP;

typedef union _BP_type
{
   send_message_BP send_message;
   char *command;
   int numberofbeeps;
}BP_type;

typedef struct _buddy_pounce_node
{
   unsigned int pounce_number;
   char who[MAX_SCREENNAME_SIZE];
   unsigned char type;
   unsigned char when;
   BP_type event;
   struct _buddy_pounce_node *next;
}buddy_pounce_node;
   
  
/* functions */
int addwindowtolist(char *screenname, char isroom);
int removewindowfromlist(window_node *toremove);
window_node *windowfor(char *screenname, char isroom);
int countcommands(void);
void addcommandalias(char *name, char *command);
void printcommandaliases(void);
void clearcommandaliases(void);
commandalias_node *findcommandalias(char *name);
void deletecommandalias(char *name);
int addbuddytolist(buddylist_node toadd);
int removebuddyfromlist(const char * const screenname);
int removeroomfromlist(const char * const room);
void savebuddylist(void);
void clearbuddylist(void);
void scroll_buddies(char *input_string, int currpos, unsigned short action);
void send_message(char *who, char *message, int autoreply);
void send_room_message(char *room, char *message, int autoreply);
void getmessage(void *c, const char * const who, const int automessage, const char * const message);
void display_help(void);
void login(void);
void alert(char *msg);
void info(char *msg);
int parse_text(char **args, char *string);
void load_pref(void);
void save_pref(void);
void checkfortaimdirectory(void);
inline void process_keypress(int c);
void shutdown_env(int sig);
void setup_env(void);
unsigned short path_init(void);
int saveawaymessages(void);
void clearawaymessages(void);
int addawaymessage(char *message);
void printawaymessages(void);
void loadawaymessages(void);
void removeawaymessage(int messagenumber);
awaymessage_node *setawaymessage(int anynumber);
int should_send_away_message(char *who);

unsigned short find_tabbed_string(char *string_to_find, char *input_string);

void handle_tard_tips(char *input_string, int currpos, unsigned short action);
void update_buddywin(void);
char *stripname(char *screenname);
int log_message(char *who, char *message, unsigned short send_recv);
int log_room_message(char *room, char *from, char *message);

/* basic stuff */
void disconnect(void *c, const int error);
void doinit(void *c);
void error(void *c, const int error, const char * const roomoruser);
void getmessage(void *c, const char * const who, const int automessage, const char * const message);
void getaction(void *c, const char * const who, const int automessage, const char * const message);
void buddy_online(void *c, const char * const who);
void buddy_offline(void *c, const char * const who);
void buddy_away(void *c, const char * const who);
void buddy_unaway(void *c, const char * const who);
void got_info(void *c, const char * const who, const char * const info, const int warning, const int idle, const int flags);
void got_idle(void *c, const char * const who, const long idletime);
void set_idle(void *c, const int * const idle);
void eviled(void *c, const int newevil, const char * const eviler);
void newnick(void *c, const char * const nickname);
void passchanged(void *c);
void user_nickchanged(void *c, const char * const oldnick, const char * const newnick);
void listbuddy(void *c, const char * const nickname, const int online, const int away);
void chat_joined(void *c, const char * const room);
void chat_left(void *c, const char * const room);
void chat_user_joined(void *c, const char * const room, const char * const who); 
void chat_user_left(void *c, const char * const room, const char * const who);
void chat_invited(void *c, const char * const room, const char * const from, const char * message);
void get_chatroom_message(void *c, const char * const room, const char * const from, const int automessage, const char * message);
  


/* history stuff */
int addhistorynode(char *command);
void clearhistory(void);

/* pretty damn good html parser :-) */
void print_html(window_node *toprint, char *html);
void push_colors(color_node *head_node, unsigned short int foreground, unsigned short int background);
color_node pop_colors(color_node *head_node);
color_node peek_colors(color_node *head_node);
int currentwordlength(char *string, int pos);

/* buddy pounce stuff */
void addbuddypouncenode(char **args, int numofargs);
void checkforbuddypounce(char *who, unsigned char when);
void print_pounces(void);
void remove_pounce(int pounce_number);

/* buddyaliases */
void addbuddyalias(char *screenname, char *alias);
char *getbuddyalias(char *screenname);
void savebuddyaliases(void);
buddylist_node *findbuddybyscreenname(char *screenname);
buddylist_node *findbuddybybuddy_alias(char *buddy_alias);

/* color functions */
int eat_whitey(int fd, char *temp);
int get_token(int fd, char *str, char *temp);
unsigned short get_colorname(unsigned short, char *);
unsigned short get_colornum(char *, unsigned short*);
unsigned short assign_name(char *, char *, char *);
unsigned short load_colors();
unsigned short save_colors(char *);

/* debug functions */
void debug_init();
void debug_close();
int itoa(char *s, int size, int i);
void *debug_malloc(size_t size, char *identity);
void debug_free(void *ptr, char *identity);

/* window resizing */
void resize_window(int sig);

void clearwindows(void);
void clearpounces(void);

void catch_alarm(int sig);

void saveinfo(char *info);
void loadinfo(void);

#endif
