/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#ifndef MIDI_IMPORT_DIALOG_H

#define MIDI_IMPORT_DIALOG_H
#include "config.h"
#include <gtk/gtk.h>



class NedMidiImportDialog {
	public:
		NedMidiImportDialog(GtkWindow *parent);
		void getValues(bool *state, bool *with_triplets, bool *with_single_triplets, int *voice_count,
			int *tempo_change_density, int *volume_change_density);
	private:
		static void OnClose(GtkDialog *dialog, gint result, gpointer data);
		static void triplet_modus_changed(GtkToggleButton *togglebutton, gpointer data);
		GtkWidget *m_with_triplet_box;
		GtkWidget *m_with_single_triplets_box;
		GtkWidget *m_voice_num_spin_box;
		GtkWidget *m_tempo_change_density_scale;
		GtkWidget *m_volume_change_density_scale;
		bool m_state;
		int m_with_triplets;
		int m_with_single_triplets;
		int m_tempo_change_density;
		int m_volume_change_density;
		int m_voice_num;
};

#endif /*  MIDI_IMPORT_DIALOG_H */
